/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.StringWidget;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.text.JTextComponent;

public class WatermarkedStringWidget
extends StringWidget {
    private boolean iIsEmpty = true;
    private final String fWatermark;

    public WatermarkedStringWidget(String string, String string2, int n, int n2, boolean bl, boolean bl2, Param param, Project project) {
        super(string, string2, n, n2, bl, bl2, param, project);
        this.fWatermark = param.getName();
        final JTextComponent jTextComponent = this.getField();
        this.setWaterMarkString();
        jTextComponent.setBorder(BorderFactory.createCompoundBorder(this.getField().getBorder(), BorderFactory.createEmptyBorder(1, 5, 1, 1)));
        if (project.getConfiguration().getParamAsString(param.getKey()) != null && !project.getConfiguration().getParamAsString(param.getKey()).equals(jTextComponent.getText())) {
            this.setPlainFont();
        }
        jTextComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (WatermarkedStringWidget.this.getData() == null || WatermarkedStringWidget.this.getData().trim().isEmpty()) {
                    jTextComponent.setText("");
                    WatermarkedStringWidget.this.setPlainFont();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WatermarkedStringWidget.this.iIsEmpty = jTextComponent.getText().trim().isEmpty();
                WatermarkedStringWidget.this.setData(jTextComponent.getText().trim());
                if (WatermarkedStringWidget.this.iIsEmpty) {
                    WatermarkedStringWidget.this.setWaterMarkString();
                } else {
                    WatermarkedStringWidget.this.setPlainFont();
                }
            }
        });
    }

    private void setWaterMarkString() {
        this.getField().setFont(FontUtils.getSystemUIFont().deriveFont(2));
        this.getField().setForeground(Color.GRAY);
        this.getField().setText(this.fWatermark);
    }

    private void setPlainFont() {
        this.getField().setForeground(Color.BLACK);
        this.getField().setFont(FontUtils.getSystemUIFont());
    }

    @Override
    public void setData(String string) {
        if (this.getField() != null) {
            if (string != null && !string.isEmpty()) {
                this.iIsEmpty = false;
                super.setData(string);
                this.getField().setText(string);
                this.setPlainFont();
                this.getField().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            } else {
                this.iIsEmpty = true;
                super.setData("");
                this.setWaterMarkString();
            }
        }
    }

    @Override
    public String getData() {
        return this.iIsEmpty ? "" : super.getData();
    }
}

