/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.FileSetRule;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IconFileChooserWidget
extends AbstractParamWidget<File> {
    private final MJPanel fComponent;
    private final MJLabel fLinkLabel;
    private final MJLabel fIconLabel;
    private File fIconFile;
    private final List<FileSetFilter> fFilters;
    MJLabel fEditLabel = new MJLabel("edit");
    private static final String DEFAULT_ICON_FILE = "c:\\matlab.ico";
    private static final String[] DEFAULT_FILE_FILTERS = new String[]{"ico", "jpeg", "jpg", "bmp", "tif", "tiff", "gif"};
    private Set<ChangeListener> fChangeListeners = new HashSet<ChangeListener>();

    public static FileSetFilter createFileSetFilter(String string, String ... stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        FileSetFilter fileSetFilter = new FileSetFilter(string);
        for (String string2 : stringArray) {
            fileSetFilter.addRule(new FileSetRule(string2, false));
        }
        return fileSetFilter;
    }

    public IconFileChooserWidget(Param param, Project project) {
        this(param, project, new ArrayList<FileSetFilter>(0), DEFAULT_ICON_FILE);
    }

    public IconFileChooserWidget(Param param, Project project, String string) {
        this(param, project, new ArrayList<FileSetFilter>(0), string);
    }

    public IconFileChooserWidget(Param param, Project project, List<FileSetFilter> list) {
        this(param, project, list, DEFAULT_ICON_FILE);
    }

    public IconFileChooserWidget(Param param, Project project, List<FileSetFilter> list, String string) {
        String string2 = string == null || string == "" ? DEFAULT_ICON_FILE : string;
        this.fIconFile = new File(string2);
        ImageIcon imageIcon = new ImageIcon(string2);
        this.fFilters = list == null ? new ArrayList<FileSetFilter>(0) : new ArrayList<FileSetFilter>(list);
        this.fLinkLabel = new MJLabel("Change icon");
        this.fLinkLabel.setVisible(false);
        this.fIconLabel = new MJLabel((Icon)imageIcon, 0);
        this.fIconLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IconFileChooserWidget.this.modifyIcon();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                IconFileChooserWidget.this.fEditLabel.setVisible(true);
                IconFileChooserWidget.this.fEditLabel.setOpaque(true);
                IconFileChooserWidget.this.fComponent.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                IconFileChooserWidget.this.fEditLabel.setVisible(false);
                IconFileChooserWidget.this.fComponent.repaint();
            }
        });
        this.fEditLabel.setBackground(Color.GRAY);
        this.fEditLabel.setVisible(false);
        this.fEditLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IconFileChooserWidget.this.modifyIcon();
            }
        });
        FormLayout formLayout = new FormLayout("3dlu,30dlu,3dlu", "10dlu,10dlu,10dlu");
        this.fComponent = new MJPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)this.fIconLabel, (Object)cellConstraints.xywh(1, 1, 3, 3));
        this.fComponent.add((Component)this.fEditLabel, (Object)cellConstraints.xywh(1, 2, 3, 1));
        this.fIconLabel.setName(param.getKey() + ".button");
        this.fLinkLabel.setName(param.getKey() + ".link");
        DetailedToolTip.install((Component)this.fIconLabel, project.getConfiguration(), param);
        DetailedToolTip.install((Component)this.fLinkLabel, project.getConfiguration(), param);
    }

    public void modifyIcon() {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        mJFileChooserPerPlatform.setDialogTitle("Select an image file");
        mJFileChooserPerPlatform.setCurrentDirectory(MatlabPath.getCurrentDirectory());
        mJFileChooserPerPlatform.setMultiSelectionEnabled(false);
        for (FileSetFilter fileSetFilter : this.fFilters) {
            mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)fileSetFilter);
        }
        mJFileChooserPerPlatform.setAcceptAllFileFilterUsed(false);
        mJFileChooserPerPlatform.showOpenDialog((Component)this.fIconLabel);
        if (mJFileChooserPerPlatform.getState() == 0) {
            this.setData(mJFileChooserPerPlatform.getSelectedFile());
        }
        this.fComponent.repaint();
    }

    public void setEnabled(boolean bl) {
        this.fLinkLabel.setEnabled(bl);
        this.fIconLabel.setEnabled(bl);
    }

    public void setData(File file) {
        if (file == null) {
            this.fIconFile = new File(DEFAULT_ICON_FILE);
            this.fIconLabel.setIcon((Icon)new ImageIcon(DEFAULT_ICON_FILE));
            this.fLinkLabel.setVisible(false);
            this.fComponent.repaint();
        } else {
            this.fIconFile = file;
            ImageIcon imageIcon = new ImageIcon(file.getPath());
            this.fIconLabel.setIcon((Icon)imageIcon);
            this.fLinkLabel.setVisible(false);
            this.fComponent.repaint();
        }
        this.changeEvent();
    }

    public File getData() {
        return this.fIconFile;
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        DetailedToolTip.uninstall((Component)this.fIconLabel);
        DetailedToolTip.uninstall((Component)this.fLinkLabel);
    }

    private void changeEvent() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }
}

