/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.settingsui.BatchComponentFilter;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

final class BatchingSettingsPanelBuilder
implements SettingsPanelBuilder {
    private final SettingsPanelBuilder fBuilder;
    private final List<SettingComponentDefinition> fBatch;
    private final ParameterRunnable<ProjectComponent> fComponentRegistry;
    private final BatchComponentFilter fBatchComponentFilter;
    private String fBatchCategoryName;

    BatchingSettingsPanelBuilder(SettingsPanelBuilder settingsPanelBuilder, BatchComponentFilter batchComponentFilter, ParameterRunnable<ProjectComponent> parameterRunnable) {
        this.fBuilder = settingsPanelBuilder;
        this.fBatch = new ArrayList<SettingComponentDefinition>();
        this.fComponentRegistry = parameterRunnable;
        this.fBatchComponentFilter = batchComponentFilter;
    }

    @Override
    public void startCategory(String string) {
        this.endBatch();
        this.fBuilder.startCategory(string);
    }

    @Override
    public String getCurrentCategoryName() {
        return this.fBuilder.getCurrentCategoryName();
    }

    @Override
    public void endCategory() {
        this.endBatch();
        this.fBuilder.endCategory();
    }

    @Override
    public void addComponent(SettingComponentDefinition settingComponentDefinition) {
        if (settingComponentDefinition.getLabel() == null) {
            this.addComponent(settingComponentDefinition.getComponent(), false);
            return;
        }
        String string = this.fBatch.isEmpty() ? null : this.fBatch.get(this.fBatch.size() - 1).getCategoryName();
        Param param = settingComponentDefinition.getParam();
        if (param.getType() != ParamType.BOOLEAN && !Configuration.isAlwaysDisabled(param)) {
            if (string != null && !string.equals(this.getCurrentCategoryName())) {
                this.endBatch();
            }
            this.fBatch.add(settingComponentDefinition);
            this.fBatchCategoryName = this.fBuilder.getCurrentCategoryName();
        } else {
            this.endBatch();
            this.fBuilder.addComponent(settingComponentDefinition);
        }
    }

    @Override
    public void addComponent(Component component, boolean bl) {
        this.endBatch();
        this.fBuilder.addComponent(component, bl);
    }

    @Override
    public void addPadding() {
        this.endBatch();
        this.fBuilder.addPadding();
    }

    @Override
    public JComponent getComponent() {
        return this.fBuilder.getComponent();
    }

    private boolean hasUniformType() {
        ParamType paramType = null;
        for (SettingComponentDefinition settingComponentDefinition : this.fBatch) {
            ParamType paramType2 = settingComponentDefinition.getParam().getType();
            if (paramType != null && paramType != paramType2) {
                return false;
            }
            paramType = paramType2;
        }
        return true;
    }

    private void endBatch() {
        if (this.fBatch.size() >= 3 || this.fBatch.size() >= 2 && this.hasUniformType()) {
            this.fBatchComponentFilter.filter(this.fBatchCategoryName, this.fBuilder, this.fComponentRegistry, this.fBatch);
        } else {
            for (SettingComponentDefinition settingComponentDefinition : this.fBatch) {
                this.fBuilder.addComponent(settingComponentDefinition);
            }
        }
        this.fBatch.clear();
        this.fBatchCategoryName = null;
    }

    public static List<Param> getParams(List<SettingComponentDefinition> list) {
        ArrayList<Param> arrayList = new ArrayList<Param>(list.size());
        for (SettingComponentDefinition settingComponentDefinition : list) {
            arrayList.add(settingComponentDefinition.getParam());
        }
        return arrayList;
    }
}

