/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.FileSetRule;
import com.mathworks.project.impl.model.SpecialFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class FileSetDefinition {
    private final String fKey;
    private final String fName;
    private final String fSingleFileName;
    private final String fDescription;
    private final String fSizeError;
    private final String fPatternError;
    private final String fCustomDataWidgetClassName;
    private final String fCustomFileSetActionClassName;
    private final DynamicTargetAttribute fHelpKey;
    private final boolean fAllowDirectories;
    private final int fMaxCount;
    private final int fMinCount;
    private final List<EntityDefinition> fEntities;
    private final List<FileSetRule> fRules;
    private final List<FileSetFilter> fFilters;
    private final List<SpecialFile> fSpecialFiles;
    public static final String PACKAGE_FILE_SET_KEY = "fileset.package";

    public FileSetDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, DynamicTargetAttribute dynamicTargetAttribute, boolean bl, int n, int n2, List<EntityDefinition> list, List<FileSetRule> list2, List<FileSetFilter> list3, List<SpecialFile> list4) {
        assert (string != null);
        assert (string2 != null);
        assert (list2 != null);
        assert (list3 != null);
        assert (list != null);
        assert (list4 != null);
        this.fKey = string;
        this.fName = string2;
        this.fSingleFileName = string3;
        this.fHelpKey = dynamicTargetAttribute;
        this.fSizeError = string5 == null ? BuiltInResources.getString("error.fileset.size") : string5;
        this.fPatternError = string6 == null ? BuiltInResources.getString("error.fileset.pattern") : string6;
        this.fDescription = string4;
        this.fCustomDataWidgetClassName = string7;
        this.fCustomFileSetActionClassName = string8;
        this.fAllowDirectories = bl;
        this.fMinCount = n;
        this.fMaxCount = n2;
        this.fEntities = new ArrayList<EntityDefinition>(list);
        this.fRules = new ArrayList<FileSetRule>(list2);
        this.fFilters = new ArrayList<FileSetFilter>(list3);
        this.fSpecialFiles = new ArrayList<SpecialFile>(list4);
    }

    public String getKey() {
        return this.fKey;
    }

    public DynamicTargetAttribute getHelpKey() {
        return this.fHelpKey;
    }

    public String getName() {
        return this.fName;
    }

    public String getSingleFileName() {
        return this.fSingleFileName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getCustomDataWidgetClassName() {
        return this.fCustomDataWidgetClassName;
    }

    public String getCustomFileSetActionClassName() {
        return this.fCustomFileSetActionClassName;
    }

    public boolean isSizeEstimateExpected() {
        return this.fKey.equals(PACKAGE_FILE_SET_KEY);
    }

    public String getSizeError() {
        return this.fSizeError;
    }

    public String getPatternError() {
        return this.fPatternError;
    }

    public int getMaxCount() {
        return this.fMaxCount;
    }

    public int getMinCount() {
        return this.fMinCount;
    }

    public List<EntityDefinition> getRootLevelEntities() {
        return new ArrayList<EntityDefinition>(this.fEntities);
    }

    public EntityDefinition getRootLevelEntity(String string) {
        for (EntityDefinition entityDefinition : this.fEntities) {
            if (!entityDefinition.getKey().equals(string)) continue;
            return entityDefinition;
        }
        return null;
    }

    public int getHierarchyLevels() {
        return !this.fEntities.isEmpty() ? 2 : 1;
    }

    public boolean allowsDirectories() {
        return this.fAllowDirectories;
    }

    public boolean allow(File file) {
        return FileSetDefinition.allow(file, this.fRules, this.fAllowDirectories);
    }

    public static boolean allow(File file, List<FileSetRule> list, boolean bl) {
        if (file.isDirectory()) {
            return bl;
        }
        boolean bl2 = false;
        for (FileSetRule fileSetRule : list) {
            boolean bl3 = fileSetRule.appliesTo(file);
            if (!bl3) continue;
            bl2 = !fileSetRule.isDenyRule();
        }
        return bl2;
    }

    public List<FileSetFilter> getFilters() {
        return new ArrayList<FileSetFilter>(this.fFilters);
    }

    public List<SpecialFile> getSpecialFiles() {
        return new ArrayList<SpecialFile>(this.fSpecialFiles);
    }

    public SpecialFile getSpecialFile(String string) {
        for (SpecialFile specialFile : this.fSpecialFiles) {
            if (!specialFile.getKey().equals(string)) continue;
            return specialFile;
        }
        return null;
    }

    public String toString() {
        return this.fKey;
    }
}

