/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.debug.Debug;
import ice.ssl.ClientHandshake;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SSLSocket;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

final class CertificateVerify
extends ClientHandshake {
    private HandshakeState I;

    CertificateVerify(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        super(15, sessionState, connectionState);
        this.length = 0;
        this.I = handshakeState;
    }

    byte[] toByteArray() {
        byte[] byArray = new byte[]{};
        try {
            Object[] objectArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
            boolean bl = this.I.keyExchange == 1 || this.I.keyExchange == 1;
            MessageDigest messageDigest = null;
            MessageDigest messageDigest2 = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
                messageDigest2 = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecurityException("Algorithm not found : " + (messageDigest == null ? "MD5" : "SHA") + " digest");
            }
            if (this.sesState.nowProto == 2) {
                objectArray = new MessageDigest[]{messageDigest, messageDigest2};
                int n = bl ? 2 : 1;
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2].update(this.I.messages.toByteArray());
                    objectArray[n2].update(this.sesState.masterSecret);
                    objectArray[n2].update(Util.pad1, 0, n2 == 0 ? 48 : 40);
                    byte[] byArray2 = objectArray[n2].digest();
                    objectArray[n2].reset();
                    objectArray[n2].update(this.sesState.masterSecret);
                    objectArray[n2].update(Util.pad2, 0, n2 == 0 ? 48 : 40);
                    objectArray[n2].update(byArray2);
                    byteArrayOutputStream3.write(objectArray[n2].digest());
                    ++n2;
                }
            } else {
                messageDigest2.reset();
                messageDigest2.update(this.I.messages.toByteArray());
                byteArrayOutputStream3.write(messageDigest2.digest());
                if (bl) {
                    messageDigest.reset();
                    messageDigest.update(this.I.messages.toByteArray());
                    byteArrayOutputStream3.write(messageDigest.digest());
                }
            }
            if (bl) {
                objectArray = byteArrayOutputStream3.toByteArray();
                PrivateKey privateKey = null;
                privateKey = SSLSocket.getCertificateCallback().supplyPrivateKey(this.I.clientCertificate);
                byte[] byArray3 = Util.encryptRSAPKCS1((byte[])objectArray, privateKey);
                byteArrayOutputStream2.write(Util.toByteArray(byArray3.length, 2));
                byteArrayOutputStream2.write(byArray3);
            } else if (Debug.trace) {
                Debug.trace((String)"WARNING: Certificate verify message not yet implemented for DSA");
            }
            objectArray = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream2.close();
            this.length = objectArray.length;
            byteArrayOutputStream.write(super.toByteArray());
            byteArrayOutputStream.write((byte[])objectArray);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }
}

