/*
 * Decompiled with CFR 0.152.
 */
package ice.demo;

import ice.cert.X509Certificate;
import ice.ssl.CertificateErrorInfo;
import ice.ssl.CertificateEvent;
import ice.ssl.CertificateListener;
import ice.ssl.SSLSocket;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CertificateDialog
extends Dialog
implements CertificateListener,
ActionListener {
    public static final int POP_ALL_EVENTS = 1;
    public static final int POP_ERROR_EVENTS = 2;
    public static final int POP_NO_EVENTS = 3;
    private CertificateEvent OEAB;
    private boolean add;
    Button acceptButton;
    Button rejectButton;
    Panel generalPanel;
    private static String addActionListener = "www.belsign.be";

    public CertificateDialog(Frame frame) {
        super(frame, "Certificate Received", true);
        SSLSocket.removeBlockingCertificateListener(SSLSocket.getBlockingCertificateListener());
        SSLSocket.setBlockingCertificateListener(this);
        this.setFont(new Font("SansSerif", 0, 10));
        this.generalPanel = new Panel();
        this.generalPanel.setLayout(new BorderLayout());
        this.add((Component)this.generalPanel, "Center");
        Panel panel = new Panel();
        this.acceptButton = new Button("Accept");
        this.acceptButton.addActionListener(this);
        panel.add(this.acceptButton);
        this.rejectButton = new Button("Reject");
        this.rejectButton.addActionListener(this);
        panel.add(this.rejectButton);
        panel.setLayout(new FlowLayout());
        this.add((Component)panel, "South");
    }

    public CertificateEvent getLastEvent() {
        return this.OEAB;
    }

    public boolean certificateReceived(CertificateEvent certificateEvent) {
        this.OEAB = certificateEvent;
        this.OEAB(certificateEvent);
        this.pack();
        ((Component)this).setVisible(true);
        return this.add;
    }

    public void setPopEvents(int n) {
        SSLSocket.setCertEvents(n);
    }

    public int getPopEvents() {
        return SSLSocket.getCertEvents();
    }

    private void OEAB(CertificateEvent certificateEvent) {
        Panel panel;
        X509Certificate x509Certificate = certificateEvent.getCertificate();
        CertificateErrorInfo[] certificateErrorInfoArray = certificateEvent.getErrors();
        String string = ((SSLSocket)certificateEvent.getSource()).getInetAddress().getHostName();
        this.generalPanel.removeAll();
        this.generalPanel.add((Component)new Label("A certificate has been received from: " + string), "North");
        if (x509Certificate != null) {
            panel = new Panel();
            panel.add(new Label("Certificate information:"));
            panel.add(new Label("* Issued by: " + x509Certificate.getIssuerDN().getName()));
            panel.add(new Label("* Issued to: " + x509Certificate.getSubjectDN().getName()));
            panel.add(new Label("* Signature algorithm: " + x509Certificate.getSigAlgName()));
            panel.add(new Label("* Valid from: " + x509Certificate.getNotBefore().toString()));
            panel.add(new Label("* Valid to: " + x509Certificate.getNotAfter().toString()));
            panel.setLayout(new GridLayout(panel.getComponentCount(), 1));
            this.generalPanel.add((Component)panel, "South");
        }
        if (certificateErrorInfoArray.length > 0) {
            panel = new Panel();
            panel.add(new Label("With the following security errors:"));
            int n = 0;
            while (n < certificateErrorInfoArray.length) {
                panel.add(new Label("" + (n + 1) + ". " + certificateErrorInfoArray[n].getMessage()));
                ++n;
            }
            panel.setLayout(new GridLayout(panel.getComponentCount(), 1));
            this.generalPanel.add((Component)panel, "Center");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.acceptButton) {
            this.add = true;
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.rejectButton) {
            this.add = false;
            ((Component)this).setVisible(false);
        }
    }

    public static void main(String[] stringArray) {
        SSLSocket.init();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Frame frame = new Frame();
        CertificateDialog certificateDialog = new CertificateDialog(frame);
        certificateDialog.setPopEvents(2);
        if (stringArray.length > 0) {
            addActionListener = stringArray[0];
        }
        System.out.println("connecting to https://" + addActionListener + " ...");
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(addActionListener);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown host " + addActionListener);
            System.exit(1);
        }
        try {
            SSLSocket sSLSocket = new SSLSocket(inetAddress, 443);
            OutputStream outputStream = sSLSocket.getOutputStream();
            System.out.println("connected.");
            System.out.println("sending http request...");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("GET / HTTP/1.1\r\n");
            stringBuffer.append("host: " + addActionListener + ":" + 443 + "\r\n");
            stringBuffer.append("\r\n");
            outputStream.write(stringBuffer.toString().getBytes(), 0, stringBuffer.length());
            System.out.println("request sent.");
            InputStream inputStream = sSLSocket.getInputStream();
            System.out.println("reading answer...");
            int n = 0;
            int n2 = 0;
            while ((n = inputStream.read()) != -1) {
                n2 = n == 13 || n == 10 ? ++n2 : 0;
                System.out.print("" + (char)n);
                if (n2 >= 4) break;
            }
            if (n == -1) {
                System.out.println("nothing to read : socket might be closed");
                System.out.println("(this is what happends if the certificate is rejected)");
            }
            System.out.println("end of connection.");
            sSLSocket.close();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("IOException caught in connection: \n" + iOException.getMessage());
            System.exit(1);
        }
    }
}

