/*
 * Decompiled with CFR 0.152.
 */
package ice.crypto;

import ice.crypto.AlgorithmParameterSpec;
import ice.crypto.DHParameterSpec;
import ice.crypto.DHPrivateKey;
import ice.crypto.DHPublicKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

public final class DHKeyPairGenerator
extends KeyPairGenerator {
    private static final String algorithm = "DH";
    private static final BigInteger p512 = new BigInteger("b9ae315ac27aad320c7ba75d96638656c8d0b83bc4ca4d423e8b42638261a6891927a80b842f5cd51f68baf151c83cdb8b49f09ea3f160046c485aa48c7f5963", 16);
    private static final BigInteger p1024 = new BigInteger("b94da316f56724b457ab09be41de17c4431143799297c5aa8f1e0c91b7edf0063f6442971b8577eb8a4300aa224767baf619033c66166985e1fcb738cec7905eb994b3e58a754aa9f0e696c0d57fca7c7a5d208e31ef18529e2d7ecb2e8662cb43a564048badba934aa94e91d7f3023e42e3695f8256c6db3765853475265925", 16);
    private static final BigInteger p2048 = new BigInteger("d409ef9cfe50903e8f4d82d30af45cd66ed005a91424b12b1f179fac3b497be9989f1e2c91107375ddccd7645ec59b678ae492377961bf92cfdc4ef08ffec1293a284e84d477a0536efdcf7dcb8f35b82dd5ca88f848ee0a7308fe85e49a0352cfc8583cf8f06c372ae69ce1260f51001682be90697bdf1369427733e43ef61c9f95b06adc0ce2204f4fe022ca1461efa6dba399aba436feb42176d516e881ad6ec5da61175cd0569b930c609099ac52e96d4b64d74faeaae438d8588ca5d87c67040fe4e28345c25d0bae3b16a0cf42b6e8d825fff4b56f642ede4fbe3f2bab375ec320788bb3ff197ea1801d6ff5ff8e96e5aa1007cb6889c6360da3f68613", 16);
    private SecureRandom random;
    private DHParameterSpec parameters;

    public DHKeyPairGenerator() {
        super(algorithm);
    }

    public String getAlgorithm() {
        return algorithm;
    }

    public void initialize(int size, SecureRandom random) {
        switch (size) {
            case 512: {
                this.parameters = new DHParameterSpec(p512, new BigInteger("2"), 511);
                break;
            }
            case 1024: {
                this.parameters = new DHParameterSpec(p1024, new BigInteger("2"), 1023);
                break;
            }
            case 2048: {
                this.parameters = new DHParameterSpec(p2048, new BigInteger("2"), 2047);
                break;
            }
            default: {
                throw new IllegalArgumentException("size must be one among 512, 1024 or 2048");
            }
        }
        this.random = random;
    }

    public void initialize(int size) {
        switch (size) {
            case 512: {
                this.parameters = new DHParameterSpec(p512, new BigInteger("2"), 511);
                break;
            }
            case 1024: {
                this.parameters = new DHParameterSpec(p1024, new BigInteger("2"), 1023);
                break;
            }
            case 2048: {
                this.parameters = new DHParameterSpec(p2048, new BigInteger("2"), 2047);
                break;
            }
            default: {
                throw new IllegalArgumentException("size must be one among 512, 1024 or 2048");
            }
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public void init(AlgorithmParameterSpec genParamSpec) {
        if (!(genParamSpec instanceof DHParameterSpec)) {
            throw new IllegalArgumentException("Argument genParamSpec must be of class DHAlgoritmParameterSpec");
        }
        this.init((DHParameterSpec)((Object)genParamSpec));
    }

    public void init(DHParameterSpec genParamSpec) {
        this.parameters = genParamSpec;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public void init(AlgorithmParameterSpec genParamSpec, SecureRandom random) {
        if (!(genParamSpec instanceof DHParameterSpec)) {
            throw new IllegalArgumentException("Argument genParamSpec must be of class DHAlgoritmParameterSpec");
        }
        this.init((DHParameterSpec)((Object)genParamSpec), random);
    }

    public void init(DHParameterSpec genParamSpec, SecureRandom random) {
        this.parameters = genParamSpec;
        this.random = random;
    }

    public KeyPair generateKeyPair() {
        BigInteger privateData;
        int l = this.parameters.getL();
        if (l <= 0) {
            l = this.parameters.getP().toByteArray().length - 1;
        }
        while ((privateData = new BigInteger(l, this.random)).bitLength() < l) {
        }
        DHPrivateKey y = new DHPrivateKey(privateData, this.parameters);
        BigInteger publicData = this.parameters.getG().modPow(privateData, this.parameters.getP());
        DHPublicKey x = new DHPublicKey(publicData, this.parameters);
        return new KeyPair(x, y);
    }
}

