/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import cryptix.provider.rsa.CryptixRSAPrivateKeyPatch;
import cryptix.provider.rsa.RawRSAPrivateKey;
import ice.cert.CertificateParsingException;
import ice.cert.DERUtil;
import ice.cert.DERValue;
import ice.cert.OID;
import ice.cryptix.Base64;
import ice.crypto.SimpleKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

public class PKCS8PrivateKeyFactory {
    private byte[] I;

    public PKCS8PrivateKeyFactory() {
    }

    public PKCS8PrivateKeyFactory(byte[] byArray) {
        this.I = byArray;
    }

    public PrivateKey parsePrivateKey(InputStream inputStream) throws CertificateParsingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new CertificateParsingException("I/O error while parsing: " + iOException.getMessage());
        }
        return this.parsePrivateKey(byteArrayOutputStream.toByteArray());
    }

    public PrivateKey parsePrivateKey(byte[] byArray) throws CertificateParsingException {
        DERValue dERValue;
        DERValue dERValue2;
        DERValue dERValue3;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray2 = null;
        if (Base64.isBase64(byArray)) {
            try {
                if (new String(byArray).startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
                    bl = true;
                }
                if (new String(byArray).startsWith("-----BEGIN ENCRYPTED PRIVATE KEY-----")) {
                    bl2 = true;
                }
                byArray = Base64.decode(Base64.removeMarkers(byArray));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertificateParsingException("Wrong base64 encoding: " + illegalArgumentException.getMessage());
            }
        }
        if (bl) {
            return this.OEAB(byArray);
        }
        byte[] byArray3 = null;
        if (bl2) {
            dERValue3 = new DERValue();
            byArray2 = DERUtil.decode(byArray, dERValue3, 1);
            dERValue2 = new DERValue();
            byArray2 = DERUtil.decode((byte[])dERValue3.getData(), dERValue2);
            dERValue = new DERValue();
            byArray2 = DERUtil.decode(byArray2, dERValue, 5);
            byArray3 = PKCS8PrivateKeyFactory.pkcs5decrypt((byte[])dERValue.getData(), this.I, (byte[])dERValue2.getData());
        } else {
            byArray3 = byArray;
        }
        dERValue3 = new DERValue();
        byArray2 = DERUtil.decode(byArray3, dERValue3, 1);
        dERValue2 = new DERValue();
        byArray2 = DERUtil.decode((byte[])dERValue3.getData(), dERValue2);
        dERValue = new DERValue();
        byArray2 = DERUtil.decode(byArray2, dERValue, 1, (byte)2);
        DERValue dERValue4 = new DERValue();
        byArray2 = DERUtil.decode(byArray2, dERValue4, 5);
        return this.I((byte[])dERValue4.getData());
    }

    private PrivateKey I(byte[] byArray) throws CertificateParsingException {
        DERValue dERValue = new DERValue();
        byte[] byArray2 = DERUtil.decode(byArray, dERValue, 1);
        DERValue dERValue2 = new DERValue();
        byArray2 = DERUtil.decode((byte[])dERValue.getData(), dERValue2, 7, (byte)2);
        DERValue dERValue3 = new DERValue();
        byArray2 = DERUtil.decode(byArray2, dERValue3, 7, (byte)2);
        DERValue dERValue4 = new DERValue();
        byArray2 = DERUtil.decode(byArray2, dERValue4, 7, (byte)2);
        DERValue dERValue5 = new DERValue();
        byArray2 = DERUtil.decode(byArray2, dERValue5, 7, (byte)2);
        return new CryptixRSAPrivateKeyPatch(new RawRSAPrivateKey((BigInteger)dERValue3.getData(), (BigInteger)dERValue5.getData()));
    }

    private PrivateKey OEAB(byte[] byArray) throws CertificateParsingException {
        DERValue dERValue = new DERValue();
        byte[] byArray2 = DERUtil.decode(byArray, dERValue, 1);
        DERValue dERValue2 = new DERValue();
        byte[] byArray3 = DERUtil.decode((byte[])dERValue.getData(), dERValue2, 7, (byte)2);
        DERValue dERValue3 = new DERValue();
        byte[] byArray4 = DERUtil.decode(byArray3, dERValue3, 7, (byte)2);
        DERValue dERValue4 = new DERValue();
        byte[] byArray5 = DERUtil.decode(byArray4, dERValue4, 7, (byte)2);
        DERValue dERValue5 = new DERValue();
        byte[] byArray6 = DERUtil.decode(byArray5, dERValue5, 7, (byte)2);
        DERValue dERValue6 = new DERValue();
        byte[] byArray7 = DERUtil.decode(byArray6, dERValue6, 7, (byte)2);
        DERValue dERValue7 = new DERValue();
        byte[] byArray8 = DERUtil.decode(byArray7, dERValue7, 7, (byte)2);
        DERValue dERValue8 = new DERValue();
        byte[] byArray9 = DERUtil.decode(byArray8, dERValue8, 7, (byte)2);
        DERValue dERValue9 = new DERValue();
        byte[] byArray10 = DERUtil.decode(byArray9, dERValue9, 7, (byte)2);
        DERValue dERValue10 = new DERValue();
        byte[] byArray11 = DERUtil.decode(byArray10, dERValue10, 7, (byte)1);
        return new CryptixRSAPrivateKeyPatch(new RawRSAPrivateKey((BigInteger)dERValue3.getData(), (BigInteger)dERValue5.getData()));
    }

    static byte[] PBKDF1(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        MessageDigest messageDigest = null;
        try {
            switch (n2) {
                case 1: 
                case 4: {
                    messageDigest = MessageDigest.getInstance("MD2");
                    break;
                }
                case 3: 
                case 6: {
                    messageDigest = MessageDigest.getInstance("MD5");
                    break;
                }
                case 10: 
                case 11: {
                    messageDigest = MessageDigest.getInstance("SHA1");
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        int n4 = 0;
        while (n4 < n) {
            messageDigest.reset();
            messageDigest.update(byArray3);
            byArray3 = messageDigest.digest();
            ++n4;
        }
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return byArray3;
    }

    static byte[] PBKDF2(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        return null;
    }

    static byte[] pkcs5encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) {
        return null;
    }

    static byte[] pkcs5decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) throws CertificateParsingException {
        Object object;
        byte by;
        DERValue dERValue = new DERValue();
        byte[] byArray4 = DERUtil.decode(byArray3, dERValue);
        String string = null;
        int n = ((OID)dERValue.getData()).oidID;
        switch (n) {
            case 1: 
            case 3: 
            case 10: {
                string = "DES/CBC";
                by = 8;
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                string = "RC2/CBC";
                by = 8;
                break;
            }
            default: {
                throw new CertificateParsingException("Unknown algorithm suite for PKCS#5");
            }
        }
        DERValue dERValue2 = new DERValue();
        byArray4 = DERUtil.decode(byArray4, dERValue2, 1);
        DERValue dERValue3 = new DERValue();
        byArray4 = DERUtil.decode((byte[])dERValue2.getData(), dERValue3, 5);
        DERValue dERValue4 = new DERValue();
        byArray4 = DERUtil.decode(byArray4, dERValue4, 7);
        byte[] byArray5 = PKCS8PrivateKeyFactory.PBKDF1(byArray2, (byte[])dERValue3.getData(), ((BigInteger)dERValue4.getData()).intValue(), n, by * 2);
        byte[] byArray6 = new byte[by];
        byte[] byArray7 = new byte[by];
        System.arraycopy(byArray5, 0, byArray6, 0, by);
        System.arraycopy(byArray5, by, byArray7, 0, by);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            ((FeedbackCipher)((Object)cipher)).setInitializationVector(byArray7);
            object = new SimpleKey(string, byArray6);
            cipher.initDecrypt((Key)object);
        }
        catch (KeyException keyException) {
            // empty catch block
        }
        object = cipher.crypt(byArray);
        int n2 = ((byte[])object).length - object[((byte[])object).length - 1];
        if (object[((byte[])object).length - 1] > by) {
            throw new CertificateParsingException();
        }
        byte[] byArray8 = new byte[n2];
        System.arraycopy(object, 0, byArray8, 0, n2);
        return byArray8;
    }
}

