/*
 * Decompiled with CFR 0.152.
 */
package ice.util.image;

import ice.util.image.IceImageObserver;
import ice.util.image.ImageObserverProxy;
import ice.util.image.ImageProxy;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;

public class ImageFactory {
    static Hashtable imagesAndListeners = new Hashtable();
    static Object imageAccessLock = new Object();

    public static ImageProxy getImage(Toolkit toolkit, URL uRL) {
        Image image = toolkit.getImage(uRL);
        if (image == null) {
            return null;
        }
        ImageProxy imageProxy = new ImageProxy(image);
        return imageProxy;
    }

    public static boolean prepareImage(Toolkit toolkit, ImageProxy imageProxy, int n, int n2, IceImageObserver iceImageObserver) {
        ImageObserverProxy imageObserverProxy = null;
        if (iceImageObserver != null) {
            Object object = imageAccessLock;
            synchronized (object) {
                imageObserverProxy = (ImageObserverProxy)imagesAndListeners.get(imageProxy);
                if (imageObserverProxy == null) {
                    imageObserverProxy = new ImageObserverProxy(iceImageObserver, imageProxy);
                    imagesAndListeners.put(imageProxy, imageObserverProxy);
                }
                imageProxy.setImageObserver(imageObserverProxy);
            }
        }
        return toolkit.prepareImage(imageProxy.getImage(), n, n2, imageObserverProxy);
    }

    public static int checkImage(Toolkit toolkit, ImageProxy imageProxy, int n, int n2, IceImageObserver iceImageObserver) {
        ImageObserverProxy imageObserverProxy = null;
        if (iceImageObserver != null) {
            Object object = imageAccessLock;
            synchronized (object) {
                imageObserverProxy = (ImageObserverProxy)imagesAndListeners.get(imageProxy);
                if (imageObserverProxy == null) {
                    imageObserverProxy = new ImageObserverProxy(iceImageObserver, imageProxy);
                    imagesAndListeners.put(imageProxy, imageObserverProxy);
                }
                imageProxy.setImageObserver(imageObserverProxy);
            }
        }
        int n3 = -1;
        n3 = toolkit.checkImage(imageProxy.getImage(), n, n2, imageObserverProxy);
        return n3;
    }

    public static ImageProxy createImage(int n, int n2, Component component) {
        Image image = component.createImage(n, n2);
        if (image == null) {
            return null;
        }
        ImageProxy imageProxy = new ImageProxy(image);
        return imageProxy;
    }

    static void removeObserver(ImageProxy imageProxy) {
        Object object = imageAccessLock;
        synchronized (object) {
            imagesAndListeners.remove(imageProxy);
        }
    }
}

