/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.openide.ErrorManager;

public abstract class TagBasedFormatter
extends ExtFormatter {
    public TagBasedFormatter(Class clazz) {
        super(clazz);
    }

    protected abstract ExtSyntaxSupport getSyntaxSupport(BaseDocument var1);

    protected abstract boolean isClosingTag(TokenItem var1);

    protected abstract boolean isUnformattableToken(TokenItem var1);

    protected abstract boolean isUnformattableTag(String var1);

    protected abstract boolean isOpeningTag(TokenItem var1);

    protected abstract String extractTagName(TokenItem var1);

    protected abstract boolean areTagNamesEqual(String var1, String var2);

    protected abstract boolean isClosingTagRequired(BaseDocument var1, String var2);

    protected abstract int getOpeningSymbolOffset(TokenItem var1);

    protected abstract TokenItem getTagTokenEndingAtPosition(BaseDocument var1, int var2) throws BadLocationException;

    protected abstract int getTagEndOffset(TokenItem var1);

    protected Writer extFormatterReformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        return super.reformat(baseDocument, n, n2, bl);
    }

    protected boolean isWSTag(TokenItem tokenItem) {
        char[] cArray;
        for (char c : cArray = tokenItem.getImage().toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected int getIndentForTagParameter(BaseDocument baseDocument, TokenItem tokenItem) throws BadLocationException {
        TokenItem tokenItem2;
        int n = Utilities.getLineOffset(baseDocument, tokenItem.getOffset());
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && this.isWSTag(tokenItem2) && n == Utilities.getLineOffset(baseDocument, tokenItem2.getOffset()); tokenItem2 = tokenItem2.getNext()) {
        }
        if (tokenItem != null && !this.isWSTag(tokenItem2) && n == Utilities.getLineOffset(baseDocument, tokenItem2.getOffset())) {
            return tokenItem2.getOffset() - Utilities.getRowIndent(baseDocument, tokenItem2.getOffset()) - Utilities.getRowStart(baseDocument, tokenItem2.getOffset());
        }
        return this.getShiftWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        if (!this.hasValidSyntaxSupport(baseDocument)) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ArrayList<TagIndentationData> arrayList = new ArrayList<TagIndentationData>();
        baseDocument.atomicLock();
        try {
            int n3;
            int n4 = Utilities.getLineOffset(baseDocument, baseDocument.getLength());
            int n5 = Utilities.getLineOffset(baseDocument, n);
            int n6 = Utilities.getLineOffset(baseDocument, n2);
            int n7 = -1;
            boolean[] blArray = new boolean[n4 + 1];
            int[] nArray = new int[n4 + 1];
            ExtSyntaxSupport extSyntaxSupport = this.getSyntaxSupport(baseDocument);
            TokenItem tokenItem = extSyntaxSupport.getTokenChain(0, baseDocument.getLength() - 1);
            if (tokenItem != null) {
                do {
                    boolean bl2;
                    int n8;
                    boolean bl3 = this.isOpeningTag(tokenItem);
                    boolean bl4 = this.isClosingTag(tokenItem);
                    if (bl3 || bl4) {
                        int n9;
                        Object object;
                        String string = this.extractTagName(tokenItem);
                        n3 = this.getTagEndOffset(tokenItem);
                        n8 = Utilities.getLineOffset(baseDocument, n3);
                        if (bl3) {
                            object = new TagIndentationData(string, n8);
                            linkedList.add(object);
                            int n10 = Utilities.getLineOffset(baseDocument, tokenItem.getOffset());
                            if (n10 < n8) {
                                n9 = this.getIndentForTagParameter(baseDocument, tokenItem);
                                for (int i = n10 + 1; i <= n8; ++i) {
                                    nArray[i] = n9;
                                }
                                TokenItem tokenItem2 = tokenItem.getNext();
                                while (Utilities.getLineOffset(baseDocument, tokenItem2.getOffset()) < n8 || this.isWSTag(tokenItem2)) {
                                    tokenItem2 = tokenItem2.getNext();
                                }
                                if (tokenItem2.getOffset() == n3) {
                                    nArray[n8] = 0;
                                }
                            }
                        } else {
                            object = new LinkedList();
                            while (!linkedList.isEmpty()) {
                                TagIndentationData tagIndentationData = (TagIndentationData)linkedList.removeLast();
                                if (this.areTagNamesEqual(string, tagIndentationData.getTagName())) {
                                    tagIndentationData.setClosedOnLine(n8);
                                    arrayList.add(tagIndentationData);
                                    if (this.isUnformattableTag(string)) {
                                        for (n9 = n8 - 1; n9 > tagIndentationData.getLine(); --n9) {
                                            blArray[n9] = true;
                                        }
                                    }
                                    ((LinkedList)object).clear();
                                    break;
                                }
                                ((LinkedList)object).add(tagIndentationData);
                            }
                            linkedList.addAll((Collection<Object>)object);
                        }
                    }
                    if ((bl2 = this.isUnformattableToken(tokenItem)) && n7 == -1) {
                        n7 = Utilities.getLineOffset(baseDocument, tokenItem.getOffset());
                    }
                    tokenItem = tokenItem.getNext();
                    if (n7 <= -1 || bl2 && tokenItem != null) continue;
                    n3 = tokenItem == null ? n4 : Utilities.getLineOffset(baseDocument, tokenItem.getOffset() - 1);
                    for (n8 = n7 + 1; n8 < n3; ++n8) {
                        blArray[n8] = true;
                    }
                    n7 = -1;
                } while (tokenItem != null);
            }
            int[] nArray2 = new int[n4 + 1];
            Arrays.fill(nArray2, 0);
            for (TagIndentationData tagIndentationData : arrayList) {
                n3 = tagIndentationData.getLine() + 1;
                while (n3 <= tagIndentationData.getClosedOnLine() - 1) {
                    int n11 = n3++;
                    nArray2[n11] = nArray2[n11] + 1;
                }
            }
            InitialIndentData initialIndentData = new InitialIndentData(baseDocument, nArray2, nArray, n5, n6);
            for (int i = n5; i <= n6; ++i) {
                n3 = Utilities.getRowStartFromLineOffset(baseDocument, i);
                if (blArray[i] || !initialIndentData.isEligibleToIndent(i)) continue;
                this.changeRowIndent(baseDocument, n3, initialIndentData.getIndent(i));
            }
        }
        finally {
            baseDocument.atomicUnlock();
        }
        return null;
    }

    protected void enterPressed(JTextComponent jTextComponent, int n) throws BadLocationException {
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        int n2 = Utilities.getLineOffset(baseDocument, n);
        int n3 = this.getInitialIndentFromPreviousLine(baseDocument, n2);
        int n4 = Utilities.getFirstNonWhiteBwd(baseDocument, n);
        int n5 = n4 = n4 == -1 ? 0 : n4;
        if (n2 == Utilities.getLineOffset(baseDocument, n4)) {
            return;
        }
        TokenItem tokenItem = this.getTagTokenEndingAtPosition(baseDocument, n4);
        if (this.isOpeningTag(tokenItem)) {
            TokenItem tokenItem2 = this.getNextClosingTag(baseDocument, n + 1);
            if (tokenItem2 != null) {
                int n6;
                TokenItem tokenItem3 = this.getMatchingOpeningTag(tokenItem2);
                if (tokenItem3 != null && tokenItem3.getOffset() == tokenItem.getOffset()) {
                    n6 = Utilities.getLineOffset(baseDocument, tokenItem.getOffset());
                    int n7 = Utilities.getLineOffset(baseDocument, tokenItem2.getOffset());
                    if (n7 == Utilities.getLineOffset(baseDocument, n)) {
                        if (n6 == n7 - 1) {
                            Position position = baseDocument.createPosition(this.getOpeningSymbolOffset(tokenItem2));
                            this.changeRowIndent(baseDocument, n, n3 + this.getShiftWidth());
                            baseDocument.insertString(position.getOffset(), "\n", null);
                            int n8 = position.getOffset() - 1;
                            this.changeRowIndent(baseDocument, position.getOffset() + 1, n3);
                            n8 = Utilities.getRowEnd(baseDocument, n8);
                            jTextComponent.setCaretPosition(n8);
                        } else {
                            this.changeRowIndent(baseDocument, n, n3);
                        }
                    }
                }
                n6 = n3;
                if (this.isClosingTagRequired(baseDocument, this.extractTagName(tokenItem))) {
                    n6 += this.getShiftWidth();
                }
                this.changeRowIndent(baseDocument, n, n6);
            }
        } else {
            int n9 = n3;
            if (this.isJustBeforeClosingTag(baseDocument, n)) {
                n9 = (n9 -= this.getShiftWidth()) < 0 ? 0 : n9;
            }
            this.changeRowIndent(baseDocument, n, n9);
        }
    }

    @Override
    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        if (!this.hasValidSyntaxSupport(baseDocument)) {
            return null;
        }
        char c = string.charAt(string.length() - 1);
        try {
            int n = jTextComponent.getCaret().getDot();
            if (c == '>') {
                TokenItem tokenItem;
                TokenItem tokenItem2 = this.getTagTokenEndingAtPosition(baseDocument, n - 1);
                if (this.isClosingTag(tokenItem2) && (tokenItem = this.getMatchingOpeningTag(tokenItem2)) != null) {
                    int n2 = tokenItem.getOffset();
                    return new int[]{n2, n};
                }
            } else if (c == '\n') {
                this.enterPressed(jTextComponent, n);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
        }
        return null;
    }

    protected TokenItem getMatchingOpeningTag(TokenItem tokenItem) {
        String string = this.extractTagName(tokenItem);
        int n = 0;
        for (TokenItem tokenItem2 = tokenItem.getPrevious(); tokenItem2 != null; tokenItem2 = tokenItem2.getPrevious()) {
            if (!this.areTagNamesEqual(string, this.extractTagName(tokenItem2))) continue;
            if (this.isOpeningTag(tokenItem2)) {
                if (n == 0) {
                    return tokenItem2;
                }
                --n;
                continue;
            }
            if (!this.isClosingTag(tokenItem2)) continue;
            ++n;
        }
        return null;
    }

    protected int getInitialIndentFromPreviousLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        int n3;
        int n4 = 0;
        if (n > 0 && (n3 = Utilities.getFirstNonWhiteBwd(baseDocument, n2 = Utilities.getRowStartFromLineOffset(baseDocument, n))) > 0) {
            n4 = Utilities.getRowIndent(baseDocument, n3);
        }
        return n4;
    }

    private int getInitialIndentFromNextLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = 0;
        int n3 = Utilities.getRowStartFromLineOffset(baseDocument, n);
        int n4 = Utilities.getRowEnd(baseDocument, n3);
        int n5 = Utilities.getFirstNonWhiteFwd(baseDocument, n4);
        if (n5 > 0) {
            n2 = Utilities.getRowIndent(baseDocument, n5, true);
        }
        return n2;
    }

    private boolean hasValidSyntaxSupport(BaseDocument baseDocument) {
        ExtSyntaxSupport extSyntaxSupport = this.getSyntaxSupport(baseDocument);
        if (extSyntaxSupport == null) {
            ErrorManager.getDefault().log(16, "TagBasedFormatter: failed to retrieve SyntaxSupport for document; probably attempt to use incompatible indentation engine");
            return false;
        }
        return true;
    }

    private boolean isClosingTagsPairingEnabled() {
        Boolean bl = (Boolean)Settings.getValue(this.getKitClass(), "pair-characters-completion");
        return bl == null ? true : bl;
    }

    protected static int getNumberOfLines(BaseDocument baseDocument) throws BadLocationException {
        return Utilities.getLineOffset(baseDocument, baseDocument.getLength() - 1) + 1;
    }

    protected TokenItem getNextClosingTag(BaseDocument baseDocument, int n) throws BadLocationException {
        ExtSyntaxSupport extSyntaxSupport = this.getSyntaxSupport(baseDocument);
        for (TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1); tokenItem != null; tokenItem = tokenItem.getNext()) {
            if (!this.isClosingTag(tokenItem)) continue;
            return tokenItem;
        }
        return null;
    }

    protected boolean isJustBeforeClosingTag(BaseDocument baseDocument, int n) throws BadLocationException {
        ExtSyntaxSupport extSyntaxSupport = this.getSyntaxSupport(baseDocument);
        TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
        return this.isClosingTag(tokenItem);
    }

    protected static class TagIndentationData {
        private String tagName;
        private int line;
        private int closedOnLine;

        public TagIndentationData(String string, int n) {
            this.tagName = string;
            this.line = n;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getLine() {
            return this.line;
        }

        public int getClosedOnLine() {
            return this.closedOnLine;
        }

        public void setClosedOnLine(int n) {
            this.closedOnLine = n;
        }
    }

    protected class InitialIndentData {
        private int indentLevelBias = 0;
        private int indentBias = 0;
        private int[] indentLevels;
        private int[] indentsWithinTags;

        public InitialIndentData(BaseDocument baseDocument, int[] nArray, int[] nArray2, int n, int n2) throws BadLocationException {
            int n3 = TagBasedFormatter.this.getInitialIndentFromPreviousLine(baseDocument, n);
            this.indentLevelBias = n3 / TagBasedFormatter.this.getShiftWidth() - (n > 0 ? nArray[n - 1] : 0);
            int n4 = TagBasedFormatter.this.getInitialIndentFromNextLine(baseDocument, n2);
            int n5 = n4 / TagBasedFormatter.this.getShiftWidth() - (n2 < TagBasedFormatter.getNumberOfLines(baseDocument) - 1 ? nArray[n2 + 1] : 0);
            if (n5 > this.indentLevelBias) {
                this.indentLevelBias = n5;
                n3 = n4;
            }
            this.indentBias = n3 % TagBasedFormatter.this.getShiftWidth();
            this.indentLevels = nArray;
            this.indentsWithinTags = nArray2;
        }

        public boolean isEligibleToIndent(int n) {
            return this.getActualIndentLevel(n) >= 0;
        }

        public int getIndent(int n) {
            return this.indentBias + this.indentsWithinTags[n] + this.getActualIndentLevel(n) * TagBasedFormatter.this.getShiftWidth();
        }

        private int getActualIndentLevel(int n) {
            return this.indentLevels[n] + this.indentLevelBias;
        }
    }
}

