/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.java.JavaFastImport;
import org.openide.util.NbBundle;

final class JavaFastImportPanel
extends JPanel {
    private JavaFastImport jfi;
    private int currentImportType;
    private int selectedIndex = 0;
    private JList jl;
    private JRadioButton importPackage;
    private JPanel listPanel;
    private ButtonGroup importType;
    private JLabel listLabel;
    private JRadioButton importClass;
    private JRadioButton fullyQualifiedName;
    private JScrollPane listScrollPane;

    public JavaFastImportPanel(JavaFastImport javaFastImport, int n) {
        this.jfi = javaFastImport;
        this.currentImportType = n;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI"));
        this.listLabel.setDisplayedMnemonic(LocaleSupport.getString("JFI_listLabelMnemonic", "M").charAt(0));
        this.jl = javaFastImport.getResultList();
        this.listScrollPane.setViewportView(this.jl);
        this.listLabel.setLabelFor(this.jl);
        this.jl.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_listLabel"));
        this.importClass.setMnemonic(LocaleSupport.getString("JFI_importButtonMnemonic", "C").charAt(0));
        this.importPackage.setMnemonic(LocaleSupport.getString("JFI_importButton_packageMnemonic", "P").charAt(0));
        this.fullyQualifiedName.setMnemonic(LocaleSupport.getString("JFI_fullyButtonMnemonic", "F").charAt(0));
        this.importClass.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_importClass"));
        this.importPackage.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_importPackage"));
        this.fullyQualifiedName.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_fullyQualifiedName"));
        Dimension dimension = this.getSize();
        this.setSize(new Dimension(dimension.width < 500 ? 500 : dimension.width, dimension.height));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateWhenImportTypeChanges(-1);
    }

    public int getImportType() {
        if (this.importPackage.isSelected()) {
            return 1;
        }
        if (this.fullyQualifiedName.isSelected()) {
            return 2;
        }
        return 0;
    }

    public void setPackageImportEnabled(boolean bl) {
        this.importPackage.setEnabled(bl);
    }

    private void updateWhenImportTypeChanges(int n) {
        String string;
        this.selectedIndex = this.jl.getSelectedIndex();
        if (n == this.currentImportType) {
            return;
        }
        if (n != -1) {
            this.currentImportType = n;
        }
        switch (this.currentImportType) {
            case 1: {
                this.importPackage.setSelected(true);
                break;
            }
            case 2: {
                this.fullyQualifiedName.setSelected(true);
                break;
            }
            default: {
                this.importClass.setSelected(true);
            }
        }
        String string2 = string = this.importPackage.isSelected() ? LocaleSupport.getString("JFI_listLabel_package", "Matching Packages:") : LocaleSupport.getString("JFI_listLabel", "Matching Classes:");
        if (string.equals(this.listLabel.getText())) {
            return;
        }
        this.listLabel.setText(string);
        List list = this.jfi.evaluate();
        if (list == null || list.size() == 0) {
            return;
        }
        this.jfi.populate(list);
        this.jl.setSelectedIndex(this.selectedIndex);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    void popupNotify() {
        this.listScrollPane.requestFocus();
    }

    private void initComponents() {
        this.importType = new ButtonGroup();
        this.listLabel = new JLabel();
        this.listPanel = new JPanel();
        this.listScrollPane = new JScrollPane();
        this.importClass = new JRadioButton();
        this.importPackage = new JRadioButton();
        this.fullyQualifiedName = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.listLabel, gridBagConstraints);
        this.listPanel.setLayout(new GridBagLayout());
        this.listScrollPane.setPreferredSize(new Dimension(320, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.listPanel.add((Component)this.listScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listPanel, gridBagConstraints);
        this.importClass.setText(NbBundle.getBundle(JavaFastImportPanel.class).getString("JFI_importButton"));
        this.importType.add(this.importClass);
        this.importClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JavaFastImportPanel.this.updateWhenImportTypeChanges(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.importClass, gridBagConstraints);
        this.importPackage.setText(NbBundle.getBundle(JavaFastImportPanel.class).getString("JFI_importButton_package"));
        this.importType.add(this.importPackage);
        this.importPackage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JavaFastImportPanel.this.updateWhenImportTypeChanges(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.importPackage, gridBagConstraints);
        this.fullyQualifiedName.setText(NbBundle.getBundle(JavaFastImportPanel.class).getString("JFI_fullyButton"));
        this.importType.add(this.fullyQualifiedName);
        this.fullyQualifiedName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JavaFastImportPanel.this.updateWhenImportTypeChanges(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fullyQualifiedName, gridBagConstraints);
    }

    private void updateWhenImportTypeChanges(ItemEvent itemEvent) {
        this.updateWhenImportTypeChanges(this.getImportType());
    }
}

