/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.WeakEventListenerList;

public class Registry {
    private static final WeakReference[] EMPTY = new WeakReference[0];
    private static WeakReference[] docRefs = EMPTY;
    private static int docRefsCount;
    private static final ArrayList docAct;
    private static WeakReference[] compRefs;
    private static int compRefsCount;
    private static final ArrayList compAct;
    private static final WeakEventListenerList listenerList;
    private static int consolidateCounter;

    public static void addChangeListener(ChangeListener changeListener) {
        listenerList.add(ChangeListener.class, changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        listenerList.remove(ChangeListener.class, changeListener);
    }

    public static synchronized int getID(BaseDocument baseDocument) {
        Integer n = Registry.getIDInteger(baseDocument);
        return n != null ? n : -1;
    }

    public static synchronized int getID(JTextComponent jTextComponent) {
        return Registry.getIDImpl(jTextComponent);
    }

    public static synchronized BaseDocument getDocument(int n) {
        if (n < 0 || n >= docRefsCount) {
            return null;
        }
        WeakReference weakReference = docRefs[n];
        return weakReference != null ? (BaseDocument)weakReference.get() : null;
    }

    public static synchronized JTextComponent getComponent(int n) {
        if (n < 0 || n >= compRefsCount) {
            return null;
        }
        WeakReference weakReference = compRefs[n];
        return weakReference != null ? (JTextComponent)weakReference.get() : null;
    }

    public static synchronized int addDocument(BaseDocument baseDocument) {
        Integer n = Registry.getIDInteger(baseDocument);
        if (n != null) {
            return n;
        }
        if (docRefsCount >= docRefs.length) {
            docRefs = Registry.realloc(docRefs);
        }
        Registry.docRefs[Registry.docRefsCount] = new WeakReference<BaseDocument>(baseDocument);
        baseDocument.putProperty("id", new Integer(docRefsCount));
        return docRefsCount++;
    }

    public static synchronized int addComponent(JTextComponent jTextComponent) {
        int n = Registry.getIDImpl(jTextComponent);
        if (n != -1) {
            return n;
        }
        if (compRefsCount >= compRefs.length) {
            compRefs = Registry.realloc(compRefs);
        }
        Registry.compRefs[Registry.compRefsCount] = new WeakReference<JTextComponent>(jTextComponent);
        ((BaseTextUI)jTextComponent.getUI()).componentID = compRefsCount;
        return compRefsCount++;
    }

    public static synchronized int removeComponent(JTextComponent jTextComponent) {
        int n = Registry.getIDImpl(jTextComponent);
        if (n != -1) {
            Registry.compRefs[n] = null;
            for (int i = compAct.size() - 1; i >= 0; --i) {
                if ((Integer)compAct.get(i) != n) continue;
                compAct.remove(i);
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(JTextComponent jTextComponent) {
        boolean bl = true;
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            Document document;
            int n;
            int n2 = Registry.getIDImpl(jTextComponent);
            if (n2 == -1) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n3 = compAct.size();
            for (n = 0; n < n3; ++n) {
                int n4 = (Integer)compAct.get(n);
                if (n4 != n2) continue;
                if (n == 0) break;
                compAct.add(0, compAct.remove(n));
                bl = true;
                break;
            }
            if (n == n3) {
                compAct.add(0, new Integer(n2));
                bl = true;
            }
            if ((document = jTextComponent.getDocument()) instanceof BaseDocument && Registry.doActivate((BaseDocument)document)) {
                bl = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl) {
                Registry.fireChange();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(BaseDocument baseDocument) {
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            boolean bl = Registry.doActivate(baseDocument);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl) {
                Registry.fireChange();
            }
            return;
        }
    }

    public static synchronized BaseDocument getMostActiveDocument() {
        return Registry.getValidDoc(0, true);
    }

    public static synchronized BaseDocument getLeastActiveDocument() {
        int n = docAct.size() - 1;
        return Registry.getValidDoc(n, false);
    }

    public static BaseDocument getLessActiveDocument(BaseDocument baseDocument) {
        return Registry.getLessActiveDocument(Registry.getID(baseDocument));
    }

    public static synchronized BaseDocument getLessActiveDocument(int n) {
        return Registry.getNextActiveDoc(n, true);
    }

    public static BaseDocument getMoreActiveDocument(BaseDocument baseDocument) {
        return Registry.getMoreActiveDocument(Registry.getID(baseDocument));
    }

    public static synchronized BaseDocument getMoreActiveDocument(int n) {
        return Registry.getNextActiveDoc(n, false);
    }

    public static synchronized Iterator getDocumentIterator() {
        Registry.consolidate();
        ArrayList arrayList = new ArrayList();
        int n = docAct.size();
        for (int i = 0; i < n; ++i) {
            Object t;
            int n2 = (Integer)docAct.get(i);
            WeakReference weakReference = docRefs[n2];
            if (weakReference == null || (t = weakReference.get()) == null) continue;
            arrayList.add(t);
        }
        return arrayList.iterator();
    }

    public static synchronized JTextComponent getMostActiveComponent() {
        return Registry.getValidComp(0, true);
    }

    public static synchronized JTextComponent getLeastActiveComponent() {
        int n = compAct.size() - 1;
        return Registry.getValidComp(n, false);
    }

    public static JTextComponent getLessActiveComponent(JTextComponent jTextComponent) {
        return Registry.getLessActiveComponent(Registry.getID(jTextComponent));
    }

    public static synchronized JTextComponent getLessActiveComponent(int n) {
        return Registry.getNextActiveComp(n, true);
    }

    public static JTextComponent getMoreActiveComponent(JTextComponent jTextComponent) {
        return Registry.getMoreActiveComponent(Registry.getID(jTextComponent));
    }

    public static synchronized JTextComponent getMoreActiveComponent(int n) {
        return Registry.getNextActiveComp(n, false);
    }

    public static synchronized Iterator getComponentIterator() {
        Registry.consolidate();
        ArrayList arrayList = new ArrayList();
        int n = compAct.size();
        for (int i = 0; i < n; ++i) {
            Object t;
            int n2 = (Integer)compAct.get(i);
            WeakReference weakReference = compRefs[n2];
            if (weakReference == null || (t = weakReference.get()) == null) continue;
            arrayList.add(t);
        }
        return arrayList.iterator();
    }

    private static WeakReference[] realloc(WeakReference[] weakReferenceArray) {
        WeakReference[] weakReferenceArray2 = new WeakReference[weakReferenceArray.length * 2 + 4];
        System.arraycopy(weakReferenceArray, 0, weakReferenceArray2, 0, weakReferenceArray.length);
        return weakReferenceArray2;
    }

    private static void consolidate() {
        while (++consolidateCounter >= 20) {
            WeakReference weakReference;
            int n;
            int n2;
            consolidateCounter = 0;
            for (n2 = docAct.size() - 1; n2 >= 0; --n2) {
                n = (Integer)docAct.get(n2);
                weakReference = docRefs[n];
                if (weakReference == null || weakReference.get() != null) continue;
                docAct.remove(n2);
                Registry.docRefs[n] = null;
            }
            for (n2 = compAct.size() - 1; n2 >= 0; --n2) {
                n = (Integer)compAct.get(n2);
                weakReference = compRefs[n];
                if (weakReference == null || weakReference.get() != null) continue;
                compAct.remove(n2);
                Registry.compRefs[n] = null;
            }
        }
    }

    private static int getIDImpl(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return -1;
        }
        return ((BaseTextUI)jTextComponent.getUI()).componentID;
    }

    private static Integer getIDInteger(BaseDocument baseDocument) {
        if (baseDocument == null) {
            return null;
        }
        return (Integer)baseDocument.getProperty("id");
    }

    private static boolean doActivate(BaseDocument baseDocument) {
        Integer n = Registry.getIDInteger(baseDocument);
        if (n == null) {
            return false;
        }
        int n2 = n != null ? n : -1;
        int n3 = docAct.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = (Integer)docAct.get(i);
            if (n4 != n2) continue;
            if (i == 0) {
                return false;
            }
            docAct.add(0, docAct.remove(i));
            return true;
        }
        docAct.add(0, n);
        return true;
    }

    private static BaseDocument getValidDoc(int n, boolean bl) {
        Registry.consolidate();
        int n2 = docAct.size();
        while (n >= 0 && n < n2) {
            BaseDocument baseDocument;
            int n3 = (Integer)docAct.get(n);
            WeakReference weakReference = docRefs[n3];
            BaseDocument baseDocument2 = baseDocument = weakReference != null ? (BaseDocument)weakReference.get() : null;
            if (baseDocument != null) {
                return baseDocument;
            }
            n += bl ? 1 : -1;
        }
        return null;
    }

    private static BaseDocument getNextActiveDoc(int n, boolean bl) {
        int n2;
        Registry.consolidate();
        int n3 = docAct.size();
        int n4 = n2 = bl ? 0 : n3 - 1;
        while (n2 >= 0 && n2 < n3) {
            if ((Integer)docAct.get(n2) == n) {
                return Registry.getValidDoc(n2 += bl ? 1 : -1, bl);
            }
            n2 += bl ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getValidComp(int n, boolean bl) {
        Registry.consolidate();
        int n2 = compAct.size();
        while (n >= 0 && n < n2) {
            JTextComponent jTextComponent;
            int n3 = (Integer)compAct.get(n);
            WeakReference weakReference = compRefs[n3];
            JTextComponent jTextComponent2 = jTextComponent = weakReference != null ? (JTextComponent)weakReference.get() : null;
            if (jTextComponent != null) {
                return jTextComponent;
            }
            n += bl ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getNextActiveComp(int n, boolean bl) {
        int n2;
        int n3 = compAct.size();
        int n4 = n2 = bl ? 0 : n3 - 1;
        while (n2 >= 0 && n2 < n3) {
            if ((Integer)compAct.get(n2) == n) {
                return Registry.getValidComp(n2 += bl ? 1 : -1, bl);
            }
            n2 += bl ? 1 : -1;
        }
        return null;
    }

    private static void fireChange() {
        ChangeListener[] changeListenerArray = (ChangeListener[])listenerList.getListeners(ChangeListener.class);
        ChangeEvent changeEvent = new ChangeEvent(Registry.class);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    public static synchronized String registryToString() {
        WeakReference weakReference;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document References:\n");
        for (n = 0; n < docRefsCount; ++n) {
            weakReference = docRefs[n];
            stringBuffer.append("docRefs[" + n + "]=" + (weakReference != null ? weakReference.get() : "null") + "\n");
        }
        stringBuffer.append("Component References:\n");
        for (n = 0; n < compRefsCount; ++n) {
            weakReference = compRefs[n];
            stringBuffer.append("compRefs[" + n + "]=" + (weakReference != null ? weakReference.get() : "null") + "\n");
        }
        stringBuffer.append("\nActive Document Indexes:\n");
        for (n = 0; n < docAct.size(); ++n) {
            stringBuffer.append(docAct.get(n));
            if (n == docAct.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("\nActive Component Indexes:\n");
        for (n = 0; n < compAct.size(); ++n) {
            stringBuffer.append(compAct.get(n));
            if (n == compAct.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    static {
        docAct = new ArrayList();
        compRefs = EMPTY;
        compAct = new ArrayList();
        listenerList = new WeakEventListenerList();
    }
}

