/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.attr;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeParseException;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ColorAttribute
extends Attribute<Color> {
    public ColorAttribute(String string) {
        super(string);
    }

    public ColorAttribute(String string, Color color) {
        super(string, color);
    }

    public ColorAttribute(String string, Color color, boolean bl) {
        super(string, color, bl);
    }

    public ColorAttribute(String string, Color color, boolean bl, boolean bl2) {
        super(string, color, bl, bl2);
    }

    @Override
    @NotNull
    public Color parse(String string) {
        if (string.startsWith("#")) {
            int n = Integer.parseInt(string.substring(1), 16);
            if (string.length() > 7) {
                return new Color(n, true);
            }
            return new Color(n);
        }
        throw new AttributeParseException("Cannot parse " + string + " as color");
    }

    @Override
    @NotNull
    public String asString(Color color) {
        return color == null ? "#000000" : "#" + Integer.toHexString(color.getRGB());
    }
}

