/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AbstractServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.mlwebservices.LoginService;
import com.mathworks.mlwebservices.loginws.ArrayOfMWMessage;
import com.mathworks.mlwebservices.loginws.LoginReturn;
import com.mathworks.mlwebservices.loginws.MWMessage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class LoginThread
extends AbstractServiceThread<String> {
    private final LoginService fLoginService;
    private final String fEmailAddress;
    private final String fPassword;
    private String fToken;
    private Lock fLock = new ReentrantLock();

    LoginThread(ServiceThreadView serviceThreadView, LoginService loginService, String string, String string2) {
        super(serviceThreadView, "dialog.title", "dialog.service", false);
        this.fEmailAddress = string;
        this.fPassword = string2;
        this.fLoginService = loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoginService loginService = this.fLoginService;
        if (loginService.isConnected()) {
            try {
                MWMessage[] mWMessageArray;
                String string = this.getClientString();
                LoginReturn loginReturn = loginService.login(this.fEmailAddress, this.fPassword, string);
                ArrayOfMWMessage arrayOfMWMessage = loginReturn.getMessages();
                boolean bl = false;
                if (arrayOfMWMessage != null && (mWMessageArray = arrayOfMWMessage.getMessage()) != null) {
                    for (MWMessage mWMessage : mWMessageArray) {
                        int n = mWMessage.getSeverity();
                        if (n >= 2) continue;
                        bl = true;
                        this.showError(mWMessage);
                    }
                }
                if (bl) {
                    this.setStatus(ServiceThreadState.FAIL);
                    try {
                        this.fLock.lock();
                        this.fToken = null;
                    }
                    finally {
                        this.fLock.unlock();
                    }
                }
                this.setStatus(ServiceThreadState.SUCCESS);
                try {
                    this.fLock.lock();
                    this.fToken = loginReturn.getToken();
                }
                finally {
                    this.fLock.unlock();
                }
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
            finally {
                if (this.isCancelled()) {
                    try {
                        this.fLock.lock();
                        this.fToken = null;
                    }
                    finally {
                        this.fLock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        } else {
            this.showConnectionError();
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResult() {
        String string;
        try {
            this.fLock.lock();
            string = this.fToken;
        }
        finally {
            this.fLock.unlock();
        }
        return string;
    }
}

