/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.args;

import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.args.Arguments;
import com.mathworks.instutil.args.ArgumentsUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

class ArgumentsUtilityImpl
implements ArgumentsUtility {
    private Logger logger;
    private InstUtilResourceBundle res;

    ArgumentsUtilityImpl(Logger logger, InstUtilResourceBundle instUtilResourceBundle) {
        this.logger = logger;
        this.res = instUtilResourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<String> list, String string) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            Arguments arguments = new Arguments();
            arguments.setArgs(list);
            FileOutputStream fileOutputStream = new FileOutputStream(this.getFile(string));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(arguments);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> read(String string) throws IOException, ClassNotFoundException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectInputStream objectInputStream = null;
        File file = this.getFile(string);
        if (file.isFile() && file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                objectInputStream = new ObjectInputStream(bufferedInputStream);
                Arguments arguments = (Arguments)objectInputStream.readObject();
                arrayList.addAll(arguments.getArgs());
            }
            finally {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                FileIO.deleteSingleFile(file, this.logger, this.res);
            }
        }
        return arrayList;
    }

    private File getFile(String string) {
        String string2 = string.endsWith(File.separator) ? string : string + File.separator;
        return new File(string2 + "args.tmp");
    }
}

