/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Category;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryRange<T>
extends AbstractRange<T>
implements Iterable<Category<T>> {
    private static final String PROPERTY_VALUES = "values";
    private List<T> _possibleValues = null;
    private List<Category<T>> _categoryValues = null;
    private Double minimum;
    private Double maximum;

    public CategoryRange() {
        this._possibleValues = new ArrayList<T>();
        this._categoryValues = new ArrayList<Category<T>>();
    }

    public CategoryRange(T ... TArray) {
        this._possibleValues = new ArrayList<T>();
        this._possibleValues.addAll(Arrays.asList(TArray));
    }

    public CategoryRange(Set<T> set) {
        this._possibleValues = new ArrayList<T>(set);
    }

    public CategoryRange(CategoryRange<T> categoryRange) {
        this._categoryValues = new ArrayList<Category<T>>(categoryRange.getCategoryValues());
        this._possibleValues = new ArrayList<T>(categoryRange.getPossibleValues());
        CategoryRange<T> categoryRange2 = new CategoryRange<T>();
        this.setMinimum(categoryRange.minimum());
        this.setMaximum(categoryRange.maximum());
    }

    public List<T> getPossibleValues() {
        return this._possibleValues;
    }

    public Category<T> getCategory(int n) {
        return this.getCategoryValues().get(n - 1);
    }

    public CategoryRange<T> add(Category<T> category) {
        if (!this.contains(category)) {
            this._possibleValues.add(category.getValue());
            this._categoryValues.add(category);
            category.setRange(this);
            this.firePropertyChange(PROPERTY_VALUES, null, this._possibleValues);
        }
        return this;
    }

    @Override
    public Range<T> copy() {
        return new CategoryRange<T>(this);
    }

    @Override
    public T lower() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        return this._possibleValues.get(0);
    }

    @Override
    public T upper() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        int n = this._possibleValues.size();
        return this._possibleValues.get(n - 1);
    }

    @Override
    public void adjust(T t, T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maximum() {
        if (this.maximum == null) {
            T t = this.upper();
            if (t == null) {
                return 1.0;
            }
            this.maximum = (double)this.position(t) + 1.0;
        }
        return this.maximum;
    }

    @Override
    public double minimum() {
        if (this.minimum == null) {
            T t = this.lower();
            if (t == null) {
                return 0.0;
            }
            this.minimum = (double)this.position(t) - 1.0;
        }
        return this.minimum;
    }

    public void reset() {
        this.maximum = null;
        this.minimum = null;
    }

    public void setMinimum(double d) {
        Double d2 = this.minimum;
        this.minimum = d;
        this.firePropertyChange("min", d2, d);
    }

    public void setMaximum(double d) {
        Double d2 = this.maximum;
        this.maximum = d;
        this.firePropertyChange("max", d2, d);
    }

    @Override
    public double size() {
        if (this._possibleValues == null) {
            return 0.0;
        }
        int n = this._possibleValues.size();
        if (n == 0) {
            return 0.0;
        }
        return this.maximum() - this.minimum();
    }

    public int position(T t) {
        int n = this._possibleValues.indexOf(t);
        if (n < 0) {
            throw new IllegalArgumentException("Value " + t + " not known");
        }
        return 1 + n;
    }

    @Override
    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        for (T t2 : this._possibleValues) {
            if (!t.equals(t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Category<T> category) {
        if (category == null) {
            return false;
        }
        for (Category<T> category2 : this.getCategoryValues()) {
            if (!category.equals(category2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Category<T>> iterator() {
        return this.getCategoryValues().iterator();
    }

    public List<Category<T>> getCategoryValues() {
        if (this._categoryValues == null) {
            this._categoryValues = new ArrayList<Category<T>>();
            for (T t : this._possibleValues) {
                this._categoryValues.add(new Category<T>(t, this));
            }
        }
        return this._categoryValues;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._categoryValues == null ? 0 : ((Object)this._categoryValues).hashCode());
        n = 31 * n + (this._possibleValues == null ? 0 : ((Object)this._possibleValues).hashCode());
        n = 31 * n + (this.maximum == null ? 0 : this.maximum.hashCode());
        n = 31 * n + (this.minimum == null ? 0 : this.minimum.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CategoryRange categoryRange = (CategoryRange)object;
        if (this._categoryValues == null ? categoryRange._categoryValues != null : !((Object)this._categoryValues).equals(categoryRange._categoryValues)) {
            return false;
        }
        if (this._possibleValues == null ? categoryRange._possibleValues != null : !((Object)this._possibleValues).equals(categoryRange._possibleValues)) {
            return false;
        }
        if (this.maximum == null ? categoryRange.maximum != null : !this.maximum.equals(categoryRange.maximum)) {
            return false;
        }
        return !(this.minimum == null ? categoryRange.minimum != null : !this.minimum.equals(categoryRange.minimum));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<CategoryRange ");
        stringBuilder.append("minimum=");
        stringBuilder.append(this.minimum);
        stringBuilder.append(" maximum=");
        stringBuilder.append(this.maximum);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

