/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.RangeSlider;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicRangeSliderUI
extends BasicSliderUI {
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;
    protected static final int MOUSE_HANDLE_LOWER = 5;
    protected static final int MOUSE_HANDLE_UPPER = 6;
    protected boolean hover;
    protected boolean second;
    protected boolean rollover1;
    protected boolean pressed1;
    protected boolean rollover2;
    protected boolean pressed2;

    public BasicRangeSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRangeSliderUI((JSlider)jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.second = false;
        super.paint(graphics, jComponent);
        Rectangle rectangle = graphics.getClipBounds();
        this.second = true;
        Point point = this.adjustThumbForHighValue();
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
        this.restoreThumbForLowValue(point);
        this.second = false;
    }

    protected void restoreThumbForLowValue(Point point) {
        this.thumbRect.x = point.x;
        this.thumbRect.y = point.y;
    }

    protected Point adjustThumbForHighValue() {
        Point point = this.thumbRect.getLocation();
        if (this.slider.getOrientation() == 0) {
            int n = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.x = n - this.thumbRect.width / 2;
        } else {
            int n = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            this.thumbRect.y = n - this.thumbRect.height / 2;
        }
        return point;
    }

    protected void adjustSnapHighValue() {
        int n;
        int n2 = n = ((RangeSlider)this.slider).getHighValue();
        int n3 = this.slider.getMajorTickSpacing();
        int n4 = this.slider.getMinorTickSpacing();
        int n5 = 0;
        if (n4 > 0) {
            n5 = n4;
        } else if (n3 > 0) {
            n5 = n3;
        }
        if (n5 != 0) {
            if ((n - this.slider.getMinimum()) % n5 != 0) {
                float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                int n6 = Math.round(f);
                n2 = this.slider.getMinimum() + n6 * n5;
            }
            if (n2 != n) {
                ((RangeSlider)this.slider).setHighValue(n2);
            }
        }
    }

    protected void calculateThumbLocation() {
        if (this.slider.getSnapToTicks()) {
            this.adjustSnapHighValue();
        }
        super.calculateThumbLocation();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener(super.createTrackListener(jSlider));
    }

    private void offset(int n) {
        this.slider.getModel().setValue(((RangeSlider)this.slider).getLowValue() + n);
    }

    protected int getMouseHandle(int n, int n2) {
        int n3;
        Rectangle rectangle = this.trackRect;
        this.slider.putClientProperty("RangeSlider.mousePosition", null);
        if (this.thumbRect.contains(n, n2)) {
            return 1;
        }
        Point point = this.adjustThumbForHighValue();
        if (this.thumbRect.contains(n, n2)) {
            this.restoreThumbForLowValue(point);
            return 2;
        }
        this.restoreThumbForLowValue(point);
        if (this.slider.getOrientation() == 1) {
            int n4;
            int n5 = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            Rectangle rectangle2 = new Rectangle(rectangle.x, Math.min(n5, n4 = this.yPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.height / 2, rectangle.width, Math.abs(n4 - n5) - this.thumbRect.height);
            if (rectangle2.contains(n, n2)) {
                return 4;
            }
            int n6 = rectangle.y + Math.max(n5, n4) + this.thumbRect.height / 2;
            Rectangle rectangle3 = new Rectangle(rectangle.x, n6, rectangle.width, rectangle.y + rectangle.height - n6);
            if (rectangle3.contains(n, n2)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", true);
                return 5;
            }
            Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, Math.min(n4, n5) - this.thumbRect.height / 2);
            if (rectangle4.contains(n, n2)) {
                this.slider.putClientProperty("RangeSlider.mousePosition", false);
                return 6;
            }
            return 0;
        }
        int n7 = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        Rectangle rectangle5 = new Rectangle(Math.min(n7, n3 = this.xPositionForValue(((RangeSlider)this.slider).getHighValue())) + this.thumbRect.width / 2, rectangle.y, Math.abs(n3 - n7) - this.thumbRect.width, rectangle.height);
        if (rectangle5.contains(n, n2)) {
            return 4;
        }
        Rectangle rectangle6 = new Rectangle(rectangle.x, rectangle.y, Math.min(n7, n3) - this.thumbRect.width / 2 - rectangle.x, rectangle.height);
        if (rectangle6.contains(n, n2)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", true);
            return 5;
        }
        int n8 = rectangle.x + Math.abs(n3 - n7) + this.thumbRect.width / 2;
        Rectangle rectangle7 = new Rectangle(n8, rectangle.y, rectangle.width - n8, rectangle.height);
        if (rectangle7.contains(n, n2)) {
            this.slider.putClientProperty("RangeSlider.mousePosition", false);
            return 6;
        }
        return 0;
    }

    public void paintThumb(Graphics graphics) {
        try {
            Field field = this.getClass().getSuperclass().getDeclaredField("rollover");
            field.setAccessible(true);
            field.set(this, this.second ? this.rollover2 : this.rollover1);
            field = this.getClass().getSuperclass().getDeclaredField("pressed");
            field.setAccessible(true);
            field.set(this, this.second ? this.pressed2 : this.pressed1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        super.paintThumb(graphics);
    }

    protected void setMouseRollover(int n) {
        switch (n) {
            case 1: {
                this.rollover1 = true;
                this.rollover2 = false;
                break;
            }
            case 2: {
                this.rollover2 = true;
                this.rollover1 = false;
                break;
            }
            case 4: {
                this.rollover1 = true;
                this.rollover2 = true;
                break;
            }
            case 0: {
                this.rollover1 = false;
                this.rollover2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    protected void setMousePressed(int n) {
        switch (n) {
            case 1: {
                this.pressed1 = true;
                this.pressed2 = false;
                break;
            }
            case 2: {
                this.pressed2 = true;
                this.pressed1 = false;
                break;
            }
            case 4: {
                this.pressed1 = true;
                this.pressed2 = true;
                break;
            }
            case 0: {
                this.pressed1 = false;
                this.pressed2 = false;
            }
        }
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    protected void setMouseReleased(int n) {
        this.pressed1 = false;
        this.pressed2 = false;
        this.slider.repaint(this.thumbRect);
        Point point = this.adjustThumbForHighValue();
        this.slider.repaint(this.thumbRect);
        this.restoreThumbForLowValue(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object object = this.slider.getClientProperty("RangeSlider.mousePosition");
            int n2 = object == null ? this.slider.getValue() : (Boolean.TRUE.equals(object) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int n3 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n3 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n3 = 1;
            }
            int n4 = n3 * (n > 0 ? 1 : -1);
            if (object == null) {
                this.slider.setValue(n2 + n4);
            } else if (Boolean.TRUE.equals(object)) {
                ((RangeSlider)this.slider).setLowValue(n2 + n4);
            } else {
                ((RangeSlider)this.slider).setHighValue(n2 + n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            Object object = this.slider.getClientProperty("RangeSlider.mousePosition");
            int n2 = object == null ? this.slider.getValue() : (Boolean.TRUE.equals(object) ? ((RangeSlider)this.slider).getLowValue() : ((RangeSlider)this.slider).getHighValue());
            int n3 = 1 * (n > 0 ? 1 : -1);
            if (object == null) {
                this.slider.setValue(n2 + n3);
            } else if (Boolean.TRUE.equals(object)) {
                ((RangeSlider)this.slider).setLowValue(n2 + n3);
            } else {
                ((RangeSlider)this.slider).setHighValue(n2 + n3);
            }
        }
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;
        BasicSliderUI.TrackListener _listener;

        public RangeTrackListener(BasicSliderUI.TrackListener trackListener) {
            super(BasicRangeSliderUI.this);
            this._listener = trackListener;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (BasicRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                BasicRangeSliderUI.this.slider.requestFocus();
            }
            this.handle = BasicRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            BasicRangeSliderUI.this.setMousePressed(this.handle);
            if (this.handle == 2 || this.handle == 1 || this.handle == 4) {
                this.handleOffset = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() - BasicRangeSliderUI.this.yPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue()) : mouseEvent.getX() - BasicRangeSliderUI.this.xPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue());
                this.mouseStartLocation = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
                BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
            } else if (this.handle == 5 || this.handle == 6) {
                this._listener.mousePressed(mouseEvent);
                BasicRangeSliderUI.this.slider.putClientProperty("RangeSlider.mousePosition", null);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n2 = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            int n3 = n = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(n2) : BasicRangeSliderUI.this.valueForXPosition(n2);
            if (n < BasicRangeSliderUI.this.slider.getModel().getMinimum()) {
                n = BasicRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (n > BasicRangeSliderUI.this.slider.getModel().getMaximum()) {
                n = BasicRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 3) {
                if (n2 - this.mouseStartLocation > 2) {
                    this.handle = 2;
                } else if (n2 - this.mouseStartLocation < -2) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)BasicRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(n, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), n));
                    break;
                }
                case 4: {
                    int n4;
                    if (!((RangeSlider)BasicRangeSliderUI.this.slider).isRangeDraggable()) break;
                    int n5 = n4 = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(n2 - this.handleOffset) - rangeSlider.getLowValue() : BasicRangeSliderUI.this.valueForXPosition(n2 - this.handleOffset) - rangeSlider.getLowValue();
                    if (n4 < 0 && rangeSlider.getLowValue() + n4 < rangeSlider.getMinimum()) {
                        n4 = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (n4 > 0 && rangeSlider.getHighValue() + n4 > rangeSlider.getMaximum()) {
                        n4 = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (n4 == 0) break;
                    BasicRangeSliderUI.this.offset(n4);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
            BasicRangeSliderUI.this.setMouseReleased(this.handle);
            this._listener.mouseReleased(mouseEvent);
        }

        private void setCursor(int n) {
            Cursor cursor = Cursor.getPredefinedCursor(n);
            if (BasicRangeSliderUI.this.slider.getCursor() != cursor) {
                BasicRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n = BasicRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            BasicRangeSliderUI.this.setMouseRollover(n);
            switch (n) {
                case 1: {
                    this.setCursor(0);
                    break;
                }
                case 2: {
                    this.setCursor(0);
                    break;
                }
                case 4: {
                    if (BasicRangeSliderUI.this.slider instanceof RangeSlider && ((RangeSlider)BasicRangeSliderUI.this.slider).isRangeDraggable()) {
                        this.setCursor(13);
                        break;
                    }
                    this.setCursor(0);
                    break;
                }
                default: {
                    this.setCursor(0);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                BasicRangeSliderUI.this.slider.getModel().setValue(BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.getModel().setExtent(BasicRangeSliderUI.this.slider.getModel().getMaximum() - BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicRangeSliderUI.this.hover = true;
            BasicRangeSliderUI.this.slider.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicRangeSliderUI.this.hover = false;
            BasicRangeSliderUI.this.slider.repaint();
            this.setCursor(0);
        }
    }
}

