/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLWorkerThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;

public class GLDrawableHelper {
    private volatile List listeners = new ArrayList();
    private static final boolean DEBUG = Debug.debug("GLDrawableHelper");
    private static final boolean VERBOSE = Debug.verbose();
    private static final boolean NVIDIA_CRASH_WORKAROUND = Debug.isPropertyDefined("jogl.nvidia.crash.workaround");
    private boolean autoSwapBufferMode = true;
    private static final ThreadLocal perThreadInitAction = new ThreadLocal();

    public synchronized void addGLEventListener(GLEventListener gLEventListener) {
        List list = (List)((ArrayList)this.listeners).clone();
        list.add(gLEventListener);
        this.listeners = list;
    }

    public synchronized void removeGLEventListener(GLEventListener gLEventListener) {
        List list = (List)((ArrayList)this.listeners).clone();
        list.remove(gLEventListener);
        this.listeners = list;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).init(gLAutoDrawable);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).display(gLAutoDrawable);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((GLEventListener)iterator.next()).reshape(gLAutoDrawable, n, n2, n3, n4);
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        boolean bl;
        boolean bl2 = bl = gLContext instanceof GLContextImpl && ((GLContextImpl)gLContext).isOptimizable();
        if (GLWorkerThread.isStarted() && GLWorkerThread.isWorkerThread() && bl) {
            GLContext gLContext2 = GLContext.getCurrent();
            Runnable runnable3 = (Runnable)perThreadInitAction.get();
            if (gLContext2 != null && gLContext2 != gLContext) {
                gLContext2.release();
            } else {
                gLContext2 = null;
            }
            int n = 0;
            try {
                n = gLContext.makeCurrent();
                if (n == 0) return;
                perThreadInitAction.set(runnable2);
                if (n == 2) {
                    if (DEBUG) {
                        System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                    }
                    runnable2.run();
                }
                if (DEBUG && VERBOSE) {
                    System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running runnable");
                }
                runnable.run();
                if (!this.autoSwapBufferMode || gLDrawable == null) return;
                gLDrawable.swapBuffers();
                return;
            }
            finally {
                int n2;
                if (NVIDIA_CRASH_WORKAROUND) {
                    try {
                        if (n != 0) {
                            gLContext.release();
                        }
                    }
                    catch (Exception exception) {}
                }
                if (gLContext2 != null && (n2 = gLContext2.makeCurrent()) == 2) {
                    runnable3.run();
                }
            }
        }
        GLContext gLContext3 = GLContext.getCurrent();
        Runnable runnable4 = (Runnable)perThreadInitAction.get();
        if (gLContext3 != null) {
            gLContext3.release();
        }
        int n = 0;
        try {
            n = gLContext.makeCurrent();
            if (n == 0) return;
            perThreadInitAction.set(runnable2);
            if (n == 2) {
                if (DEBUG) {
                    System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                }
                runnable2.run();
            }
            if (DEBUG && VERBOSE) {
                System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running runnable");
            }
            runnable.run();
            if (!this.autoSwapBufferMode || gLDrawable == null) return;
            gLDrawable.swapBuffers();
            return;
        }
        finally {
            int n3;
            try {
                if (n != 0) {
                    gLContext.release();
                }
            }
            catch (Exception exception) {}
            if (gLContext3 != null && (n3 = gLContext3.makeCurrent()) == 2) {
                runnable4.run();
            }
        }
    }
}

