/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print.jdk12;

import ice.debug.Debug;
import ice.storm.StormPrinter;
import ice.storm.print.jdk12.PageFormatConverter;
import ice.storm.print.jdk12.PrintablePage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class PageableDocument {
    StormPrinter stormPrinter;
    PageFormat pageFormat;
    private String documentName = "StormPrinter";
    private boolean isPrintDialogVisible = false;
    private boolean isPageDialogVisible = false;

    public PageableDocument(StormPrinter stormPrinter) {
        this.stormPrinter = stormPrinter;
        this.pageFormat = PageFormatConverter.getPageFormat(stormPrinter.getStormPageFormat());
    }

    public void setStormPrinter(StormPrinter stormPrinter) {
        this.stormPrinter = stormPrinter;
        this.pageFormat = PageFormatConverter.getPageFormat(stormPrinter.getStormPageFormat());
    }

    public void setPrintDialogVisible(boolean bl) {
        this.isPrintDialogVisible = bl;
    }

    public void setPageDialogVisible(boolean bl) {
        this.isPageDialogVisible = bl;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String string) {
        this.documentName = string;
    }

    public void print() {
        this.print(0, this.stormPrinter.getPageCount() - 1);
    }

    public void print(int n, int n2) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(this.documentName);
        if (this.isPageDialogVisible) {
            this.pageFormat = printerJob.pageDialog(new PageFormat());
            this.stormPrinter.setStormPageFormat(PageFormatConverter.getStormPageFormat(this.pageFormat));
            n2 = this.stormPrinter.getPageCount() - 1;
        }
        if (n2 > this.stormPrinter.getPageCount() - 1 || n < 0 || n2 < n) {
            throw new IndexOutOfBoundsException("start " + n + " end " + n2);
        }
        Book book = new Book();
        for (int i = n; i <= n2; ++i) {
            PrintablePage printablePage = new PrintablePage(this.stormPrinter, i);
            book.append(printablePage, this.pageFormat);
        }
        printerJob.setPageable(book);
        try {
            if (this.isPrintDialogVisible) {
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            } else {
                printerJob.print();
            }
        }
        catch (Exception exception) {
            Debug.ex((Throwable)exception);
        }
    }
}

