/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.swing.AccessibleLink;
import ice.pilots.html4.swing.DocView;
import java.util.Vector;

class AccessibleLinkIndex {
    private Vector links;
    private Html4DocumentAccess docAccess;

    public AccessibleLinkIndex(Html4DocumentAccess html4DocumentAccess) {
        this.docAccess = html4DocumentAccess;
        this.links = new Vector();
    }

    public void processDoc(DDocument dDocument) {
        this.processNodes(dDocument.getRootDNode());
    }

    private void processNodes(DNode dNode) {
        if (dNode == null) {
            return;
        }
        this.processNode(dNode);
        for (DNode dNode2 = (DNode)dNode.getFirstChild(); dNode2 != null; dNode2 = (DNode)dNode2.getNextSibling()) {
            this.processNodes(dNode2);
        }
    }

    private void processNode(DNode dNode) {
        if (!(dNode instanceof DAnchorElement)) {
            return;
        }
        this.links.addElement(dNode);
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public AccessibleLink getLink(int n, DocView docView) {
        if (n < 0 || n > this.links.size()) {
            return null;
        }
        DAnchorElement dAnchorElement = (DAnchorElement)this.links.get(n);
        AccessibleLink accessibleLink = new AccessibleLink(dAnchorElement, docView, this.docAccess);
        return accessibleLink;
    }

    public int getIndexFromNode(DAnchorElement dAnchorElement) {
        return this.links.indexOf(dAnchorElement);
    }
}

