/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;

class FormInputButton
extends Button
implements ObjectPainter,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;

    FormInputButton(DocView docView, DElement dElement, String string) {
        super(string);
        this.docView = docView;
        this.element = (DInputElement)dElement;
        String string2 = this.element.getValue();
        if (string2 != null) {
            this.setLabel(string2);
        }
        this.checkAttributes();
        this.enableEvents(28L);
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        String string = this.element.getValue();
        if (string != null && !string.equals(this.getLabel())) {
            this.setLabel(string);
            this.box.invalidate();
            this.box.reqReflow();
        } else {
            this.checkAttributes();
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        Font font = cSSAttribs.getFont();
        if (!font.equals(this.getFont())) {
            Container container = this.getParent();
            container.remove(this);
            super.setFont(font);
            container.add(this);
        }
    }
}

