/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.TextBox;
import ice.pilots.html4.TheView;

public class Search {
    private DDocument doc;
    private CSSLayout cssLayout;
    private Html4DocumentAccess docAccess;
    private int mutation = 0;
    private char[] searchText;
    private char[] lowerCaseSearchText;
    private boolean caseSensitive = false;
    private boolean wholeWordSearch = false;
    private char[] allChars;
    private int numChars;
    private int[] charIndex;
    private DTextNode[] nodes;
    private int numNodes;
    private int searchPos;
    private int wordSearchIndex;

    Search(DDocument dDocument, CSSLayout cSSLayout) {
        this.doc = dDocument;
        this.cssLayout = cSSLayout;
        this.docAccess = new Html4DocumentAccess(dDocument.getPilot());
        this.record();
    }

    public void dispose() {
        this.cssLayout.clearSelection();
        this.searchPos = 0;
    }

    public void setSearchPosToStart() {
        this.searchPos = 0;
    }

    public void setWholeWordSearch(boolean bl) {
        this.wholeWordSearch = bl;
    }

    public boolean getWholeWordSearch() {
        return this.wholeWordSearch;
    }

    public void setSearchText(String string) {
        this.searchText = string.toCharArray();
        this.lowerCaseSearchText = string.toLowerCase().toCharArray();
    }

    public void setMatchCase(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean getMatchCase() {
        return this.caseSensitive;
    }

    public boolean findNext() {
        if (this.searchText == null) {
            return false;
        }
        if (this.wholeWordSearch) {
            return this.findNextWholeWord();
        }
        if (this.doc.getMutation() != this.mutation) {
            this.record();
        }
        int n = 0;
        int n2 = 0;
        for (n = this.searchPos; n < this.numChars - this.searchText.length; ++n) {
            if (this.caseSensitive) {
                for (n2 = 0; n2 < this.searchText.length && this.allChars[n + n2] == this.searchText[n2]; ++n2) {
                }
            } else {
                for (n2 = 0; n2 < this.searchText.length; ++n2) {
                    char c = this.allChars[n + n2];
                    if ((c = Character.toLowerCase(c)) == this.lowerCaseSearchText[n2]) {
                        continue;
                    }
                    break;
                }
            }
            if (n2 != this.searchText.length) continue;
            this.select(n, n + this.searchText.length);
            this.searchPos = n + 1;
            return true;
        }
        this.cssLayout.clearSelection();
        this.searchPos = 0;
        return false;
    }

    public boolean findNextWholeWord() {
        int n = 0;
        int n2 = 0;
        String string = new String(this.searchText).trim();
        if (!string.equals("")) {
            int n3 = this.docAccess.getCount(2);
            String string2 = null;
            int n4 = n = this.wordSearchIndex == 0 ? 0 : this.wordSearchIndex + 1;
            while (n < n3) {
                char c;
                string2 = this.docAccess.getText(2, n).trim();
                while (string2.length() > 0 && this.isStrippable(c = string2.charAt(string2.length() - 1))) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                while (string2.length() > 0 && this.isStrippable(c = string2.charAt(0))) {
                    string2 = string2.substring(1, string2.length());
                }
                if (!this.caseSensitive && string2.equalsIgnoreCase(string) || this.caseSensitive && string2.equals(string)) {
                    this.cssLayout.selectWordByIndex(n);
                    this.wordSearchIndex = n;
                    this.docAccess.positionToIndex(2, n);
                    this.searchPos = n2 = this.docAccess.getCaretPosition(1);
                    break;
                }
                ++n;
            }
            if (n == n3) {
                this.cssLayout.clearSelection();
                this.searchPos = 0;
                this.wordSearchIndex = 0;
                return false;
            }
        }
        return true;
    }

    private boolean isStrippable(char c) {
        return c == '.' || c == '\"' || c == ',' || c == '!' || c == '?' || c == '&' || c == '/' || c == '|' || c == ';' || c == '-' || c == '_' || c == '+' || c == '=' || c == '~' || c == '*' || c == '+' || c == '@' || c == '#' || c == '$' || c == '^' || c == '`' || c == '%' || c == '(' || c == '{' || c == '[' || c == '}' || c == ']' || c == ')';
    }

    public boolean findPrevious() {
        if (this.searchText == null) {
            return false;
        }
        if (this.doc.getMutation() != this.mutation) {
            this.record();
        }
        int n = 0;
        int n2 = 0;
        for (n = this.searchPos; n >= 0; --n) {
            if (this.caseSensitive) {
                for (n2 = 0; n2 < this.searchText.length && this.allChars[n + n2] == this.searchText[n2]; ++n2) {
                }
            } else {
                for (n2 = 0; n2 < this.searchText.length; ++n2) {
                    char c = this.allChars[n + n2];
                    if ((c = Character.toLowerCase(c)) == this.lowerCaseSearchText[n2]) {
                        continue;
                    }
                    break;
                }
            }
            if (n2 != this.searchText.length) continue;
            this.select(n, n + this.searchText.length);
            this.searchPos = n - 1;
            return true;
        }
        this.cssLayout.clearSelection();
        this.searchPos = this.numChars - this.searchText.length;
        return false;
    }

    private final void select(int n, int n2) {
        DTextNode dTextNode = null;
        DTextNode dTextNode2 = null;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            DTextNode dTextNode3 = this.nodes[i];
            int n5 = this.charIndex[i];
            if (n >= n5 && n < n5 + dTextNode3.text.length) {
                dTextNode = dTextNode3;
                n3 = n - n5;
            }
            if (n2 < n5 || n2 >= n5 + dTextNode3.text.length) continue;
            dTextNode2 = dTextNode3;
            n4 = n2 - n5;
        }
        if (dTextNode != null && dTextNode2 != null) {
            TheView theView = (TheView)this.doc.getDefaultView();
            if (theView != null) {
                this.cssLayout.scrollToBox(dTextNode);
            }
            this.cssLayout.selection.setRange(dTextNode, n3, dTextNode2, n4);
            this.cssLayout.somethingSelected = true;
            this.cssLayout.docPane.reqRepaint();
        }
    }

    private final void record() {
        CSSBox cSSBox;
        this.mutation = this.doc.getMutation();
        this.allChars = new char[1024];
        this.numChars = 0;
        this.charIndex = new int[16];
        this.nodes = new DTextNode[16];
        this.numNodes = 0;
        DNode dNode = (DNode)((Object)this.doc.getDocumentElement());
        if (dNode != null && (cSSBox = this.cssLayout.findCSSBox(dNode)) != null) {
            this.record_r(cSSBox);
        }
    }

    private final void record_r(CSSBox cSSBox) {
        if (cSSBox instanceof TextBox && (cSSBox.css.misc & 1) != 0) {
            Object[] objectArray;
            DTextNode[] dTextNodeArray;
            if (this.numNodes >= this.nodes.length) {
                dTextNodeArray = new DTextNode[this.nodes.length * 2];
                System.arraycopy(this.nodes, 0, dTextNodeArray, 0, this.numNodes);
                this.nodes = dTextNodeArray;
                objectArray = new int[this.nodes.length * 2];
                System.arraycopy(this.charIndex, 0, objectArray, 0, this.numNodes);
                this.charIndex = objectArray;
            }
            dTextNodeArray = (DTextNode[])cSSBox;
            this.nodes[this.numNodes] = (DTextNode)dTextNodeArray.getDomNode();
            this.charIndex[this.numNodes] = this.numChars;
            ++this.numNodes;
            objectArray = dTextNodeArray.getText();
            if (this.numChars + objectArray.length >= this.allChars.length) {
                int n;
                for (n = this.allChars.length * 2; this.numChars + objectArray.length >= n; n *= 2) {
                }
                char[] cArray = new char[n];
                System.arraycopy(this.allChars, 0, cArray, 0, this.allChars.length);
                this.allChars = cArray;
            }
            System.arraycopy(objectArray, 0, this.allChars, this.numChars, objectArray.length);
            this.numChars += objectArray.length;
        } else {
            cSSBox = cSSBox.getFirstChild();
            while (cSSBox != null) {
                this.record_r(cSSBox);
                cSSBox = cSSBox.next;
            }
        }
    }
}

