/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public final class CopyOnWriteList<T>
implements Iterable<T>,
Collection<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private AtomicReference<T[]> ref;

    public CopyOnWriteList() {
        this.ref = new AtomicReference<Object[]>(EMPTY_ARRAY);
    }

    public CopyOnWriteList(T t) {
        this.ref = new AtomicReference<Object[]>(new Object[]{t});
    }

    public CopyOnWriteList(Collection<? extends T> collection) {
        Object[] objectArray = collection.toArray(new Object[collection.size()]);
        this.ref = new AtomicReference<Object[]>(objectArray);
    }

    @Override
    public boolean add(T t) {
        Object[] objectArray;
        T[] TArray;
        do {
            TArray = this.ref.get();
            int n = TArray.length;
            objectArray = new Object[n + 1];
            System.arraycopy(TArray, 0, objectArray, 0, n);
            objectArray[n] = t;
        } while (!this.ref.compareAndSet(TArray, objectArray));
        return true;
    }

    public void addIfAbsent(T t) {
        Object[] objectArray;
        T[] TArray;
        do {
            TArray = this.ref.get();
            int n = TArray.length;
            for (T t2 : TArray) {
                if (t2 == null && t == null) {
                    return;
                }
                if (t2 == null || !t2.equals(t)) continue;
                return;
            }
            objectArray = new Object[n + 1];
            System.arraycopy(TArray, 0, objectArray, 0, n);
            objectArray[n] = t;
        } while (!this.ref.compareAndSet(TArray, objectArray));
    }

    @Override
    public boolean remove(Object object) {
        boolean bl;
        Object[] objectArray;
        T[] TArray;
        do {
            T t;
            int n;
            TArray = this.ref.get();
            int n2 = TArray.length;
            for (n = 0; !(n >= n2 || (t = TArray[n]) == null && object == null || t != null && t.equals(object)); ++n) {
            }
            if (n >= n2) {
                bl = false;
                break;
            }
            objectArray = new Object[n2 - 1];
            System.arraycopy(TArray, 0, objectArray, 0, n);
            if (n < n2 - 1) {
                System.arraycopy(TArray, n + 1, objectArray, n, n2 - n - 1);
            }
            bl = true;
        } while (!this.ref.compareAndSet(TArray, objectArray));
        return bl;
    }

    public Object getTimestamp() {
        return this.ref.get();
    }

    public boolean isTimestampChanged(Object object) {
        return this.ref.get() != object;
    }

    @Override
    public int size() {
        return this.ref.get().length;
    }

    public T get(int n) {
        return this.ref.get()[n];
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator<T>(this.ref.get());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        for (T t : this.ref.get()) {
            if (t == null && object == null) {
                return true;
            }
            if (t == null || !t.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.ref.get();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        T[] TArray2 = this.ref.get();
        int n = TArray2.length;
        if (TArray.length < n) {
            return Arrays.copyOf(TArray2, n, TArray.getClass());
        }
        System.arraycopy(TArray2, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.ref = new AtomicReference<Object[]>(EMPTY_ARRAY);
    }

    private static class MyIterator<T>
    implements Iterator<T> {
        private T[] fArray;
        private int fCurrent;

        MyIterator(T[] TArray) {
            this.fArray = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrent < this.fArray.length;
        }

        @Override
        public T next() {
            T t = this.fCurrent < this.fArray.length ? (T)this.fArray[this.fCurrent++] : null;
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

