/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class FileSystemNotifier {
    private final List<WeakReference<FileSystemListener>> fListeners = new ArrayList<WeakReference<FileSystemListener>>();

    public void created(File file) {
        List<FileSystemListener> list = this.createFileSystemListenerListCopy();
        for (FileSystemListener fileSystemListener : list) {
            fileSystemListener.fileCreated(file);
        }
    }

    public void changed(File file) {
        List<FileSystemListener> list = this.createFileSystemListenerListCopy();
        for (FileSystemListener fileSystemListener : list) {
            fileSystemListener.fileChanged(file);
        }
    }

    public void moved(File file, File file2) {
        List<FileSystemListener> list = this.createFileSystemListenerListCopy();
        for (FileSystemListener fileSystemListener : list) {
            if (PlatformInfo.isWindows() && FileUtils.hasSameParent(file, file2) && file.getName().equalsIgnoreCase(file2.getName())) {
                fileSystemListener.fileChanged(file);
                continue;
            }
            fileSystemListener.fileMoved(file, file2);
        }
    }

    public synchronized void deleted(File file) {
        List<FileSystemListener> list = this.createFileSystemListenerListCopy();
        for (FileSystemListener fileSystemListener : list) {
            fileSystemListener.fileDeleted(file);
        }
    }

    public synchronized void addFileSystemListener(FileSystemListener fileSystemListener) {
        this.fListeners.add(new WeakReference<FileSystemListener>(fileSystemListener));
    }

    public synchronized void removeFileSystemListener(FileSystemListener fileSystemListener) {
        Iterator<WeakReference<FileSystemListener>> iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<FileSystemListener> weakReference = iterator.next();
            if (!fileSystemListener.equals(weakReference.get())) continue;
            iterator.remove();
        }
    }

    private synchronized List<FileSystemListener> createFileSystemListenerListCopy() {
        Vector<FileSystemListener> vector = new Vector<FileSystemListener>();
        ArrayList<WeakReference<FileSystemListener>> arrayList = new ArrayList<WeakReference<FileSystemListener>>();
        for (WeakReference<FileSystemListener> weakReference : this.fListeners) {
            if (weakReference.get() == null) {
                arrayList.add(weakReference);
                continue;
            }
            vector.add((FileSystemListener)weakReference.get());
        }
        this.fListeners.removeAll(arrayList);
        return vector;
    }
}

