/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.html.UrlResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;

public class HtmlSourceReader {
    public static String getSource(String string) {
        return HtmlSourceReader.getSource(string, CharsetDetectionStrategy.getDefaultCharsetStrategy());
    }

    public static String getSource(String string, Charset charset) {
        CharsetDetectionStrategy charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy(charset);
        return HtmlSourceReader.getSource(string, charsetDetectionStrategy);
    }

    public static String getSource(String string, String string2) throws UnsupportedEncodingException {
        CharsetDetectionStrategy charsetDetectionStrategy = CharsetDetectionStrategy.getCharsetStrategy(string2);
        return HtmlSourceReader.getSource(string, charsetDetectionStrategy);
    }

    public static String getSource(String string, CharsetDetectionStrategy charsetDetectionStrategy) {
        Charset charset = charsetDetectionStrategy.getCharset(string);
        InputStream inputStream = HtmlSourceReader.getInputStreamForUrl(string);
        if (inputStream != null) {
            return HtmlSourceReader.readInputStream(inputStream, charset);
        }
        return null;
    }

    static InputStream getInputStreamForUrl(String string) {
        InputStreamUrlResolver inputStreamUrlResolver = new InputStreamUrlResolver();
        inputStreamUrlResolver.acceptUrl(string);
        return inputStreamUrlResolver.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStream(InputStream inputStream, Charset charset) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuilder.append(string).append('\n');
                string = bufferedReader.readLine();
            }
            string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            try {
                bufferedReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    static interface HtmlSourceStream {
        public InputStream getInputStream();

        public void close();
    }

    private static class InputStreamUrlResolver
    extends UrlResolver {
        private InputStream iInputStream;

        private InputStreamUrlResolver() {
        }

        @Override
        protected void handleFileLocation(File file) {
            try {
                this.iInputStream = new FileInputStream(file);
            }
            catch (IOException iOException) {
                this.iInputStream = null;
            }
        }

        @Override
        protected void handleUrlLocation(URL uRL) {
            try {
                this.iInputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                this.iInputStream = null;
            }
        }

        private InputStream getInputStream() {
            return this.iInputStream;
        }
    }
}

