/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.internal;

import com.mathworks.toolbox.javabuilder.MWException;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.swing.SwingUtilities;

public class MCRThreadUtilities {
    private static Method sEventQueue_dispatchEvent = null;
    private static boolean sAWTAutoShutdownFound;
    private static Method sAWTAutoShutdown_getInstance;
    private static Method sAWTAutoShutdown_notifyThreadBusy;
    private static Method sAWTAutoShutdown_notifyThreadFree;
    private static ScheduledThreadPoolExecutor sThreadPool;

    public static <T> T runWhilePumpingEventQueue(Callable<T> callable) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            return MCRThreadUtilities.runBackgroundTask(callable);
        }
        return callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T runBackgroundTask(Callable<T> callable) throws Exception {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        CallableWrapper<T> callableWrapper = new CallableWrapper<T>(callable, eventQueue);
        Future<T> future = sThreadPool.submit(callableWrapper);
        if (null == sEventQueue_dispatchEvent) {
            throw new MWException("Failed to reset access on EventQueue.dispatchEvent; task must run asynchronously");
        }
        try {
            AWTKeepAliveHelperThread aWTKeepAliveHelperThread = null;
            if (sAWTAutoShutdownFound) {
                aWTKeepAliveHelperThread = new AWTKeepAliveHelperThread(Thread.currentThread());
                aWTKeepAliveHelperThread.start();
            }
            try {
                while (!(future.isDone() || future.isCancelled() || callableWrapper.isTaskRun())) {
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    sEventQueue_dispatchEvent.invoke((Object)eventQueue, aWTEvent);
                }
            }
            finally {
                if (aWTKeepAliveHelperThread != null) {
                    aWTKeepAliveHelperThread.requestStopAndJoin();
                }
            }
            if (!sAWTAutoShutdownFound) return future.get();
        }
        catch (Throwable throwable) {
            if (!sAWTAutoShutdownFound) throw throwable;
            sAWTAutoShutdown_notifyThreadFree.invoke(sAWTAutoShutdown_getInstance.invoke(null, new Object[0]), Thread.currentThread());
            throw throwable;
        }
        sAWTAutoShutdown_notifyThreadFree.invoke(sAWTAutoShutdown_getInstance.invoke(null, new Object[0]), Thread.currentThread());
        return future.get();
    }

    static {
        sAWTAutoShutdown_getInstance = null;
        sAWTAutoShutdown_notifyThreadBusy = null;
        sAWTAutoShutdown_notifyThreadFree = null;
        try {
            sEventQueue_dispatchEvent = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    Method method = null;
                    try {
                        method = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                        method.setAccessible(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return method;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        try {
            Class<?> clazz = Class.forName("sun.awt.AWTAutoShutdown");
            boolean bl = sAWTAutoShutdownFound = clazz != null;
            if (sAWTAutoShutdownFound) {
                sAWTAutoShutdown_getInstance = clazz.getMethod("getInstance", new Class[0]);
                sAWTAutoShutdown_notifyThreadBusy = clazz.getMethod("notifyThreadBusy", Thread.class);
                sAWTAutoShutdown_notifyThreadFree = clazz.getMethod("notifyThreadFree", Thread.class);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            sAWTAutoShutdownFound = false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            sAWTAutoShutdownFound = false;
        }
        sThreadPool = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    private static class AWTKeepAliveHelperThread
    extends Thread {
        private boolean stopRequested = false;
        private Thread eventDispatchThread;

        public AWTKeepAliveHelperThread(Thread thread) {
            this.eventDispatchThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStopAndJoin() throws InterruptedException {
            AWTKeepAliveHelperThread aWTKeepAliveHelperThread = this;
            synchronized (aWTKeepAliveHelperThread) {
                this.stopRequested = true;
                this.notify();
            }
            this.join();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AWTKeepAliveHelperThread aWTKeepAliveHelperThread = this;
            synchronized (aWTKeepAliveHelperThread) {
                while (!this.stopRequested) {
                    try {
                        sAWTAutoShutdown_notifyThreadBusy.invoke(sAWTAutoShutdown_getInstance.invoke(null, new Object[0]), this.eventDispatchThread);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    private static class CallableWrapper<T>
    implements Callable<T> {
        private boolean taskRun = false;
        private EventQueue eventQueue;
        private Callable<T> task;

        public CallableWrapper(Callable<T> callable, EventQueue eventQueue) {
            this.task = callable;
            this.eventQueue = eventQueue;
        }

        public boolean isTaskRun() {
            return this.taskRun;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            T t;
            try {
                t = this.task.call();
                this.eventQueue.postEvent(new InvocationEvent((Object)this, new Runnable(){

                    @Override
                    public void run() {
                        CallableWrapper.this.taskRun = true;
                    }
                }));
            }
            catch (Throwable throwable) {
                this.eventQueue.postEvent(new InvocationEvent((Object)this, new /* invalid duplicate definition of identical inner class */));
                throw throwable;
            }
            return t;
        }
    }
}

