/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.datatransfer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public abstract class AutoScroller {
    private static final int AUTOSCROLL_LEFT = 1;
    private static final int AUTOSCROLL_RIGHT = 2;
    private static final int AUTOSCROLL_TOP = 4;
    private static final int AUTOSCROLL_BOTTOM = 8;
    private JComponent fComponent;

    public AutoScroller(JComponent jComponent) {
        this.fComponent = jComponent;
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.fComponent.getVisibleRect();
        Dimension dimension = this.fComponent.getSize();
        int n = this.getAutoscrollRowHeight();
        int n2 = this.getAutoscrollColumnWidth();
        return new Insets(rectangle.y + n, rectangle.x + n2, dimension.height - rectangle.y - rectangle.height + n, dimension.width - rectangle.x - rectangle.width + n2);
    }

    public void autoscroll(Point point) {
        JScrollBar jScrollBar;
        Container container;
        for (container = this.fComponent.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
        }
        if (container != null && !((JScrollPane)container).getViewport().getView().equals(this.fComponent)) {
            return;
        }
        JScrollPane jScrollPane = (JScrollPane)container;
        int n = this.getSide(point);
        try {
            if ((n & 0xC) != 0) {
                jScrollBar = jScrollPane.getVerticalScrollBar();
                if ((n & 4) != 0) {
                    jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(-1));
                }
                if ((n & 8) != 0) {
                    jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if ((n & 3) != 0) {
                jScrollBar = jScrollPane.getHorizontalScrollBar();
                if ((n & 1) != 0) {
                    jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(-1));
                }
                if ((n & 2) != 0) {
                    jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected int getSide(Point point) {
        Insets insets = this.getAutoscrollInsets();
        int n = 0;
        int n2 = this.fComponent.getWidth();
        int n3 = this.fComponent.getHeight();
        if (point.x < insets.left) {
            n |= 1;
        }
        if (point.x >= n2 - insets.right) {
            n |= 2;
        }
        if (point.y < insets.top) {
            n |= 4;
        }
        if (point.y >= n3 - insets.bottom) {
            n |= 8;
        }
        if ((n & 3) == 3) {
            n = point.x > n2 / 2 ? (n &= 0xFFFFFFFE) : (n &= 0xFFFFFFFD);
        }
        if ((n & 0xC) == 12) {
            n = point.x > n3 / 2 ? (n &= 0xFFFFFFFB) : (n &= 0xFFFFFFF7);
        }
        return n;
    }

    public abstract int getAutoscrollRowHeight();

    public abstract int getAutoscrollColumnWidth();
}

