/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxtree;

import com.mathworks.mwswing.checkboxtree.SelectionState;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

class TriStateButtonUI
extends ButtonUI {
    private static final Color ALPHA_SHADOW = new Color(1.0f, 1.0f, 1.0f, 0.6f);
    private static final Color WINDOWS_XP_CHECK_COLOR = new Color(116, 194, 116);
    private static final Paint WINDOWS_VISTA_CHECK_PAINT_OUTER = new GradientPaint(6.0f, 4.0f, new Color(41, 98, 141), 12.0f, 12.0f, new Color(25, 59, 85));
    private static final Paint WINDOWS_VISTA_CHECK_PAINT_INNER = new GradientPaint(7.0f, 5.0f, new Color(127, 200, 228), 11.0f, 11.0f, new Color(37, 89, 140));
    private static final Icon MAC_EMPTY_ICON = new Icon(){

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    };
    private static final Icon MAC_MIXED_ICON = PlatformInfo.isMacintosh() ? new ImageIcon(TriStateButtonUI.class.getResource("/com/mathworks/mwswing/checkboxtree/resources/mac_mixed_checkbox.png")) : null;
    private static final Dimension size = new Dimension();
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private final ButtonUI fDelegate;

    public TriStateButtonUI(ButtonUI buttonUI) {
        if (buttonUI == null) {
            throw new IllegalArgumentException("'delegate' cannot be null");
        }
        this.fDelegate = buttonUI;
    }

    @Override
    public boolean contains(JComponent jComponent, int n, int n2) {
        return this.fDelegate.contains(jComponent, n, n2);
    }

    @Override
    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return this.fDelegate.getAccessibleChild(jComponent, n);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent jComponent) {
        return this.fDelegate.getAccessibleChildrenCount(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.fDelegate.getMaximumSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.fDelegate.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.fDelegate.getPreferredSize(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.fDelegate.installUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.fDelegate.uninstallUI(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.fDelegate.paint(graphics, jComponent);
        SelectionState selectionState = (SelectionState)jComponent.getClientProperty("selectionState");
        if (selectionState == SelectionState.MIXED) {
            Rectangle rectangle = this.getIconLocation(graphics, jComponent);
            if (PlatformInfo.isWindowsXPAppearance()) {
                graphics.setColor(WINDOWS_XP_CHECK_COLOR);
                graphics.fillRect(rectangle.x + 3, rectangle.y + 3, 7, 7);
            } else if (PlatformInfo.isWindowsVistaAppearance()) {
                graphics2D.setPaint(WINDOWS_VISTA_CHECK_PAINT_OUTER);
                graphics.fillRect(rectangle.x + 2, rectangle.y + 2, 9, 9);
                graphics2D.setPaint(WINDOWS_VISTA_CHECK_PAINT_INNER);
                graphics.fillRect(rectangle.x + 3, rectangle.y + 3, 7, 7);
            } else if (PlatformInfo.isMacintosh()) {
                MAC_MIXED_ICON.paintIcon(jComponent, graphics, rectangle.x, rectangle.y + 1);
            } else {
                graphics2D.setComposite(AlphaComposite.SrcAtop);
                graphics2D.setColor(ALPHA_SHADOW);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private Rectangle getIconLocation(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        abstractButton.getSize(size);
        TriStateButtonUI.viewRect.x = insets.left;
        TriStateButtonUI.viewRect.y = insets.top;
        TriStateButtonUI.viewRect.width = TriStateButtonUI.size.width - (insets.right + TriStateButtonUI.viewRect.x);
        TriStateButtonUI.viewRect.height = TriStateButtonUI.size.height - (insets.bottom + TriStateButtonUI.viewRect.y);
        TriStateButtonUI.iconRect.height = 0;
        TriStateButtonUI.iconRect.width = 0;
        TriStateButtonUI.iconRect.y = 0;
        TriStateButtonUI.iconRect.x = 0;
        TriStateButtonUI.textRect.height = 0;
        TriStateButtonUI.textRect.width = 0;
        TriStateButtonUI.textRect.y = 0;
        TriStateButtonUI.textRect.x = 0;
        Icon icon = abstractButton.getIcon();
        Icon icon2 = this.fDelegate instanceof BasicRadioButtonUI ? ((BasicRadioButtonUI)this.fDelegate).getDefaultIcon() : MAC_EMPTY_ICON;
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : icon2, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        return iconRect;
    }
}

