/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class MPopup {
    private Popup fPopup;
    private JWindow fWindow;
    private Rectangle fBounds;
    private static JWindow sReusableWindow;

    public static MPopup getPopup(Component component, Component component2, int n, int n2) {
        return new MPopup(component, component2, n, n2, false);
    }

    public static MPopup getResizablePopup(Component component, Component component2, int n, int n2) {
        return new MPopup(component, component2, n, n2, true);
    }

    private MPopup(Component component, Component component2, int n, int n2, boolean bl) {
        if (component2 == null) {
            throw new IllegalArgumentException("Contents must be non-null");
        }
        if (!bl) {
            this.fPopup = PopupFactory.getSharedInstance().getPopup(component, component2, n, n2);
        } else {
            Window window = SwingUtilities.windowForComponent(component);
            this.fWindow = MPopup.getWindow(window);
            this.fWindow.getContentPane().add(component2, "Center");
            this.fWindow.setLocation(n, n2);
            this.fWindow.setSize(component2.getPreferredSize());
        }
        this.fBounds = new Rectangle(new Point(n, n2), component2.getPreferredSize());
    }

    public void show() {
        if (this.fPopup != null) {
            this.fPopup.show();
        } else if (this.fWindow != null) {
            this.fWindow.setVisible(true);
        }
    }

    public void hide() {
        if (this.fPopup != null) {
            this.fPopup.hide();
            this.fPopup = null;
        } else if (this.fWindow != null) {
            this.fWindow.getContentPane().removeAll();
            this.fWindow.setVisible(false);
            MPopup.saveWindow(this.fWindow);
            this.fWindow = null;
        }
    }

    public void setName(String string) throws IllegalStateException {
        if (this.isUsingSwingPopup()) {
            throw new IllegalStateException("This method call is only valid for resizable MPopup");
        }
        this.fWindow.setName(string);
    }

    public void setSize(Dimension dimension) throws IllegalStateException {
        if (this.isUsingSwingPopup() || dimension.equals(this.fWindow.getLocation())) {
            throw new IllegalStateException("This method call is only valid for resizable MPopup");
        }
        this.fWindow.setSize(dimension);
        this.fWindow.invalidate();
        this.fWindow.validate();
        this.fWindow.repaint();
        this.fBounds = this.fWindow.getBounds();
    }

    public void setLocation(int n, int n2) throws IllegalStateException {
        if (this.isUsingSwingPopup()) {
            throw new IllegalStateException("This method call is only valid for resizable MPopup");
        }
        this.fWindow.setLocation(n, n2);
        this.fBounds = this.fWindow.getBounds();
    }

    public Point getLocation() throws IllegalStateException {
        if (!this.isUsingSwingPopup()) {
            return this.fWindow.getLocation();
        }
        throw new IllegalStateException("This method call is only valid for resizable MPopup");
    }

    public Rectangle getBounds() {
        return this.fBounds;
    }

    boolean isUsingSwingPopup() {
        return this.fPopup != null;
    }

    static synchronized JWindow getWindow(Window window) {
        JWindow jWindow = null;
        if (sReusableWindow != null) {
            if (window == sReusableWindow.getOwner()) {
                jWindow = sReusableWindow;
            } else {
                sReusableWindow.dispose();
            }
            sReusableWindow = null;
        }
        if (jWindow == null) {
            jWindow = new MJWindow(window);
            jWindow.setFocusableWindowState(false);
            jWindow.getContentPane().setLayout(new BorderLayout());
        }
        return jWindow;
    }

    static synchronized void saveWindow(JWindow jWindow) {
        sReusableWindow = jWindow;
    }
}

