/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ControlKeyInterceptor;
import com.mathworks.mwswing.ControlKeyOverride;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeySequenceDispatcher;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MKeyEventDispatcher
implements KeyEventDispatcher {
    private final KeySequenceDispatcher fSequenceDispatcher = KeySequenceDispatcher.getInstance();
    private Component fPressedComponent;
    private boolean fCtrlShift0PressReceived;

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (MKeyEventDispatcher.handleNonSwingAltKey(keyEvent)) {
            return true;
        }
        if (this.handleLinuxMenuMnemonicBug(keyEvent)) {
            return true;
        }
        if (MKeyEventDispatcher.handleControlKey(keyEvent)) {
            return true;
        }
        if (MKeyEventDispatcher.handleWindowsContextMenu(keyEvent)) {
            return true;
        }
        keyEvent = this.handleWindowsVistaKeyPressedBug(keyEvent);
        return this.fSequenceDispatcher.dispatchKeyEvent(keyEvent);
    }

    private static boolean handleNonSwingAltKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 18 && keyEvent.getComponent() != null && SwingUtilities.getRootPane(keyEvent.getComponent()) == null;
    }

    private KeyEvent handleWindowsVistaKeyPressedBug(KeyEvent keyEvent) {
        if (PlatformInfo.isWindowsVistaAndAbove() && keyEvent.getKeyCode() == 48 && (keyEvent.getModifiers() & 1) == 1 && (keyEvent.getModifiers() & 2) == 2) {
            if (keyEvent.getID() == 401) {
                this.fCtrlShift0PressReceived = true;
            } else if (keyEvent.getID() == 402) {
                if (this.fCtrlShift0PressReceived) {
                    this.fCtrlShift0PressReceived = false;
                } else {
                    return new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                }
            }
        }
        return keyEvent;
    }

    private static boolean handleWindowsContextMenu(KeyEvent keyEvent) {
        if (PlatformInfo.isWindows()) {
            if (keyEvent.getKeyCode() == 121 && (keyEvent.getModifiers() & 1) == 1) {
                if (keyEvent.getID() == 401 && keyEvent.getComponent() != null) {
                    MJUtilities.triggerContextMenu(keyEvent.getComponent(), keyEvent.getComponent(), keyEvent.getWhen());
                }
                keyEvent.consume();
                return true;
            }
            if (keyEvent.getKeyCode() == 525) {
                if (keyEvent.getID() == 402 && keyEvent.getComponent() != null) {
                    MJUtilities.triggerContextMenu(keyEvent.getComponent(), keyEvent.getComponent(), keyEvent.getWhen());
                }
                keyEvent.consume();
                return true;
            }
        }
        return false;
    }

    private boolean handleLinuxMenuMnemonicBug(KeyEvent keyEvent) {
        if (PlatformInfo.isLinux()) {
            if (keyEvent.getID() == 401) {
                if (keyEvent.getComponent() instanceof JRootPane) {
                    this.fPressedComponent = keyEvent.getComponent();
                }
            } else {
                if (keyEvent.getID() == 400 && this.fPressedComponent != null && !this.fPressedComponent.equals(keyEvent.getComponent())) {
                    return true;
                }
                this.fPressedComponent = null;
            }
        }
        return false;
    }

    private static boolean handleControlKey(KeyEvent keyEvent) {
        if ((keyEvent.getModifiers() & 2) != 0 && !MJUtilities.isModifierOnly(keyEvent.getKeyCode())) {
            if (PlatformInfo.isWindows() && keyEvent.getComponent() instanceof ControlKeyInterceptor) {
                ((ControlKeyInterceptor)((Object)keyEvent.getComponent())).processControlKey(keyEvent);
            }
            if (keyEvent.getComponent() instanceof JComponent) {
                for (Component component = keyEvent.getComponent(); component != null; component = component.getParent()) {
                    Action action;
                    InputMap inputMap;
                    Object object;
                    KeyStroke keyStroke;
                    if (!(component instanceof ControlKeyOverride) || !(component instanceof JComponent) || !((ControlKeyOverride)((Object)component)).wantKey(keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()), keyEvent.getComponent()) || (object = (inputMap = ((JComponent)component).getInputMap(1)).get(keyStroke)) == null || (action = ((JComponent)component).getActionMap().get(object)) == null || !action.isEnabled()) continue;
                    int n = keyEvent.getID();
                    if (n == 401) {
                        action.actionPerformed(new ActionEvent(component, n, object.toString()));
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

