/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.CellViewerCustomizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JTree;

public class DefaultTreeCellViewerCustomizer
implements CellViewerCustomizer<Integer> {
    private final JTree fTree;

    public DefaultTreeCellViewerCustomizer(JTree jTree) {
        this.fTree = jTree;
    }

    @Override
    public Component getCellPainter(Integer n) {
        Object object = this.fTree.getPathForRow(n).getLastPathComponent();
        return this.fTree.getCellRenderer().getTreeCellRendererComponent(this.fTree, object, this.fTree.isRowSelected(n), this.fTree.isExpanded(n), this.fTree.getModel().isLeaf(object), n, false);
    }

    @Override
    public Dimension getCellViewerOffset(Integer n) {
        return new Dimension(0, 0);
    }

    @Override
    public boolean shouldShowCellViewer(Integer n) {
        Rectangle rectangle = this.fTree.getVisibleRect();
        Rectangle rectangle2 = this.fTree.getRowBounds(n);
        Component component = this.getCellPainter(n);
        Dimension dimension = component.getPreferredSize();
        int n2 = component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 2;
        return CellViewer.shouldShow(rectangle, rectangle2, dimension, n2);
    }

    @Override
    public boolean constrainViewerToCellHeight() {
        return true;
    }
}

