/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader.pref;

import com.sun.jini.action.GetPropertyAction;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.loader.ClassAnnotation;
import net.jini.loader.pref.PreferredClassLoader;

public class PreferredClassProvider
extends RMIClassLoaderSpi {
    private boolean requireDlPerm = false;
    private static final Logger logger;
    private static String codebaseProperty;
    private static final Map localLoaders;
    private final HashMap loaderTable = new HashMap();
    private final ReferenceQueue refQueue = new ReferenceQueue();
    private final Map classLoaderPerms = new WeakHashMap();
    private static Map pathToURLsCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PreferredClassProvider() {
    }

    protected PreferredClassProvider(boolean bl) {
        this.requireDlPerm = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoader(ClassLoader classLoader, ClassLoader classLoader2, URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && classLoader != null && classLoader != classLoader2) {
            try {
                if (!$assertionsDisabled && !Arrays.equals(uRLArray, this.getLoaderAnnotationURLs(classLoader))) {
                    throw new AssertionError();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            if (classLoader.getClass() == PreferredClassLoader.class) {
                ((PreferredClassLoader)classLoader).checkPermissions();
            } else {
                Permissions permissions = null;
                Object object = this.classLoaderPerms;
                synchronized (object) {
                    permissions = (Permissions)this.classLoaderPerms.get(classLoader);
                    if (permissions == null) {
                        permissions = new Permissions();
                        PreferredClassLoader.addPermissionsForURLs(uRLArray, permissions, false);
                        this.classLoaderPerms.put(classLoader, permissions);
                    }
                }
                object = permissions.elements();
                while (object.hasMoreElements()) {
                    securityManager.checkPermission((Permission)object.nextElement());
                }
            }
        }
    }

    public Class loadClass(String string, String string2, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        Object object;
        ClassLoader classLoader2;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "name=\"{0}\", codebase={1}, defaultLoader={2}", new Object[]{string2, string != null ? "\"" + string + "\"" : null, classLoader});
        }
        Object[] objectArray = PreferredClassProvider.pathToURLs(string);
        if (classLoader != null) {
            try {
                if (objectArray == null || Arrays.equals(objectArray, this.getLoaderAnnotationURLs(classLoader))) {
                    try {
                        Class<?> clazz = Class.forName(string2, false, classLoader);
                        if (logger.isLoggable(Level.FINEST)) {
                            this.logDefaultLoader(string2, classLoader, clazz);
                        }
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classLoader = null;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        SecurityException securityException = null;
        boolean bl = false;
        ClassLoader classLoader3 = PreferredClassProvider.getRMIContextClassLoader();
        if (logger.isLoggable(Level.FINEST)) {
            this.logContextLoader(classLoader3, "loadClass");
        }
        if ((classLoader2 = this.lookupLoader((URL[])objectArray, classLoader3)) instanceof PreferredClassLoader) {
            object = PreferredClassProvider.stripArrayClassName(string2);
            try {
                this.checkLoader(classLoader2, classLoader3, (URL[])objectArray);
                bl = ((PreferredClassLoader)classLoader2).isPreferredResource((String)object, true);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("could not obtain preferred value for: " + (String)object, iOException);
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
        }
        try {
            if (classLoader != null && !bl) {
                object = Class.forName(string2, false, classLoader);
                if (logger.isLoggable(Level.FINEST)) {
                    this.logDefaultLoader(string2, classLoader, (Class)object);
                }
                return object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!(classLoader2 instanceof PreferredClassLoader)) {
            try {
                this.checkLoader(classLoader2, classLoader3, (URL[])objectArray);
            }
            catch (SecurityException securityException3) {
                securityException = securityException3;
            }
        }
        return (object = this.disabledUseParent(string2, classLoader3, securityException)) == null ? this.attemptChildLoad(string2, classLoader2) : object;
    }

    private static String stripArrayClassName(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == '['; ++n) {
        }
        if (n == 0 || n >= n2 - 2 || string.charAt(n) != 'L' || string.charAt(n2 - 1) != ';') {
            return string;
        }
        return string.substring(n + 1, n2 - 1);
    }

    Class disabledUseParent(String string, ClassLoader classLoader, SecurityException securityException) throws ClassNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null || securityException != null) {
            try {
                Class<?> clazz = Class.forName(string, false, classLoader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, this.getClass().getName(), "loadClass", "class \"{0}\" found via thread context class loader (access to codebase denied), defined by {1}", new Object[]{string, PreferredClassProvider.getClassLoader(clazz)});
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = classNotFoundException.getMessage() + " (no security manager: RMI class loader disabled";
                Exception exception = classNotFoundException;
                if (securityException != null) {
                    LogRecord logRecord;
                    if (logger.isLoggable(Levels.HANDLED)) {
                        logRecord = new LogRecord(Levels.HANDLED, "class \"{0}\" not found via thread context class loader (access to codebase denied)");
                        logRecord.setLoggerName(logger.getName());
                        logRecord.setSourceClassName(this.getClass().getName());
                        logRecord.setSourceMethodName("loadClass");
                        logRecord.setParameters(new Object[]{string});
                        logRecord.setThrown(exception);
                        logger.log(logRecord);
                    }
                    string2 = "access to class loader denied";
                    exception = securityException;
                    if (logger.isLoggable(Levels.FAILED)) {
                        logRecord = new LogRecord(Levels.FAILED, "class \"{0}\" not found via thread context class loader (access to codebase denied)");
                        logRecord.setLoggerName(logger.getName());
                        logRecord.setSourceClassName(this.getClass().getName());
                        logRecord.setSourceMethodName("loadClass");
                        logRecord.setParameters(new Object[]{string});
                        logRecord.setThrown(exception);
                        logger.log(logRecord);
                    }
                }
                throw new ClassNotFoundException(string2, exception);
            }
        }
        return null;
    }

    Class attemptChildLoad(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string, false, classLoader);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, this.getClass().getName(), "loadClass", "class \"{0}\" found via codebase, defined by {1}", new Object[]{string, PreferredClassProvider.getClassLoader(clazz)});
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Levels.FAILED)) {
                LogRecord logRecord = new LogRecord(Levels.FAILED, "class \"{0}\" not found via codebase");
                logRecord.setLoggerName(logger.getName());
                logRecord.setSourceClassName(this.getClass().getName());
                logRecord.setSourceMethodName("loadClass");
                logRecord.setParameters(new Object[]{string});
                logRecord.setThrown(classNotFoundException);
                logger.log(logRecord);
            }
            throw classNotFoundException;
        }
    }

    private void logDefaultLoader(String string, ClassLoader classLoader, Class clazz) {
        logger.logp(Level.FINEST, this.getClass().getName(), "loadClass", "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{string, PreferredClassProvider.getClassLoader(clazz)});
    }

    public String getClassAnnotation(Class clazz) {
        String string = clazz.getName();
        int n = string.length();
        if (n > 0 && string.charAt(0) == '[') {
            int n2;
            for (n2 = 1; n > n2 && string.charAt(n2) == '['; ++n2) {
            }
            if (n > n2 && string.charAt(n2) != 'L') {
                return null;
            }
        }
        return this.getLoaderAnnotation(PreferredClassProvider.getClassLoader(clazz));
    }

    protected String getClassAnnotation(ClassLoader classLoader) {
        return codebaseProperty;
    }

    private String getLoaderAnnotation(ClassLoader classLoader) {
        if (PreferredClassProvider.isLocalLoader(classLoader)) {
            return this.getClassAnnotation(classLoader);
        }
        String string = null;
        if (classLoader instanceof ClassAnnotation) {
            string = ((ClassAnnotation)((Object)classLoader)).getClassAnnotation();
        } else if (classLoader instanceof URLClassLoader) {
            try {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                if (uRLArray != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        for (int i = 0; i < uRLArray.length; ++i) {
                            Permission permission = uRLArray[i].openConnection().getPermission();
                            if (permission == null) continue;
                            securityManager.checkPermission(permission);
                        }
                    }
                    string = PreferredClassLoader.urlsToPath(uRLArray);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string != null) {
            return string;
        }
        return this.getClassAnnotation(classLoader);
    }

    private static boolean isLocalLoader(ClassLoader classLoader) {
        return classLoader == null || localLoaders.containsKey(classLoader);
    }

    public ClassLoader getClassLoader(String string) throws MalformedURLException {
        ClassLoader classLoader = PreferredClassProvider.getRMIContextClassLoader();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return classLoader;
        }
        securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        URL[] uRLArray = PreferredClassProvider.pathToURLs(string);
        ClassLoader classLoader2 = this.lookupLoader(uRLArray, classLoader);
        this.checkLoader(classLoader2, classLoader, uRLArray);
        return classLoader2;
    }

    public Class loadProxyClass(String string, String[] stringArray, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        SecurityManager securityManager;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "interfaces={0}, codebase={1}, defaultLoader={2}", new Object[]{Arrays.asList(stringArray), string != null ? "\"" + string + "\"" : null, classLoader});
        }
        ClassLoader classLoader2 = PreferredClassProvider.getRMIContextClassLoader();
        if (logger.isLoggable(Level.FINEST)) {
            this.logContextLoader(classLoader2, "loadProxyClass");
        }
        if ((securityManager = System.getSecurityManager()) == null) {
            try {
                Class clazz = this.loadProxyClass(stringArray, classLoader, classLoader2, false);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "(no security manager: codebase disabled) proxy class defined by {0}", PreferredClassProvider.getClassLoader(clazz));
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "(no security manager: codebase disabled) proxy class resolution failed", classNotFoundException);
                }
                throw new ClassNotFoundException(classNotFoundException.getMessage() + " (no security manager: RMI class loader disabled)", classNotFoundException.getException());
            }
        }
        URL[] uRLArray = PreferredClassProvider.pathToURLs(string);
        ClassLoader classLoader3 = this.lookupLoader(uRLArray, classLoader2);
        try {
            this.checkLoader(classLoader3, classLoader2, uRLArray);
        }
        catch (SecurityException securityException) {
            try {
                Class clazz = this.loadProxyClass(stringArray, classLoader, classLoader2, false);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "(access to codebase denied) proxy class defined by {0}", PreferredClassProvider.getClassLoader(clazz));
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "(access to codebase denied) proxy class resolution failed", classNotFoundException);
                }
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "(access to codebase denied) proxy class resolution failed", securityException);
                }
                throw new ClassNotFoundException("access to class loader denied", securityException);
            }
        }
        try {
            Class clazz = this.loadProxyClass(stringArray, classLoader, classLoader3, true);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "proxy class defined by {0}", PreferredClassProvider.getClassLoader(clazz));
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "proxy class resolution failed", classNotFoundException);
            }
            throw classNotFoundException;
        }
    }

    private Class loadProxyClass(String[] stringArray, ClassLoader classLoader, ClassLoader classLoader2, boolean bl) throws MalformedURLException, ClassNotFoundException {
        boolean[] blArray;
        Class[] classArray;
        ClassLoader classLoader3;
        block13: {
            classLoader3 = null;
            classArray = new Class[stringArray.length];
            blArray = new boolean[]{false};
            Boolean[] booleanArray = new Boolean[1];
            if (classLoader != null && classLoader2 instanceof PreferredClassLoader && !this.annotationsMatch(booleanArray, classLoader, classLoader2) && this.interfacePreferred((PreferredClassLoader)classLoader2, stringArray)) {
                classLoader = null;
            }
            if (classLoader != null) {
                block12: {
                    try {
                        classLoader3 = this.loadProxyInterfaces(stringArray, classLoader, classArray, blArray);
                        if (!logger.isLoggable(Level.FINEST)) break block12;
                        ClassLoader[] classLoaderArray = new ClassLoader[classArray.length];
                        for (int i = 0; i < classLoaderArray.length; ++i) {
                            classLoaderArray[i] = PreferredClassProvider.getClassLoader(classArray[i]);
                        }
                        logger.log(Level.FINEST, "proxy interfaces found via defaultLoader, defined by {0}", Arrays.asList(classLoaderArray));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break block13;
                    }
                }
                if (!blArray[0]) {
                    if (bl && !this.annotationsMatch(booleanArray, classLoader, classLoader2)) {
                        try {
                            return Proxy.getProxyClass(classLoader2, classArray);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    classLoader3 = classLoader;
                }
                return PreferredClassProvider.loadProxyClass(classLoader3, classArray);
            }
        }
        blArray[0] = false;
        classLoader3 = this.loadProxyInterfaces(stringArray, classLoader2, classArray, blArray);
        if (logger.isLoggable(Level.FINEST)) {
            ClassLoader[] classLoaderArray = new ClassLoader[classArray.length];
            for (int i = 0; i < classLoaderArray.length; ++i) {
                classLoaderArray[i] = PreferredClassProvider.getClassLoader(classArray[i]);
            }
            logger.log(Level.FINEST, "proxy interfaces found via codebase, defined by {0}", Arrays.asList(classLoaderArray));
        }
        if (!blArray[0]) {
            classLoader3 = classLoader2;
        }
        return PreferredClassProvider.loadProxyClass(classLoader3, classArray);
    }

    private boolean annotationsMatch(Boolean[] booleanArray, ClassLoader classLoader, ClassLoader classLoader2) {
        if (booleanArray[0] == null) {
            try {
                Object[] objectArray = this.getLoaderAnnotationURLs(classLoader);
                Object[] objectArray2 = this.getLoaderAnnotationURLs(classLoader2);
                booleanArray[0] = Arrays.equals(objectArray, objectArray2);
            }
            catch (MalformedURLException malformedURLException) {
                booleanArray[0] = Boolean.FALSE;
            }
        }
        return booleanArray[0];
    }

    private boolean interfacePreferred(PreferredClassLoader preferredClassLoader, String[] stringArray) throws ClassNotFoundException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (!preferredClassLoader.isPreferredResource(stringArray[i], true)) continue;
                bl = true;
                break;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException("could not obtain preferred value for: " + stringArray[i], iOException);
            }
        }
        return bl;
    }

    private static Class loadProxyClass(ClassLoader classLoader, Class[] classArray) throws ClassNotFoundException {
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException("error creating dynamic proxy class", illegalArgumentException);
        }
    }

    URL[] getLoaderAnnotationURLs(ClassLoader classLoader) throws MalformedURLException {
        return PreferredClassProvider.pathToURLs(this.getLoaderAnnotation(classLoader));
    }

    private ClassLoader loadProxyInterfaces(String[] stringArray, ClassLoader classLoader, Class[] classArray, boolean[] blArray) throws ClassNotFoundException {
        ClassLoader classLoader2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i], false, classLoader);
            Class<?> clazz = classArray[i];
            if (Modifier.isPublic(clazz.getModifiers())) continue;
            ClassLoader classLoader3 = PreferredClassProvider.getClassLoader(clazz);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, this.getClass().getName(), "loadProxyClass", "non-public interface \"{0}\" defined by {1}", new Object[]{stringArray[i], classLoader3});
            }
            if (!blArray[0]) {
                classLoader2 = classLoader3;
                blArray[0] = true;
                continue;
            }
            if (classLoader3 == classLoader2) continue;
            throw new IllegalAccessError("non-public interfaces defined in different class loaders");
        }
        return classLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String string) throws MalformedURLException {
        Object[] objectArray;
        if (string == null) {
            return null;
        }
        Object object = pathToURLsCache;
        synchronized (object) {
            objectArray = (Object[])pathToURLsCache.get(string);
            if (objectArray != null) {
                return (URL[])objectArray[0];
            }
        }
        object = new StringTokenizer(string);
        objectArray = new URL[((StringTokenizer)object).countTokens()];
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            objectArray[n] = new URL(((StringTokenizer)object).nextToken());
            ++n;
        }
        Map map = pathToURLsCache;
        synchronized (map) {
            pathToURLsCache.put(string, new Object[]{objectArray, new SoftReference<String>(string)});
        }
        return objectArray;
    }

    private static ClassLoader getRMIContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    void logContextLoader(ClassLoader classLoader, String string) {
        logger.logp(Level.FINEST, this.getClass().getName(), string, "(thread context class loader: {0})", classLoader);
    }

    private ClassLoader findOriginLoader(final URL[] uRLArray, final ClassLoader classLoader) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PreferredClassProvider.this.findOriginLoader0(uRLArray, classLoader);
            }
        });
    }

    private ClassLoader findOriginLoader0(URL[] uRLArray, ClassLoader classLoader) {
        for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            Object[] objectArray;
            try {
                objectArray = this.getLoaderAnnotationURLs(classLoader2);
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            if (!Arrays.equals(uRLArray, objectArray)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "using an existing ancestor class loader which serves the requested codebase urls: {0}, urls: {1}", new Object[]{classLoader2, objectArray != null ? Arrays.asList(objectArray) : null});
            }
            return classLoader2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader lookupLoader(final URL[] uRLArray, final ClassLoader classLoader) {
        if (uRLArray == null) {
            return classLoader;
        }
        ClassLoader classLoader2 = null;
        HashMap hashMap = this.loaderTable;
        synchronized (hashMap) {
            LoaderEntry loaderEntry;
            while ((loaderEntry = (LoaderEntry)this.refQueue.poll()) != null) {
                if (loaderEntry.removed) continue;
                this.loaderTable.remove(loaderEntry.key);
            }
            LoaderKey loaderKey = new LoaderKey(uRLArray, classLoader);
            loaderEntry = (LoaderEntry)this.loaderTable.get(loaderKey);
            if (loaderEntry == null || (classLoader2 = (ClassLoader)loaderEntry.get()) == null) {
                if (loaderEntry != null) {
                    this.loaderTable.remove(loaderKey);
                    loaderEntry.removed = true;
                }
                if ((classLoader2 = this.findOriginLoader(uRLArray, classLoader)) == null) {
                    AccessControlContext accessControlContext = PreferredClassLoader.getLoaderAccessControlContext(uRLArray);
                    classLoader2 = (PreferredClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new PreferredClassLoader(uRLArray, classLoader, null, PreferredClassProvider.this.requireDlPerm, false);
                        }
                    }, accessControlContext);
                }
                loaderEntry = new LoaderEntry(loaderKey, classLoader2);
                this.loaderTable.put(loaderKey, loaderEntry);
            }
        }
        return classLoader2;
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    static {
        $assertionsDisabled = !PreferredClassProvider.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.loader.pref.PreferredClassProvider");
        codebaseProperty = null;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.codebase"));
        if (string != null && string.trim().length() > 0) {
            codebaseProperty = string;
        }
        localLoaders = Collections.synchronizedMap(new WeakHashMap());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (ClassLoader classLoader = ClassLoader.getSystemClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                    localLoaders.put(classLoader, null);
                }
                return null;
            }
        });
        pathToURLsCache = new WeakHashMap(5);
    }

    private class LoaderEntry
    extends WeakReference {
        public final LoaderKey key;
        public boolean removed;

        public LoaderEntry(LoaderKey loaderKey, ClassLoader classLoader) {
            super(classLoader, PreferredClassProvider.this.refQueue);
            this.removed = false;
            this.key = loaderKey;
        }
    }

    private static class LoaderKey {
        private URL[] urls;
        private ClassLoader parent;
        private int hashValue;

        public LoaderKey(URL[] uRLArray, ClassLoader classLoader) {
            this.urls = uRLArray;
            this.parent = classLoader;
            if (classLoader != null) {
                this.hashValue = classLoader.hashCode();
            }
            for (int i = 0; i < uRLArray.length; ++i) {
                this.hashValue ^= uRLArray[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object object) {
            if (object instanceof LoaderKey) {
                LoaderKey loaderKey = (LoaderKey)object;
                if (this.parent != loaderKey.parent) {
                    return false;
                }
                return Arrays.equals(this.urls, loaderKey.urls);
            }
            return false;
        }
    }
}

