/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationID;
import java.rmi.server.ServerNotActiveException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;
import net.jini.io.context.ClientSubject;
import net.jini.io.context.ContextPermission;
import net.jini.io.context.IntegrityEnforcement;
import net.jini.security.proxytrust.TrustEquivalence;

public class Util {
    private static TableCache methodToHash_TableCache = new TableCache(true);
    private static Class[] paramTypes = new Class[]{ActivationID.class, MarshalledObject.class};
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$rmi$Remote;

    public static void exceptionReceivedFromServer(Throwable throwable) {
        Util.__________EXCEPTION_RECEIVED_FROM_SERVER__________(throwable);
    }

    private static void __________EXCEPTION_RECEIVED_FROM_SERVER__________(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new Throwable().getStackTrace();
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
        throwable.setStackTrace(stackTraceElementArray3);
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void marshalValue(Class clazz, Object object, ObjectOutput objectOutput) throws IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                objectOutput.writeInt((Integer)object);
                return;
            } else if (clazz == Boolean.TYPE) {
                objectOutput.writeBoolean((Boolean)object);
                return;
            } else if (clazz == Byte.TYPE) {
                objectOutput.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                objectOutput.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Short.TYPE) {
                objectOutput.writeShort(((Short)object).shortValue());
                return;
            } else if (clazz == Long.TYPE) {
                objectOutput.writeLong((Long)object);
                return;
            } else if (clazz == Float.TYPE) {
                objectOutput.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (clazz != Double.TYPE) throw new AssertionError((Object)("Unrecognized primitive type: " + clazz));
                objectOutput.writeDouble((Double)object);
            }
            return;
        } else {
            objectOutput.writeObject(object);
        }
    }

    public static Object unmarshalValue(Class clazz, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return new Integer(objectInput.readInt());
            }
            if (clazz == Boolean.TYPE) {
                return new Boolean(objectInput.readBoolean());
            }
            if (clazz == Byte.TYPE) {
                return new Byte(objectInput.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(objectInput.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(objectInput.readShort());
            }
            if (clazz == Long.TYPE) {
                return new Long(objectInput.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(objectInput.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(objectInput.readDouble());
            }
            throw new AssertionError((Object)("Unrecognized primitive type: " + clazz));
        }
        return objectInput.readObject();
    }

    private static long computeMethodHash(Method method) {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            String string = Util.getMethodNameAndDescriptor(method);
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    public static long getMethodHash(Method method) {
        Map map = methodToHash_TableCache.getTable(method.getDeclaringClass());
        Long l = (Long)map.get(method);
        return l;
    }

    private static void checkMethod(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(class$java$rmi$RemoteException == null ? Util.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) continue;
            return;
        }
        throw new IllegalArgumentException("illegal remote method encountered: " + method);
    }

    public static String getMethodNameAndDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Util.getTypeDescriptor(classArray[i]));
        }
        stringBuffer.append(')');
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append(Util.getTypeDescriptor(clazz));
        }
        return stringBuffer.toString();
    }

    private static String getTypeDescriptor(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static Class[] getRemoteInterfaces(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Util.getRemoteInterfaces(arrayList, clazz);
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static void getRemoteInterfaces(ArrayList arrayList, Class clazz) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Util.getRemoteInterfaces(arrayList, clazz2);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz3;
            if (!(class$java$rmi$Remote == null ? Util.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(clazz3 = classArray[i]) || arrayList.contains(clazz3)) continue;
            Method[] methodArray = clazz3.getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Util.checkMethod(methodArray[j]);
            }
            arrayList.add(clazz3);
        }
    }

    public static String getUnqualifiedName(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static boolean sameClassAndEquals(Object object, Object object2) {
        return object == null ? object2 == null : object2 != null && object.getClass() == object2.getClass() && object.equals(object2);
    }

    public static boolean checkTrustEquivalence(Object object, Object object2) {
        return object == null ? object2 == null : object instanceof TrustEquivalence && ((TrustEquivalence)object).checkTrustEquivalence(object2);
    }

    public static boolean sameProxyClass(Object object, Object object2) {
        return object.getClass() == object2.getClass() || Proxy.isProxyClass(object2.getClass()) && Util.equalInterfaces(object, object2);
    }

    public static boolean equalInterfaces(Object object, Object object2) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = object.getClass().getInterfaces();
        if (classArray2.length != (classArray = object2.getClass().getInterfaces()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return true;
    }

    public static void populateContext(Collection collection, InetAddress inetAddress) {
        if (collection == null) {
            throw new NullPointerException("context is null");
        }
        if (inetAddress != null) {
            collection.add(new ClientHostImpl(inetAddress));
        }
    }

    public static void populateContext(Collection collection, Subject subject) {
        if (collection == null) {
            throw new NullPointerException("context is null");
        }
        collection.add(new ClientSubjectImpl(subject));
    }

    public static void populateContext(Collection collection, boolean bl) {
        if (collection == null) {
            throw new NullPointerException("context is null");
        }
        collection.add(new IntegrityEnforcementImpl(bl));
    }

    public static InetAddress getClientHost() throws ServerNotActiveException {
        ClientHost clientHost = (ClientHost)ServerContext.getServerContextElement(ClientHost.class);
        return clientHost != null ? clientHost.getClientHost() : null;
    }

    public static String getClientHostString() throws ServerNotActiveException {
        InetAddress inetAddress = Util.getClientHost();
        return inetAddress != null ? inetAddress.toString() : null;
    }

    public static Subject getClientSubject() throws ServerNotActiveException {
        ClientSubject clientSubject = (ClientSubject)ServerContext.getServerContextElement(ClientSubject.class);
        return clientSubject != null ? clientSubject.getClientSubject() : null;
    }

    public static void checkPackageAccess(Class clazz) {
        String string;
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
    }

    private static class IntegrityEnforcementImpl
    implements IntegrityEnforcement {
        private final boolean integrity;

        public IntegrityEnforcementImpl(boolean bl) {
            this.integrity = bl;
        }

        public boolean integrityEnforced() {
            return this.integrity;
        }
    }

    private static class ClientSubjectImpl
    implements ClientSubject {
        private final Subject s;
        private static final Permission getClientSubjectPerm = new ContextPermission("net.jini.io.context.ClientSubject.getClientSubject");

        public ClientSubjectImpl(Subject subject) {
            this.s = subject;
        }

        public Subject getClientSubject() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(getClientSubjectPerm);
            }
            return this.s;
        }
    }

    private static class ClientHostImpl
    implements ClientHost {
        private final InetAddress addr;

        public ClientHostImpl(InetAddress inetAddress) {
            this.addr = inetAddress;
        }

        public InetAddress getClientHost() {
            return this.addr;
        }
    }

    private static class LazyMethodToHash_Map
    extends WeakHashMap {
        public synchronized Object get(Object object) {
            Object object2 = super.get(object);
            if (object2 == null) {
                Method method = (Method)object;
                object2 = new Long(Util.computeMethodHash(method));
                this.put(method, object2);
            }
            return (Long)object2;
        }
    }

    private static class TableCache
    extends WeakHashMap {
        private boolean mapsMethodToHash;

        public TableCache(boolean bl) {
            this.mapsMethodToHash = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getTable(Class clazz) {
            SoftReference[] softReferenceArray = this;
            synchronized (this) {
                SoftReference[] softReferenceArray2 = (SoftReference[])this.get(clazz);
                if (softReferenceArray2 == null) {
                    softReferenceArray2 = new SoftReference[]{null};
                    this.put(clazz, softReferenceArray2);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                softReferenceArray = softReferenceArray2;
                synchronized (softReferenceArray2) {
                    Map map = null;
                    if (softReferenceArray2[0] != null) {
                        map = (Map)softReferenceArray2[0].get();
                    }
                    if (map == null) {
                        if (!this.mapsMethodToHash) {
                            throw new UnsupportedOperationException();
                        }
                        map = new LazyMethodToHash_Map();
                        softReferenceArray2[0] = new SoftReference<Map>(map);
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return map;
                }
            }
        }
    }
}

