/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.thread.NewThreadAction;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbstractDgcClient {
    private static final long leaseValue = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.dgc.leaseValue", 600000L));
    private static final long cleanInterval = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.dgc.cleanInterval", 180000L));
    private static final long minimumDuration = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.dgc.minimumDuration", 5000L));
    private static final int dirtyFailureRetries = 5;
    private static final int cleanConnectRetries = 3;
    private static final Object[] emptyObjectArray = new Object[0];
    private static long nextSequenceNum = Long.MIN_VALUE;
    private final Map endpointTable = new HashMap(5);
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient;

    protected AbstractDgcClient() {
    }

    protected abstract DgcProxy getDgcProxy(Object var1);

    protected abstract void freeEndpoint(Object var1);

    protected abstract Object getRefEndpoint(Object var1);

    protected abstract Object getRefObjectID(Object var1);

    protected final void registerRefs(Object object, Collection collection) {
        EndpointEntry endpointEntry;
        while (!(endpointEntry = this.getEndpointEntry(object)).registerRefs(collection)) {
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static long computeRenewTime(long l, long l2) {
        return l + l2 / 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointEntry getEndpointEntry(Object object) {
        Map map = this.endpointTable;
        synchronized (map) {
            EndpointEntry endpointEntry = (EndpointEntry)this.endpointTable.get(object);
            if (endpointEntry == null) {
                endpointEntry = new EndpointEntry(object);
                this.endpointTable.put(object, endpointEntry);
            }
            return endpointEntry;
        }
    }

    private static class CleanRequest {
        long sequenceNum;
        Object[] objectIDs;
        boolean strong;
        int connectFailures = 0;

        CleanRequest(long l, Object[] objectArray, boolean bl) {
            this.sequenceNum = l;
            this.objectIDs = objectArray;
            this.strong = bl;
        }
    }

    private final class EndpointEntry {
        private final Object endpoint;
        private final DgcProxy dgcProxy;
        private final Thread renewCleanThread;
        private final ReferenceQueue refQueue = new ReferenceQueue();
        private boolean removed = false;
        private final Map refTable = new HashMap(5);
        private Set invalidRefs = new HashSet(5);
        private long renewTime = Long.MAX_VALUE;
        private long expirationTime = Long.MIN_VALUE;
        private int dirtyFailures = 0;
        private long dirtyFailureStartTime;
        private long dirtyFailureDuration;
        private boolean interruptible = false;
        private final Set pendingCleans = new HashSet(5);
        static final /* synthetic */ boolean $assertionsDisabled;

        private EndpointEntry(Object object) {
            this.endpoint = object;
            this.dgcProxy = AbstractDgcClient.this.getDgcProxy(object);
            this.renewCleanThread = (Thread)AccessController.doPrivileged(new NewThreadAction(new RenewCleanThread(), "RenewClean-" + object, true));
            this.renewCleanThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean registerRefs(Collection collection) {
            long l;
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            HashSet<RefEntry> hashSet = null;
            EndpointEntry endpointEntry = this;
            synchronized (endpointEntry) {
                if (this.removed) {
                    return false;
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!$assertionsDisabled && !AbstractDgcClient.this.getRefEndpoint(e).equals(this.endpoint)) {
                        throw new AssertionError();
                    }
                    Object object = AbstractDgcClient.this.getRefObjectID(e);
                    RefEntry refEntry = (RefEntry)this.refTable.get(object);
                    if (refEntry == null) {
                        refEntry = new RefEntry(object);
                        this.refTable.put(object, refEntry);
                        if (hashSet == null) {
                            hashSet = new HashSet<RefEntry>(5);
                        }
                        hashSet.add(refEntry);
                    }
                    refEntry.addInstanceToRefSet(e);
                }
                if (hashSet == null) {
                    return true;
                }
                hashSet.addAll(this.invalidRefs);
                this.invalidRefs.clear();
                l = AbstractDgcClient.getNextSequenceNum();
            }
            this.makeDirtyCall(hashSet, l);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRefEntry(RefEntry refEntry) {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.removed) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.refTable.containsKey(refEntry.getObjectID())) {
                throw new AssertionError();
            }
            this.refTable.remove(refEntry.getObjectID());
            this.invalidRefs.remove(refEntry);
            if (this.refTable.isEmpty()) {
                Map map = AbstractDgcClient.this.endpointTable;
                synchronized (map) {
                    AbstractDgcClient.this.endpointTable.remove(this.endpoint);
                    AbstractDgcClient.this.freeEndpoint(this.endpoint);
                }
                this.removed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeDirtyCall(Set set, long l) {
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            Object[] objectArray = set != null ? this.createObjectIDArray(set) : emptyObjectArray;
            long l2 = System.currentTimeMillis();
            try {
                long l3 = this.dgcProxy.dirty(l, objectArray, leaseValue);
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.dirtyFailures = 0;
                    if (l3 < 0L) {
                        this.setRenewTime(Long.MAX_VALUE);
                    } else {
                        this.setRenewTime(AbstractDgcClient.computeRenewTime(l2, Math.max(l3, minimumDuration)));
                        this.expirationTime = l2 + l3;
                    }
                }
            }
            catch (Exception exception) {
                long l4 = System.currentTimeMillis();
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    ++this.dirtyFailures;
                    if (this.dirtyFailures == 1) {
                        this.dirtyFailureStartTime = l2;
                        this.dirtyFailureDuration = l4 - l2;
                        this.setRenewTime(l4);
                    } else {
                        long l5;
                        int n = this.dirtyFailures - 2;
                        if (n == 0) {
                            this.dirtyFailureDuration = this.dirtyFailureDuration + (l4 - l2) >> 1;
                        }
                        if ((l5 = l4 + (this.dirtyFailureDuration << n)) < this.expirationTime || this.dirtyFailures < 5 || l5 < this.dirtyFailureStartTime + leaseValue) {
                            this.setRenewTime(l5);
                        } else {
                            this.setRenewTime(Long.MAX_VALUE);
                        }
                    }
                    if (set != null) {
                        this.invalidRefs.addAll(set);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            RefEntry refEntry = (RefEntry)iterator.next();
                            refEntry.markDirtyFailed();
                        }
                    }
                    if (this.renewTime >= this.expirationTime) {
                        this.invalidRefs.addAll(this.refTable.values());
                    }
                }
            }
        }

        private void setRenewTime(long l) {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            if (l < this.renewTime) {
                this.renewTime = l;
                if (this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            EndpointEntry.this.renewCleanThread.interrupt();
                            return null;
                        }
                    });
                }
            } else {
                this.renewTime = l;
            }
        }

        private void processPhantomRefs(RefEntry.PhantomLiveRef phantomLiveRef) {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            HashSet<RefEntry> hashSet = null;
            HashSet<RefEntry> hashSet2 = null;
            do {
                RefEntry refEntry = phantomLiveRef.getRefEntry();
                refEntry.removeInstanceFromRefSet(phantomLiveRef);
                if (!refEntry.isRefSetEmpty()) continue;
                if (refEntry.hasDirtyFailed()) {
                    if (hashSet == null) {
                        hashSet = new HashSet<RefEntry>(5);
                    }
                    hashSet.add(refEntry);
                } else {
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<RefEntry>(5);
                    }
                    hashSet2.add(refEntry);
                }
                this.removeRefEntry(refEntry);
            } while ((phantomLiveRef = (RefEntry.PhantomLiveRef)this.refQueue.poll()) != null);
            if (hashSet != null) {
                this.pendingCleans.add(new CleanRequest(AbstractDgcClient.getNextSequenceNum(), this.createObjectIDArray(hashSet), true));
            }
            if (hashSet2 != null) {
                this.pendingCleans.add(new CleanRequest(AbstractDgcClient.getNextSequenceNum(), this.createObjectIDArray(hashSet2), false));
            }
        }

        private void makeCleanCalls() {
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            Iterator iterator = this.pendingCleans.iterator();
            while (iterator.hasNext()) {
                CleanRequest cleanRequest = (CleanRequest)iterator.next();
                try {
                    this.dgcProxy.clean(cleanRequest.sequenceNum, cleanRequest.objectIDs, cleanRequest.strong);
                    iterator.remove();
                }
                catch (Exception exception) {
                    if (!(exception instanceof ConnectException) && !(exception instanceof ConnectIOException) || ++cleanRequest.connectFailures < 3) continue;
                    iterator.remove();
                }
            }
        }

        private Object[] createObjectIDArray(Set set) {
            Object[] objectArray = new Object[set.size()];
            Iterator iterator = set.iterator();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ((RefEntry)iterator.next()).getObjectID();
            }
            return objectArray;
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient == null ? (class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient = AbstractDgcClient.class$("com.sun.jini.jeri.internal.runtime.AbstractDgcClient")) : class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient).desiredAssertionStatus();
        }

        private class RefEntry {
            private final Object objectID;
            private final Set refSet = new HashSet(5);
            private boolean dirtyFailed = false;
            static final /* synthetic */ boolean $assertionsDisabled;

            RefEntry(Object object) {
                this.objectID = object;
            }

            Object getObjectID() {
                return this.objectID;
            }

            void addInstanceToRefSet(Object object) {
                if (!$assertionsDisabled && !Thread.holdsLock(EndpointEntry.this)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !AbstractDgcClient.this.getRefObjectID(object).equals(this.objectID)) {
                    throw new AssertionError();
                }
                this.refSet.add(new PhantomLiveRef(object));
            }

            void removeInstanceFromRefSet(PhantomLiveRef phantomLiveRef) {
                if (!$assertionsDisabled && !Thread.holdsLock(EndpointEntry.this)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.refSet.contains(phantomLiveRef)) {
                    throw new AssertionError();
                }
                this.refSet.remove(phantomLiveRef);
            }

            boolean isRefSetEmpty() {
                if (!$assertionsDisabled && !Thread.holdsLock(EndpointEntry.this)) {
                    throw new AssertionError();
                }
                return this.refSet.size() == 0;
            }

            void markDirtyFailed() {
                if (!$assertionsDisabled && !Thread.holdsLock(EndpointEntry.this)) {
                    throw new AssertionError();
                }
                this.dirtyFailed = true;
            }

            boolean hasDirtyFailed() {
                if (!$assertionsDisabled && !Thread.holdsLock(EndpointEntry.this)) {
                    throw new AssertionError();
                }
                return this.dirtyFailed;
            }

            static {
                $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient == null ? (class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient = AbstractDgcClient.class$("com.sun.jini.jeri.internal.runtime.AbstractDgcClient")) : class$com$sun$jini$jeri$internal$runtime$AbstractDgcClient).desiredAssertionStatus();
            }

            class PhantomLiveRef
            extends PhantomReference {
                PhantomLiveRef(Object object) {
                    super(object, EndpointEntry.this.refQueue);
                }

                RefEntry getRefEntry() {
                    return RefEntry.this;
                }
            }
        }

        private class RenewCleanThread
        implements Runnable {
            private RenewCleanThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                do {
                    long l;
                    long l2;
                    RefEntry.PhantomLiveRef phantomLiveRef = null;
                    boolean bl = false;
                    Set set = null;
                    long l3 = Long.MIN_VALUE;
                    EndpointEntry endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        l2 = EndpointEntry.this.renewTime - System.currentTimeMillis();
                        l = Math.max(l2, 1L);
                        if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                            l = Math.min(l, cleanInterval);
                        }
                        EndpointEntry.this.interruptible = true;
                    }
                    try {
                        phantomLiveRef = (RefEntry.PhantomLiveRef)EndpointEntry.this.refQueue.remove(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        EndpointEntry.this.interruptible = false;
                        Thread.interrupted();
                        if (phantomLiveRef != null) {
                            EndpointEntry.this.processPhantomRefs(phantomLiveRef);
                        }
                        if ((l2 = System.currentTimeMillis()) > EndpointEntry.this.renewTime) {
                            bl = true;
                            if (l2 >= EndpointEntry.this.expirationTime) {
                                EndpointEntry.this.invalidRefs.addAll(EndpointEntry.this.refTable.values());
                            }
                            if (!EndpointEntry.this.invalidRefs.isEmpty()) {
                                set = EndpointEntry.this.invalidRefs;
                                EndpointEntry.this.invalidRefs = new HashSet(5);
                            }
                            l3 = AbstractDgcClient.getNextSequenceNum();
                        }
                    }
                    if (bl) {
                        EndpointEntry.this.makeDirtyCall(set, l3);
                    }
                    if (EndpointEntry.this.pendingCleans.isEmpty()) continue;
                    EndpointEntry.this.makeCleanCalls();
                } while (!EndpointEntry.this.removed || !EndpointEntry.this.pendingCleans.isEmpty());
            }
        }
    }

    protected static interface DgcProxy {
        public long dirty(long var1, Object[] var3, long var4) throws RemoteException;

        public void clean(long var1, Object[] var3, boolean var4) throws RemoteException;
    }
}

