/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.Collection;
import net.jini.jeri.OutboundRequest;

public class MuxClient
extends Mux {
    private static final int clientInitialInboundRation = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.connection.mux.client.initialInboundRation", 32768));

    public MuxClient(OutputStream outputStream, InputStream inputStream) throws IOException {
        super(outputStream, inputStream, 0, clientInitialInboundRation, 1024);
    }

    public MuxClient(SocketChannel socketChannel) throws IOException {
        super(socketChannel, 0, clientInitialInboundRation, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundRequest newRequest() throws IOException {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                throw new IOException(this.muxDownMessage);
            }
            int n = this.busySessions.nextClearBit(0);
            if (n > 127) {
                throw new IOException("no free sessions");
            }
            Session session = new Session(this, n, 0);
            this.addSession(n, session);
            return session.getOutboundRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestsInProgress() throws IOException {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                throw new IOException(this.muxDownMessage);
            }
            return this.busySessions.cardinality();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String string) {
        Object object = this.muxLock;
        synchronized (object) {
            this.setDown(string, null);
        }
    }

    protected void populateContext(Collection collection) {
    }
}

