/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.ConnectionIO;
import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.mux.Session;
import com.sun.jini.jeri.internal.mux.SocketChannelConnectionIO;
import com.sun.jini.jeri.internal.mux.StreamConnectionIO;
import com.sun.jini.jeri.internal.runtime.HexDumpEncoder;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class Mux {
    static final int CLIENT = 0;
    static final int SERVER = 1;
    static final int MAX_SESSION_ID = 127;
    public static final int MAX_REQUESTS = 128;
    static final int NoOperation = 0;
    static final int Shutdown = 2;
    static final int Ping = 4;
    static final int PingAck = 6;
    static final int Error = 8;
    static final int IncrementRation = 16;
    static final int Abort = 32;
    static final int Close = 48;
    static final int Acknowledgment = 64;
    static final int Data = 128;
    static final int IncrementRation_shift = 14;
    static final int Abort_partial = 2;
    static final int Data_open = 16;
    static final int Data_close = 8;
    static final int Data_eof = 4;
    static final int Data_ackRequired = 2;
    static final int ClientConnectionHeader_negotiate = 1;
    private static final byte[] magic;
    private static final int VERSION = 1;
    private static final Executor systemThreadPool;
    private static final Logger logger;
    final int role;
    final int initialInboundRation;
    final int maxFragmentSize;
    private final ConnectionIO connectionIO;
    final Object muxLock = new Object();
    int initialOutboundRation;
    private boolean clientConnectionReady = false;
    boolean serverConnectionReady = false;
    boolean muxDown = false;
    String muxDownMessage;
    Throwable muxDownCause;
    final BitSet busySessions = new BitSet();
    final Map sessions = new HashMap(5);
    private int expectedPingCookie = -1;
    private static final int READ_CLIENT_CONNECTION_HEADER = 0;
    private static final int READ_SERVER_CONNECTION_HEADER = 1;
    private static final int READ_MESSAGE_HEADER = 2;
    private static final int READ_MESSAGE_BODY = 3;
    private final Object readStateLock = new Object();
    private int readState;
    private int currentOp;
    private int currentSessionID;
    private int currentLengthRemaining;
    private ByteBuffer currentDataBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    Mux(OutputStream outputStream, InputStream inputStream, int n, int n2, int n3) throws IOException {
        this.role = n;
        if ((n2 & 0xFF0000FF) != 0) {
            throw new IllegalArgumentException("illegal initial inbound ration: " + Mux.toHexString(n2));
        }
        this.initialInboundRation = n2;
        this.maxFragmentSize = n3;
        this.connectionIO = new StreamConnectionIO(this, outputStream, inputStream);
    }

    Mux(SocketChannel socketChannel, int n, int n2, int n3) throws IOException {
        this.role = n;
        if ((n2 & 0xFF0000FF) != 0) {
            throw new IllegalArgumentException("illegal initial inbound ration: " + Mux.toHexString(n2));
        }
        this.initialInboundRation = n2;
        this.maxFragmentSize = n3;
        this.connectionIO = new SocketChannelConnectionIO(this, socketChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (this.role == 0) {
            this.readState = 1;
        } else {
            if (!$assertionsDisabled && this.role != 1) {
                throw new AssertionError();
            }
            this.readState = 0;
        }
        this.connectionIO.start();
        if (this.role == 0) {
            this.asyncSendClientConnectionHeader();
            Object object = this.muxLock;
            synchronized (object) {
                while (!this.muxDown && !this.clientConnectionReady) {
                    try {
                        this.muxLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        String string = "interrupt waiting for connection header";
                        this.setDown(string, interruptedException);
                        throw new IOException(string);
                    }
                }
                if (this.muxDown) {
                    IOException iOException = new IOException(this.muxDownMessage);
                    iOException.initCause(this.muxDownCause);
                    throw iOException;
                }
            }
        }
    }

    protected void handleDown() {
    }

    void handleOpen(int n) throws ProtocolException {
        throw new ProtocolException("remote endpoint attempted to open session");
    }

    final void addSession(int n, Session session) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.muxLock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.muxDown) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.busySessions.get(n)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.sessions.get(new Integer(n)) != null) {
            throw new AssertionError();
        }
        this.busySessions.set(n);
        this.sessions.put(new Integer(n), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDown(final String string, final Throwable throwable) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                return;
            }
            this.muxDown = true;
            this.muxDownMessage = string;
            this.muxDownCause = throwable;
            this.muxLock.notifyAll();
        }
        systemThreadPool.execute(new Runnable(){

            public void run() {
                Iterator iterator = Mux.this.sessions.values().iterator();
                while (iterator.hasNext()) {
                    Session session = (Session)iterator.next();
                    session.setDown(string, throwable);
                }
            }
        }, "Mux session shutdown");
        this.handleDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSession(int n) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                return;
            }
            if (!$assertionsDisabled && !this.busySessions.get(n)) {
                throw new AssertionError();
            }
            this.busySessions.clear(n);
            this.sessions.remove(new Integer(n));
        }
    }

    final void asyncSendClientConnectionHeader() {
        if (!$assertionsDisabled && this.role != 0) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.put(magic).put((byte)1).putShort((short)(this.initialInboundRation >> 8)).put((byte)0).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendServerConnectionHeader() {
        if (!$assertionsDisabled && this.role != 1) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.put(magic).put((byte)1).putShort((short)(this.initialInboundRation >> 8)).put((byte)0).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendNoOperation(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)0).put((byte)0);
        if (byteBuffer != null) {
            if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
                throw new AssertionError();
            }
            byteBuffer2.putShort((short)byteBuffer.remaining()).flip();
            this.connectionIO.asyncSend(byteBuffer2, byteBuffer);
        } else {
            byteBuffer2.putShort((short)0).flip();
            this.connectionIO.asyncSend(byteBuffer2);
        }
    }

    final void asyncSendShutdown(String string) {
        ByteBuffer byteBuffer = string != null ? Mux.getUTF8BufferFromString(string) : null;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)2).put((byte)0);
        if (byteBuffer != null) {
            if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
                throw new AssertionError();
            }
            byteBuffer2.putShort((short)byteBuffer.remaining()).flip();
            this.connectionIO.asyncSend(byteBuffer2, byteBuffer);
        } else {
            byteBuffer2.putShort((short)0).flip();
            this.connectionIO.asyncSend(byteBuffer2);
        }
    }

    final void asyncSendPing(int n) {
        if (!($assertionsDisabled || n >= 0 && n <= 65535)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put((byte)4).put((byte)0).putShort((short)n).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendPingAck(int n) {
        if (!($assertionsDisabled || n >= 0 && n <= 65535)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put((byte)6).put((byte)0).putShort((short)n).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendError(String string) {
        ByteBuffer byteBuffer = string != null ? Mux.getUTF8BufferFromString(string) : null;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)8).put((byte)0);
        if (byteBuffer != null) {
            if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
                throw new AssertionError();
            }
            byteBuffer2.putShort((short)byteBuffer.remaining()).flip();
            this.connectionIO.asyncSend(byteBuffer2, byteBuffer);
        } else {
            byteBuffer2.putShort((short)0).flip();
            this.connectionIO.asyncSend(byteBuffer2);
        }
    }

    final IOFuture futureSendError(String string) {
        ByteBuffer byteBuffer = Mux.getUTF8BufferFromString(string);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)8).put((byte)0);
        if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
            throw new AssertionError();
        }
        byteBuffer2.putShort((short)byteBuffer.remaining()).flip();
        return this.connectionIO.futureSend(byteBuffer2, byteBuffer);
    }

    final void asyncSendIncrementRation(int n, int n2) {
        if (!($assertionsDisabled || n >= 0 && n <= 127)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n2 >= 0 && n2 <= 65535)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put((byte)16).put((byte)n).putShort((short)n2).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendAbort(int n, int n2, ByteBuffer byteBuffer) {
        if (!$assertionsDisabled && (n & 0xFD) != 32) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n2 >= 0 && n2 <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)n).put((byte)n2);
        if (byteBuffer != null) {
            if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
                throw new AssertionError();
            }
            byteBuffer2.putShort((short)byteBuffer.remaining()).flip();
            this.connectionIO.asyncSend(byteBuffer2, byteBuffer);
        } else {
            byteBuffer2.putShort((short)0).flip();
            this.connectionIO.asyncSend(byteBuffer2);
        }
    }

    final void asyncSendClose(int n) {
        if (!($assertionsDisabled || n >= 0 && n <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put((byte)48).put((byte)n).putShort((short)0).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendAcknowledgment(int n) {
        if (!($assertionsDisabled || n >= 0 && n <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put((byte)64).put((byte)n).putShort((short)0).flip();
        this.connectionIO.asyncSend(byteBuffer);
    }

    final void asyncSendData(int n, int n2, ByteBuffer byteBuffer) {
        if (!$assertionsDisabled && (n & 0xE1) != 128) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (n & 4) == 0 && (n & 8 & 2) != 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n2 >= 0 && n2 <= 127)) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)n).put((byte)n2);
        if (byteBuffer != null) {
            if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
                throw new AssertionError();
            }
            byteBuffer2.putShort((short)byteBuffer.remaining()).flip();
            this.connectionIO.asyncSend(byteBuffer2, byteBuffer);
        } else {
            byteBuffer2.putShort((short)0).flip();
            this.connectionIO.asyncSend(byteBuffer2);
        }
    }

    final IOFuture futureSendData(int n, int n2, ByteBuffer byteBuffer) {
        if (!$assertionsDisabled && (n & 0xE1) != 128) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (n & 4) == 0 && (n & 8 & 2) != 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || n2 >= 0 && n2 <= 127)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && byteBuffer.remaining() > 65535) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        byteBuffer2.put((byte)n).put((byte)n2).putShort((short)byteBuffer.remaining()).flip();
        return this.connectionIO.futureSend(byteBuffer2, byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processIncomingData(ByteBuffer byteBuffer) throws ProtocolException {
        byteBuffer.flip();
        if (!$assertionsDisabled && !byteBuffer.hasRemaining()) {
            throw new AssertionError();
        }
        Object object = this.readStateLock;
        synchronized (object) {
            block9: do {
                switch (this.readState) {
                    case 0: {
                        if (this.readClientConnectionHeader(byteBuffer)) continue block9;
                        break block9;
                    }
                    case 1: {
                        if (this.readServerConnectionHeader(byteBuffer)) continue block9;
                        break block9;
                    }
                    case 2: {
                        if (this.readMessageHeader(byteBuffer)) continue block9;
                        break block9;
                    }
                    case 3: {
                        if (this.readMessageBody(byteBuffer)) continue block9;
                        break block9;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            } while (byteBuffer.hasRemaining());
        }
        byteBuffer.compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readClientConnectionHeader(ByteBuffer byteBuffer) throws ProtocolException {
        if (!$assertionsDisabled && this.role != 1) {
            throw new AssertionError();
        }
        this.validatePartialMagicNumber(byteBuffer);
        if (byteBuffer.remaining() < 8) {
            return false;
        }
        int n = byteBuffer.position();
        byteBuffer.position(n + 4);
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = (byteBuffer.getShort() & 0xFFFF) << 8;
        int n4 = byteBuffer.get() & 0xFF;
        boolean bl = (n4 & 1) != 0;
        Object object = this.muxLock;
        synchronized (object) {
            this.initialOutboundRation = n3;
            this.asyncSendServerConnectionHeader();
            if (n2 == 0) {
                throw new ProtocolException("bad protocol version: " + n2);
            }
            if (n2 > 1 && !bl) {
                this.setDown("unsupported protocol version: " + n2, null);
                throw new ProtocolException("unsupported protocol version: " + n2);
            }
            this.serverConnectionReady = true;
        }
        this.readState = 2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readServerConnectionHeader(ByteBuffer byteBuffer) throws ProtocolException {
        if (!$assertionsDisabled && this.role != 0) {
            throw new AssertionError();
        }
        this.validatePartialMagicNumber(byteBuffer);
        if (byteBuffer.remaining() < 8) {
            return false;
        }
        int n = byteBuffer.position();
        byteBuffer.position(n + 4);
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = (byteBuffer.getShort() & 0xFFFF) << 8;
        int n4 = byteBuffer.get() & 0xFF;
        Object object = this.muxLock;
        synchronized (object) {
            this.initialOutboundRation = n3;
            if (n2 == 0) {
                throw new ProtocolException("bad protocol version: " + n2);
            }
            if (n2 > 1) {
                throw new ProtocolException("unexpected protocol version: " + n2);
            }
            this.clientConnectionReady = true;
            this.muxLock.notifyAll();
        }
        this.readState = 2;
        return true;
    }

    private void validatePartialMagicNumber(ByteBuffer byteBuffer) throws ProtocolException {
        if (byteBuffer.remaining() > 0) {
            byte[] byArray = new byte[Math.min(byteBuffer.remaining(), magic.length)];
            byteBuffer.mark();
            byteBuffer.get(byArray);
            byteBuffer.reset();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == magic[i]) continue;
                this.setDown((this.role == 0 ? "server" : "client") + " sent bad magic number: " + Mux.toHexString(byArray), null);
                throw new ProtocolException("bad magic number: " + Mux.toHexString(byArray));
            }
        }
    }

    private boolean readMessageHeader(ByteBuffer byteBuffer) throws ProtocolException {
        int n;
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        int n2 = byteBuffer.position();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
        }
        if (((n = byteBuffer.get() & 0xFF) & 0xE1) == 128) {
            int n3 = byteBuffer.get() & 0xFF;
            if (n3 > 127) {
                throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
            }
            this.currentOp = n;
            this.currentSessionID = n3;
            this.currentLengthRemaining = byteBuffer.getShort() & 0xFFFF;
            if (this.currentLengthRemaining > 0) {
                this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                this.readState = 3;
            } else {
                this.dispatchCurrentMessage();
            }
            return true;
        }
        if ((n & 0xF1) == 16) {
            int n4 = byteBuffer.get() & 0xFF;
            if (n4 > 127) {
                throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
            }
            int n5 = byteBuffer.getShort() & 0xFFFF;
            int n6 = n & 0xE;
            this.handleIncrementRation(n4, n5 <<= n6);
            return true;
        }
        if ((n & 0xFD) == 32) {
            int n7 = byteBuffer.get() & 0xFF;
            if (n7 > 127) {
                throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
            }
            this.currentOp = n;
            this.currentSessionID = n7;
            this.currentLengthRemaining = byteBuffer.getShort() & 0xFFFF;
            if (this.currentLengthRemaining > 0) {
                this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                this.readState = 3;
            } else {
                this.dispatchCurrentMessage();
            }
            return true;
        }
        switch (n) {
            case 0: {
                if (byteBuffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                this.currentOp = n;
                this.currentLengthRemaining = byteBuffer.getShort() & 0xFFFF;
                this.currentDataBuffer = null;
                if (this.currentLengthRemaining > 0) {
                    this.readState = 3;
                } else {
                    this.dispatchCurrentMessage();
                }
                return true;
            }
            case 2: {
                if (byteBuffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                this.currentOp = n;
                this.currentLengthRemaining = byteBuffer.getShort() & 0xFFFF;
                if (this.currentLengthRemaining > 0) {
                    this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                    this.readState = 3;
                } else {
                    this.dispatchCurrentMessage();
                }
                return true;
            }
            case 4: {
                if (byteBuffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                int n8 = byteBuffer.getShort() & 0xFFFF;
                this.handlePing(n8);
                return true;
            }
            case 6: {
                if (byteBuffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                int n9 = byteBuffer.getShort() & 0xFFFF;
                this.handlePingAck(n9);
                return true;
            }
            case 8: {
                if (byteBuffer.get() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                this.currentOp = n;
                this.currentLengthRemaining = byteBuffer.getShort() & 0xFFFF;
                if (this.currentLengthRemaining > 0) {
                    this.currentDataBuffer = ByteBuffer.allocate(this.currentLengthRemaining);
                    this.readState = 3;
                } else {
                    this.dispatchCurrentMessage();
                }
                return true;
            }
            case 48: {
                int n10 = byteBuffer.get() & 0xFF;
                if (n10 > 127 || byteBuffer.getShort() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                this.handleClose(n10);
                return true;
            }
            case 64: {
                int n11 = byteBuffer.get() & 0xFF;
                if (n11 > 127 || byteBuffer.getShort() != 0) {
                    throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
                }
                this.handleAcknowledgment(n11);
                return true;
            }
        }
        throw new ProtocolException("bad message header: " + Mux.toHexString(byteBuffer.getInt(n2)));
    }

    private boolean readMessageBody(ByteBuffer byteBuffer) throws ProtocolException {
        if (!$assertionsDisabled && this.currentLengthRemaining <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.currentDataBuffer != null && this.currentDataBuffer.remaining() != this.currentLengthRemaining) {
            throw new AssertionError();
        }
        if (byteBuffer.remaining() > this.currentLengthRemaining) {
            int n = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + this.currentLengthRemaining);
            if (this.currentDataBuffer != null) {
                this.currentDataBuffer.put(byteBuffer);
            } else {
                byteBuffer.position(byteBuffer.position() + this.currentLengthRemaining);
            }
            this.currentLengthRemaining = 0;
            byteBuffer.limit(n);
        } else {
            this.currentLengthRemaining -= byteBuffer.remaining();
            if (this.currentDataBuffer != null) {
                this.currentDataBuffer.put(byteBuffer);
            } else {
                byteBuffer.position(byteBuffer.limit());
            }
        }
        if (this.currentLengthRemaining > 0) {
            return false;
        }
        this.currentDataBuffer.flip();
        this.dispatchCurrentMessage();
        this.currentDataBuffer = null;
        this.readState = 2;
        return true;
    }

    private void dispatchCurrentMessage() throws ProtocolException {
        if (!$assertionsDisabled && this.currentDataBuffer != null && !this.currentDataBuffer.hasRemaining()) {
            throw new AssertionError();
        }
        int n = this.currentOp;
        if ((n & 0xE1) == 128) {
            boolean bl = (n & 0x10) != 0;
            boolean bl2 = (n & 8) != 0;
            boolean bl3 = (n & 4) != 0;
            boolean bl4 = (n & 2) != 0;
            this.handleData(this.currentSessionID, bl, bl2, bl3, bl4, this.currentDataBuffer != null ? this.currentDataBuffer : ByteBuffer.allocate(0));
            return;
        }
        if ((n & 0xFD) == 32) {
            boolean bl = (n & 2) != 0;
            this.handleAbort(this.currentSessionID, bl, this.currentDataBuffer != null ? Mux.getStringFromUTF8Buffer(this.currentDataBuffer) : "");
            return;
        }
        switch (n) {
            case 0: {
                this.handleNoOperation();
                return;
            }
            case 2: {
                this.handleShutdown(this.currentDataBuffer != null ? Mux.getStringFromUTF8Buffer(this.currentDataBuffer) : "");
                return;
            }
            case 8: {
                this.handleError(this.currentDataBuffer != null ? Mux.getStringFromUTF8Buffer(this.currentDataBuffer) : "");
                return;
            }
        }
        throw new AssertionError((Object)Integer.toHexString((byte)n));
    }

    private void handleNoOperation() throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "NoOperation");
        }
    }

    private void handleShutdown(String string) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Shutdown");
        }
        if (this.role != 0) {
            throw new ProtocolException("Shutdown sent by client");
        }
        this.setDown("mux connection shut down gracefully", null);
        throw new ProtocolException("received Shutdown message");
    }

    private void handlePing(int n) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Ping: cookie=" + n);
        }
        this.asyncSendPingAck(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePingAck(int n) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PingAck: cookie=" + n);
        }
        Object object = this.muxLock;
        synchronized (object) {
            if (n != this.expectedPingCookie) {
                throw new ProtocolException("unexpected ping cookie: " + n);
            }
            this.expectedPingCookie = -1;
        }
    }

    private void handleError(String string) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Error");
        }
        this.setDown((this.role == 0 ? "server" : "client") + " reported protocol error: " + string, null);
        throw new ProtocolException("received Error message");
    }

    private void handleIncrementRation(int n, int n2) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "IncrementRation: sessionID=" + n + ",increment=" + n2);
        }
        this.getSession(n).handleIncrementRation(n2);
    }

    private void handleAbort(int n, boolean bl, String string) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Abort: sessionID=" + n + ",partial=" + bl);
        }
        this.getSession(n).handleAbort(bl);
    }

    private void handleClose(int n) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Close: sessionID=" + n);
        }
        this.getSession(n).handleClose();
    }

    private void handleAcknowledgment(int n) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Acknowledgment: sessionID=" + n);
        }
        this.getSession(n).handleAcknowledgment();
    }

    private void handleData(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, ByteBuffer byteBuffer) throws ProtocolException {
        if (logger.isLoggable(Level.FINEST)) {
            int n2 = byteBuffer.remaining();
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.mark();
            byteBuffer.get(byArray);
            byteBuffer.reset();
            logger.log(Level.FINEST, "Data: sessionID=" + n + (bl ? ",open" : "") + (bl2 ? ",close" : "") + (bl3 ? ",eof" : "") + (bl4 ? ",ackRequired" : "") + ",length=" + n2 + (n2 > 0 ? ",data=\n" + hexDumpEncoder.encode(byArray) : ""));
        }
        if (!bl3 && (bl2 || bl4)) {
            throw new ProtocolException("Data: eof=" + bl3 + ",close=" + bl2 + ",ackRequired=" + bl4);
        }
        if (bl) {
            this.handleOpen(n);
        }
        this.getSession(n).handleData(byteBuffer, bl3, bl2, bl4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(int n) throws ProtocolException {
        Object object = this.muxLock;
        synchronized (object) {
            if (!this.busySessions.get(n)) {
                throw new ProtocolException("inactive sessionID: " + n);
            }
            return (Session)this.sessions.get(new Integer(n));
        }
    }

    private static ByteBuffer getUTF8BufferFromString(String string) {
        CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
        try {
            return charsetEncoder.encode(CharBuffer.wrap(string));
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }

    private static String getStringFromUTF8Buffer(ByteBuffer byteBuffer) {
        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
        try {
            return charsetDecoder.decode(byteBuffer).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            return "(error decoding UTF-8 message: " + characterCodingException.toString() + ")";
        }
    }

    private static String toHexString(byte by) {
        char[] cArray = new char[]{Mux.toHexChar(by >> 4 & 0xF), Mux.toHexChar(by & 0xF)};
        return new String(cArray);
    }

    private static String toHexString(int n) {
        char[] cArray = new char[8];
        for (int i = 0; i < 8; ++i) {
            cArray[i] = Mux.toHexChar(n >> (7 - i) * 4 & 0xF);
        }
        return new String(cArray);
    }

    private static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            cArray[n++] = Mux.toHexChar(byArray[i] >> 4 & 0xF);
            cArray[n++] = Mux.toHexChar(byArray[i] & 0xF);
        }
        return new String(cArray);
    }

    private static char toHexChar(int n) {
        return n < 10 ? (char)(48 + n) : (char)(55 + n);
    }

    static {
        $assertionsDisabled = !Mux.class.desiredAssertionStatus();
        magic = new byte[]{74, 109, 117, 120};
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
        logger = Logger.getLogger("net.jini.jeri.connection.mux");
    }
}

