/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.StartLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class MessageWriter {
    private static final int CHUNK_SIZE = 512;
    private static final int START = 0;
    private static final int HEADER = 1;
    private static final int CONTENT = 2;
    private static final int DONE = 3;
    private final OutputStream out;
    private final OutputStream cout;
    private int state = 0;
    private Header header;

    MessageWriter(OutputStream outputStream, boolean bl) {
        this.out = outputStream;
        this.cout = bl ? new ChunkedOutputStream() : new ByteArrayOutputStream();
    }

    void writeStartLine(StartLine startLine) throws IOException {
        this.updateState(0, 1);
        startLine.write(this.out);
    }

    void writeHeader(Header header) throws IOException {
        this.updateState(1, 2);
        if (this.cout instanceof ChunkedOutputStream) {
            header.setField("Transfer-Encoding", "chunked");
            header.setField("Content-Length", null);
            header.write(this.out);
        } else {
            this.header = header;
        }
    }

    void writeContent(byte[] byArray, int n, int n2) throws IOException {
        this.updateState(2, 2);
        this.cout.write(byArray, n, n2);
    }

    void writeTrailer(Header header) throws IOException {
        this.updateState(2, 3);
        this.cout.close();
        if (this.cout instanceof ChunkedOutputStream) {
            if (header != null) {
                header.write(this.out);
            } else {
                MessageWriter.writeLine(this.out, "");
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.cout;
            this.header.merge(header);
            this.header.setField("Content-Length", Integer.toString(byteArrayOutputStream.size()));
            this.header.setField("Transfer-Encoding", null);
            this.header.write(this.out);
            byteArrayOutputStream.writeTo(this.out);
        }
        this.out.flush();
    }

    void flush() throws IOException {
        if (this.state == 3) {
            throw new IllegalStateException();
        }
        if (this.state == 2) {
            this.cout.flush();
        }
        this.out.flush();
    }

    static void writeLine(OutputStream outputStream, String string) throws IOException {
        string = string + "\r\n";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            outputStream.write(string.charAt(i));
        }
    }

    private void updateState(int n, int n2) {
        if (this.state != n) {
            throw new IllegalStateException();
        }
        this.state = n2;
    }

    private class ChunkedOutputStream
    extends OutputStream {
        private final byte[] buf = new byte[512];
        private int pos = 0;

        ChunkedOutputStream() {
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = this.buf.length - this.pos;
                if (n3 > 0) {
                    int n4 = Math.min(n2, n3);
                    System.arraycopy(byArray, n, this.buf, this.pos, n4);
                    this.pos += n4;
                    n += n4;
                    n2 -= n4;
                    continue;
                }
                this.flush();
            }
        }

        public void flush() throws IOException {
            if (this.pos > 0) {
                MessageWriter.writeLine(MessageWriter.this.out, Integer.toString(this.pos, 16));
                MessageWriter.this.out.write(this.buf, 0, this.pos);
                MessageWriter.writeLine(MessageWriter.this.out, "");
                this.pos = 0;
            }
        }

        public void close() throws IOException {
            this.flush();
            MessageWriter.writeLine(MessageWriter.this.out, "0");
        }
    }
}

