/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.internal.BaseProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

class EndpointBasedProvider
extends BaseProvider {
    protected final EndpointInternals endpointInternals;

    EndpointBasedProvider(String string, EndpointInternals endpointInternals) {
        super(string);
        if (endpointInternals == null) {
            throw new NullPointerException();
        }
        this.endpointInternals = endpointInternals;
    }

    static boolean checkIntegrity(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        boolean bl = false;
        Iterator iterator = invocationConstraints.requirements().iterator();
        while (iterator.hasNext()) {
            InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
            if (invocationConstraint == Integrity.YES) {
                bl = true;
                continue;
            }
            if (invocationConstraint instanceof Integrity) continue;
            throw new UnsupportedConstraintException("cannot satisfy constraint: " + invocationConstraint);
        }
        if (!bl) {
            iterator = invocationConstraints.preferences().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != Integrity.YES) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static byte[] calcHandshakeHash(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            EndpointBasedProvider.update(messageDigest, byteBuffer);
            EndpointBasedProvider.update(messageDigest, byteBuffer2);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    private static void update(MessageDigest messageDigest, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            messageDigest.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            messageDigest.update(byArray, 0, byArray.length);
        }
    }
}

