/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppManagementApiBuilder;
import com.mathworks.appmanagement.AppPrefKey;
import com.mathworks.appmanagement.SettingsUtility;
import com.mathworks.appmanagement.resources.ResourceKey;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.mwswing.AdjacentButton;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.dialog.MJFolderChooser;
import com.mathworks.services.settings.SettingNotFoundException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.SwingUtilities;

public final class AppsPreferencePanel
extends MJPanel {
    private static AppsPreferencePanel sPrefsPanel;
    private static MJTextField installFolderField;
    private MJPanel appsInstallFolderPanel;
    private static PlatformImpl platform;
    private MJPanel instructionPanel;

    private AppsPreferencePanel() {
    }

    private void init() {
        this.instructionPanel = new MJPanel((LayoutManager)new BorderLayout(10, 10));
        this.instructionPanel.setName("AppsInstruction");
        this.appsInstallFolderPanel = new MJPanel((LayoutManager)new BorderLayout(10, 10));
        this.appsInstallFolderPanel.setName("Apps");
        MJTextArea mJTextArea = new MJTextArea();
        mJTextArea.setLineWrap(true);
        mJTextArea.setWrapStyleWord(true);
        mJTextArea.setText(ResourceKey.APPS_INSTRUCTION.getString(new Object[0]));
        mJTextArea.setEditable(false);
        mJTextArea.setBackground(this.getBackground());
        MJLabel mJLabel = new MJLabel(ResourceKey.APPS_INSTALL_LOCATION.getString(new Object[0]));
        installFolderField = new MJTextField("", 10);
        installFolderField.setEnabled(false);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final String string = AppsPreferencePanel.this.getCurrentOrDefaultFolder();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        installFolderField.setText(string);
                        installFolderField.setEnabled(true);
                    }
                });
            }
        }, "initializeAppInstallFolder");
        thread.setDaemon(true);
        thread.start();
        installFolderField.setName("FolderField");
        installFolderField.getAccessibleContext().setAccessibleName(ResourceKey.APPS_INSTALL_LOCATION.getString(new Object[0]));
        AdjacentButton adjacentButton = new AdjacentButton(ResourceKey.APPS_BROWSE.getString(new Object[0]), (Component)installFolderField);
        adjacentButton.addActionListener((ActionListener)new FileChooserButtonListener());
        adjacentButton.setName("InstallFolderBrowseButton");
        this.instructionPanel.add((Component)mJTextArea, (Object)"North");
        this.appsInstallFolderPanel.add((Component)mJLabel, (Object)"West");
        this.appsInstallFolderPanel.add((Component)installFolderField, (Object)"Center");
        this.appsInstallFolderPanel.add((Component)adjacentButton, (Object)"East");
        int n = 10;
        int n2 = 10;
        this.setLayout((LayoutManager)new MGridLayout(4, 1, n, n2, 131072));
        this.add((Component)this.instructionPanel);
        this.add((Component)this.appsInstallFolderPanel);
    }

    public static synchronized MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new AppsPreferencePanel();
        sPrefsPanel.setName("AppsPreferencePanel");
        sPrefsPanel.init();
        return sPrefsPanel;
    }

    public static synchronized void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    public static synchronized boolean validatePrefsPanel() {
        return sPrefsPanel == null || sPrefsPanel.validateOptions();
    }

    private String getCurrentOrDefaultFolder() {
        Object object;
        block5: {
            String string = "";
            try {
                object = AppManagementApiBuilder.getAppManagementApiImpl().getDefaultInstallFolder();
                string = ((File)object).getAbsolutePath();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                object = SettingsUtility.isStringSettingSet(AppPrefKey.APPSINSTALLFOLDER).booleanValue() ? SettingsUtility.getStringSetting(AppPrefKey.APPSINSTALLFOLDER) : string;
            }
            catch (SettingNotFoundException settingNotFoundException) {
                object = string;
            }
            catch (Exception exception) {
                object = string;
                if (!string.equals("")) break block5;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MJOptionPane.showMessageDialog((Component)AppsPreferencePanel.this.appsInstallFolderPanel, (Object)ResourceKey.APPS_ERROR_SETTING.getString(AppPrefKey.APPSINSTALLFOLDER.get(), exception.toString()), (String)ResourceKey.APPS_ERROR_TITLE.getString(new Object[0]), (int)0);
                    }
                });
                exception.printStackTrace();
            }
        }
        return object;
    }

    private boolean validateOptions() {
        String string = installFolderField.getText().trim();
        boolean bl = true;
        String string2 = null;
        if (!string.isEmpty()) {
            String string3;
            File file = new File(string);
            try {
                string3 = file.getCanonicalPath().toLowerCase(Locale.getDefault());
            }
            catch (IOException iOException) {
                string3 = string;
            }
            if (!file.isAbsolute() || (platform.isLinux() || platform.isMac()) && !string3.matches("([\\w-_./])+") || platform.isWindows() && !string3.matches("([^+@'!*?;|>\\<])+") || string3.endsWith(File.separator + "private")) {
                string2 = ResourceKey.APPS_ERROR_INVALID_PATH.getString(string);
            }
            FolderUtilsImpl folderUtilsImpl = new FolderUtilsImpl();
            if (string2 == null && file.isFile()) {
                string2 = ResourceKey.APPS_ERROR_CANNOT_MKDIR.getString(string);
            }
            if (string2 == null && !folderUtilsImpl.exists(string) && !folderUtilsImpl.mkdirs(string)) {
                string2 = ResourceKey.APPS_ERROR_CANNOT_MKDIR.getString(string);
            }
        }
        if (string2 != null) {
            MJOptionPane.showMessageDialog((Component)this.appsInstallFolderPanel, string2, (String)ResourceKey.APPS_ERROR_TITLE.getString(new Object[0]), (int)0);
            bl = false;
        }
        return bl;
    }

    private void saveOptions() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final String string = AppsPreferencePanel.this.getCurrentOrDefaultFolder();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string2 = installFolderField.getText().trim();
                        if (!string2.equalsIgnoreCase(string)) {
                            try {
                                if (SettingsUtility.isStringSettingSet(AppPrefKey.APPSINSTALLFOLDER).booleanValue() && string2.isEmpty()) {
                                    try {
                                        SettingsUtility.unsetSetting(AppPrefKey.APPSINSTALLFOLDER);
                                        AppManagementApiBuilder.getAppManagementApiImpl().updateGallery();
                                    }
                                    catch (Exception exception) {
                                        MJOptionPane.showMessageDialog((Component)AppsPreferencePanel.this.appsInstallFolderPanel, (Object)ResourceKey.APPS_ERROR_DELETING.getString(AppPrefKey.APPSINSTALLFOLDER.get(), exception.toString()), (String)ResourceKey.APPS_ERROR_TITLE.getString(new Object[0]), (int)0);
                                    }
                                } else if (!string2.isEmpty()) {
                                    SettingsUtility.setStringSetting(AppPrefKey.APPSINSTALLFOLDER, string2);
                                    AppManagementApiBuilder.getAppManagementApiImpl().updateGallery();
                                }
                            }
                            catch (Exception exception) {
                                MJOptionPane.showMessageDialog((Component)AppsPreferencePanel.this.appsInstallFolderPanel, (Object)ResourceKey.APPS_ERROR_SETTING.getString(AppPrefKey.APPSINSTALLFOLDER.get(), exception.toString()), (String)ResourceKey.APPS_ERROR_TITLE.getString(new Object[0]), (int)0);
                            }
                        }
                    }
                });
            }
        }, "SaveAppInstallFolder");
        thread.setDaemon(true);
        thread.start();
    }

    static {
        platform = new PlatformImpl();
    }

    private class FileChooserButtonListener
    implements ActionListener {
        private FileChooserButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderUtilsImpl folderUtilsImpl = new FolderUtilsImpl();
            File file = folderUtilsImpl.getSearchPathForFileBrowser(new File(installFolderField.getText()), null);
            MJFolderChooser.browseForFolder((Component)((Object)AppsPreferencePanel.this), (String)ResourceKey.APPS_CHOOSE_FOLDER.getString(new Object[0]), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    installFolderField.setText(actionEvent.getActionCommand());
                }
            }, (File)file);
        }
    }
}

