/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.mathworks.appmanagement.AppFileData;
import com.mathworks.appmanagement.AppManagementApiBuilder;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.appmanagement.ProductDependency;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolstrip.accessories.CalloutToolTipManager;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;

public final class AppFileDetails {
    private AppFileData fData;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.appmanagement.resources.RES_Appmanagement");
    private JComponent fPanel;
    private DescriptionPanel fDescPanel;
    private MJPanel fCollapsedPanel;
    private MJPanel fExpandedPanel;
    private boolean fArrowDown = false;
    private boolean fIsTip = false;
    private static final Icon HIGH_CONTRAST_RIGHT_ARROW = IconUtils.changeIconColor((ImageIcon)DocumentIcon.BLACK_RIGHT_ARROW.getIcon(), (Color)Color.WHITE);
    private static final Icon HIGH_CONTRAST_DOWN_ARROW = IconUtils.changeIconColor((ImageIcon)DocumentIcon.BLACK_DOWN_ARROW.getIcon(), (Color)Color.WHITE);
    private File fLoc = null;

    public AppFileDetails(String string, boolean bl) {
        try {
            this.fData = new AppFileData(string);
            this.fIsTip = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AppFileDetails(AppMetadata appMetadata, boolean bl) {
        try {
            this.fData = new AppFileData(appMetadata);
            this.fIsTip = bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JComponent getPanel() {
        if (this.fPanel == null) {
            this.createScrollPane();
        }
        return this.fPanel;
    }

    public void createScrollPane() {
        if (this.fData != null) {
            MJTextPane mJTextPane = new MJTextPane();
            mJTextPane.setEditable(false);
            mJTextPane.setEditorKit((EditorKit)new HTMLEditorKit());
            mJTextPane.setCaretPosition(0);
            TitlePanel titlePanel = new TitlePanel();
            mJTextPane.insertComponent((Component)((Object)titlePanel));
            int n = mJTextPane.getDocument().getLength();
            mJTextPane.setCaretPosition(n);
            ImagePanel imagePanel = new ImagePanel(this.fData.getScreenShot());
            mJTextPane.insertComponent((Component)imagePanel);
            n = mJTextPane.getDocument().getLength();
            mJTextPane.setCaretPosition(n);
            this.fDescPanel = new DescriptionPanel();
            mJTextPane.insertComponent((Component)((Object)this.fDescPanel));
            MJScrollPane mJScrollPane = new MJScrollPane((Component)mJTextPane);
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            mJScrollPane.setBorder(border);
            if (this.fIsTip) {
                if (this.fExpandedPanel != null) {
                    this.fExpandedPanel.setBackground(UIManager.getColor("ToolTip.background"));
                }
                if (this.fCollapsedPanel != null) {
                    this.fCollapsedPanel.setBackground(UIManager.getColor("ToolTip.background"));
                }
                this.fDescPanel.setBackground(UIManager.getColor("ToolTip.background"));
                mJTextPane.setBackground(UIManager.getColor("ToolTip.background"));
                mJScrollPane.setBackground(UIManager.getColor("ToolTip.background"));
            }
            this.fPanel = mJScrollPane;
        }
    }

    private MJPanel createExpandedTipFilePanel() {
        String[] stringArray = this.fData.getAppEntries();
        int n = stringArray.length;
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("p:grow", "p:grow");
        for (int i = 1; i <= n; ++i) {
            formLayout.appendRow(new RowSpec("p:grow"));
        }
        MJPanel mJPanel = new MJPanel((LayoutManager)formLayout);
        if (this.fIsTip) {
            mJPanel.setBackground(UIManager.getColor("ToolTip.background"));
        }
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                FileLocation fileLocation = new FileLocation(AppFileDetails.this.fLoc.toString());
                FileLocation fileLocation2 = new FileLocation(fileLocation, string);
                String string2 = "uiopen('" + StringUtils.quoteSingleQuotes((String)fileLocation2.toString()) + "',1)";
                new Matlab().evalNoOutput(string2);
                OverlayManagers.get((Component)MatlabDesktopServices.getDesktop().getMainFrame()).removePopups();
                CalloutToolTipManager.getInstance().clear();
            }
        };
        mJPanel.add((Component)new HyperlinkTextLabel("<b>" + sRes.getString("details.viewfilelist") + "</b>", null).getComponent(), (Object)cellConstraints.xy(1, 1));
        for (int i = 0; i < n; ++i) {
            if (MLFileUtils.isMFile((String)stringArray[i])) {
                mJPanel.add((Component)new HyperlinkTextLabel("<a href='" + stringArray[i] + "'>" + stringArray[i] + "</a>", hyperlinkHandler).getComponent(), (Object)cellConstraints.xy(1, i + 2));
                continue;
            }
            mJPanel.add((Component)new HyperlinkTextLabel(stringArray[i], hyperlinkHandler).getComponent(), (Object)cellConstraints.xy(1, i + 2));
        }
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FormLayout("8dlu,0dlu,p", "p,p"));
        MJButton mJButton = this.createButton(AppFileDetails.getDownArrow(!this.fIsTip));
        mJPanel2.add((Component)mJButton, (Object)cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.TOP));
        mJPanel2.add((Component)mJPanel, (Object)cellConstraints.xy(3, 1));
        return mJPanel2;
    }

    private MJPanel createExpandedFilePanel() {
        String[] stringArray = this.fData.getAppEntries();
        int n = stringArray.length;
        MJTextArea mJTextArea = new MJTextArea(n + 1, 1);
        mJTextArea.setEditable(false);
        mJTextArea.append(sRes.getString("details.viewfilelist"));
        mJTextArea.append("\n");
        for (int i = 0; i < n; ++i) {
            mJTextArea.append(stringArray[i]);
            if (i == n - 1) continue;
            mJTextArea.append("\n");
        }
        CellConstraints cellConstraints = new CellConstraints();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("8dlu,0dlu,p", "p,p"));
        MJButton mJButton = this.createButton(AppFileDetails.getDownArrow(!this.fIsTip));
        mJPanel.add((Component)mJButton, (Object)cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.TOP));
        mJPanel.add((Component)mJTextArea, (Object)cellConstraints.xy(3, 1));
        return mJPanel;
    }

    private MJPanel createCollapsedFilePanel() {
        MJTextArea mJTextArea = new MJTextArea(1, 1);
        mJTextArea.setEditable(false);
        mJTextArea.append(sRes.getString("details.viewfilelist"));
        if (this.fIsTip) {
            mJTextArea.setBackground(UIManager.getColor("ToolTip.background"));
        }
        CellConstraints cellConstraints = new CellConstraints();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("8dlu,0dlu,p", "p,p"));
        MJButton mJButton = this.createButton(AppFileDetails.getRightArrow(!this.fIsTip));
        mJPanel.add((Component)mJButton, (Object)cellConstraints.xy(1, 1, CellConstraints.CENTER, CellConstraints.TOP));
        mJPanel.add((Component)mJTextArea, (Object)cellConstraints.xy(3, 1));
        return mJPanel;
    }

    private MJButton createButton(Icon icon) {
        MJButton mJButton = new MJButton(icon);
        mJButton.setBorderPainted(false);
        mJButton.setContentAreaFilled(false);
        mJButton.setFocusPainted(false);
        mJButton.setOpaque(false);
        mJButton.setSize(icon.getIconWidth(), icon.getIconHeight());
        if (this.fIsTip) {
            mJButton.setBackground(UIManager.getColor("ToolTip.background"));
        }
        mJButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (AppFileDetails.this.fArrowDown) {
                    AppFileDetails.this.fArrowDown = false;
                    AppFileDetails.this.fDescPanel.remove((Component)AppFileDetails.this.fExpandedPanel);
                    AppFileDetails.this.fDescPanel.add((Component)AppFileDetails.this.fCollapsedPanel);
                    AppFileDetails.this.fCollapsedPanel.revalidate();
                    AppFileDetails.this.fCollapsedPanel.repaint();
                } else {
                    AppFileDetails.this.fArrowDown = true;
                    AppFileDetails.this.fDescPanel.remove((Component)AppFileDetails.this.fCollapsedPanel);
                    AppFileDetails.this.fDescPanel.add((Component)AppFileDetails.this.fExpandedPanel);
                    AppFileDetails.this.fExpandedPanel.revalidate();
                    AppFileDetails.this.fExpandedPanel.repaint();
                }
            }
        });
        mJButton.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    // empty if block
                }
            }
        });
        return mJButton;
    }

    static Icon getRightArrow(boolean bl) {
        if (ColorPrefs.getBackgroundColor().getRGB() == Color.BLACK.getRGB() && bl) {
            return HIGH_CONTRAST_RIGHT_ARROW;
        }
        return DocumentIcon.BLACK_RIGHT_ARROW.getIcon();
    }

    static Icon getDownArrow(boolean bl) {
        if (ColorPrefs.getBackgroundColor().getRGB() == Color.BLACK.getRGB() && bl) {
            return HIGH_CONTRAST_DOWN_ARROW;
        }
        return DocumentIcon.BLACK_DOWN_ARROW.getIcon();
    }

    public class DescriptionPanel
    extends MJPanel {
        public DescriptionPanel() {
            StringBuilder stringBuilder;
            String string;
            super((LayoutManager)new BorderLayout(5, 0));
            String string2 = AppFileDetails.this.fData.getDescription() == null ? "" : AppFileDetails.this.fData.getDescription();
            String string3 = AppFileDetails.this.fData.getVersion() == null ? "" : AppFileDetails.this.fData.getVersion();
            ProductDependency[] productDependencyArray = AppFileDetails.this.fData.getRequiredProducts();
            if (productDependencyArray.length == 0) {
                string = sRes.getString("details.norequirements");
            } else {
                stringBuilder = new StringBuilder();
                for (int i = 0; i < productDependencyArray.length; ++i) {
                    stringBuilder.append(productDependencyArray[i].getName());
                    if (i == productDependencyArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
                string = stringBuilder.toString();
            }
            stringBuilder = new HyperlinkTextLabel("<b>" + sRes.getString("details.version") + ": </b> " + string3, new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                }
            });
            stringBuilder.getComponent().setName("version_detail_label");
            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel("<b>" + sRes.getString("details.requirements") + ": </b> " + string, new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                }
            });
            HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel("<b>" + sRes.getString("details.description") + ": </b> " + string2, new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                    String string2 = "web('" + string + "')";
                    new Matlab().eval(string2, (MatlabListener)null);
                }
            });
            AppFileDetails.this.fCollapsedPanel = AppFileDetails.this.createCollapsedFilePanel();
            if (AppFileDetails.this.fIsTip) {
                AppFileDetails.this.fExpandedPanel = AppFileDetails.this.createExpandedTipFilePanel();
            } else {
                AppFileDetails.this.fExpandedPanel = AppFileDetails.this.createExpandedFilePanel();
            }
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(5, 0));
            mJPanel.add((Component)stringBuilder.getComponent(), (Object)"North");
            mJPanel.add((Component)hyperlinkTextLabel.getComponent(), (Object)"Center");
            if (AppFileDetails.this.fIsTip) {
                try {
                    AppFileDetails.this.fLoc = AppManagementApiBuilder.getAppManagementApi().getAppInstallFolder(AppFileDetails.this.fData.getGuid());
                    HyperlinkTextLabel hyperlinkTextLabel3 = new HyperlinkTextLabel("<b>" + sRes.getString("details.location") + ": </b> " + "<a href=\\>" + AppFileDetails.this.fLoc.getAbsolutePath() + "</a>", new HyperlinkTextLabel.HyperlinkHandler(){

                        public void processHyperlink(String string) {
                            MatlabPath.setCurrentDirectory((File)AppFileDetails.this.fLoc);
                            OverlayManagers.get((Component)MatlabDesktopServices.getDesktop().getMainFrame()).removePopups();
                            CalloutToolTipManager.getInstance().clear();
                            MatlabDesktopServices.showFileBrowser();
                        }
                    });
                    mJPanel.add((Component)hyperlinkTextLabel3.getComponent(), (Object)"South");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.add((Component)mJPanel, "North");
            this.add((Component)AppFileDetails.this.fCollapsedPanel, "Center");
            this.add(hyperlinkTextLabel2.getComponent(), "South");
            if (AppFileDetails.this.fIsTip) {
                stringBuilder.getComponent().setBackground(UIManager.getColor("ToolTip.background"));
                hyperlinkTextLabel.getComponent().setBackground(UIManager.getColor("ToolTip.background"));
                hyperlinkTextLabel2.getComponent().setBackground(UIManager.getColor("ToolTip.background"));
                mJPanel.setBackground(UIManager.getColor("ToolTip.background"));
                AppFileDetails.this.fCollapsedPanel.setBackground(UIManager.getColor("ToolTip.background"));
                AppFileDetails.this.fExpandedPanel.setBackground(UIManager.getColor("ToolTip.background"));
            }
        }
    }

    public static class ImagePanel
    extends JPanel {
        private ImageIcon fImage;

        public ImagePanel(ImageIcon imageIcon) {
            this.fImage = imageIcon;
            this.setPreferredSize(new Dimension(this.fImage.getIconWidth(), this.fImage.getIconHeight()));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.setOpaque(false);
            graphics.drawImage(this.fImage.getImage(), 0, 0, null);
            super.paintComponent(graphics);
        }
    }

    private class TitlePanel
    extends MJPanel {
        public TitlePanel() {
            String string;
            String string2;
            MJLabel mJLabel;
            Icon icon;
            super((LayoutManager)new BorderLayout(5, 0));
            MJPanel mJPanel = new MJPanel();
            mJPanel.setLayout((LayoutManager)new FormLayout("p,2dlu,p:grow", "p,p,p,p"));
            CellConstraints cellConstraints = new CellConstraints();
            if (AppFileDetails.this.fIsTip) {
                mJPanel.setBackground(UIManager.getColor("ToolTip.background"));
                this.setBackground(UIManager.getColor("ToolTip.background"));
            }
            if ((icon = AppFileDetails.this.fData.getIcon()) != null) {
                mJLabel = new MJLabel(icon);
                mJPanel.add((Component)mJLabel, (Object)cellConstraints.xywh(1, 1, 1, 3));
                if (AppFileDetails.this.fIsTip) {
                    mJLabel.setBackground(UIManager.getColor("ToolTip.background"));
                }
            }
            if ((mJLabel = new HyperlinkTextLabel("<b>" + AppFileDetails.this.fData.getName() + "</b>", null)) != null) {
                mJPanel.add((Component)mJLabel.getComponent(), (Object)cellConstraints.xy(3, 1));
                if (AppFileDetails.this.fIsTip) {
                    mJLabel.getComponent().setBackground(UIManager.getColor("ToolTip.background"));
                }
            }
            if ((string2 = AppFileDetails.this.fData.getAuthorName()) != null && string2.length() > 0) {
                string = new MJLabel(sRes.getString("details.author.by") + ": " + string2);
                mJPanel.add((Component)((Object)string), (Object)cellConstraints.xy(3, 2));
                if (AppFileDetails.this.fIsTip) {
                    string.setBackground(UIManager.getColor("ToolTip.background"));
                }
            }
            this.add((Component)mJPanel, "North");
            string = AppFileDetails.this.fData.getSummary();
            if (string != null && string.length() > 0) {
                HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, new HyperlinkTextLabel.HyperlinkHandler(){

                    public void processHyperlink(String string) {
                        String string2 = "web('" + string + "')";
                        new Matlab().eval(string2, (MatlabListener)null);
                    }
                });
                if (AppFileDetails.this.fIsTip) {
                    hyperlinkTextLabel.getComponent().setBackground(UIManager.getColor("ToolTip.background"));
                }
                this.add(hyperlinkTextLabel.getComponent(), "South");
            }
        }
    }
}

