/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image;

import ice.debug.Debug;
import ice.pilots.image.ImageComponent;
import ice.pilots.image.ThePrinter;
import ice.storm.ContentLoader;
import ice.storm.LPilot;
import ice.storm.StormPrinter;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;

public class ThePilot
extends LPilot
implements ImageObserver {
    private static final Cursor OEAB = new Cursor(3);
    private static final Cursor Z = new Cursor(0);
    private Image append = null;
    private int arraycopy = -1;
    private int canAllocate = -1;
    private int class$ = 20;
    private int close = 20;
    private String createComponent;
    private ImageComponent createImage;
    private MemoryManager createPngImageProducer = null;
    static Class class$java$io$InputStream;

    public void init(String string) {
        super.init(string);
        this.createPngImageProducer = MemoryManager.getInstance();
        this.createComponent = string;
    }

    public Component createComponent() {
        block4: {
            String string = "ice.pilots.image." + this.createComponent + ".TheContainer";
            try {
                Object obj = Class.forName(string).newInstance();
                this.createImage = (ImageComponent)obj;
                this.createImage.init(this);
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (Debug.trace) {
                    Debug.trace((String)("Failed to create component: " + exception));
                }
                if (this.createComponent.equals("awt")) break block4;
                this.createComponent = "awt";
                this.createComponent();
            }
        }
        return (Component)((Object)this.createImage);
    }

    public StormPrinter createPrinter() {
        ThePrinter thePrinter = new ThePrinter(this);
        return thePrinter;
    }

    void flushImage() {
        if (this.append != null) {
            this.append.flush();
            this.append = null;
        }
    }

    public void clear(String string) {
        this.flushImage();
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        try {
            Object object;
            this.OEAB(OEAB);
            this.firePropertyChange("location", null, contentLoader.getLocation());
            this.firePropertyChange("title", null, contentLoader.getLocation());
            if ("image/png".equalsIgnoreCase(contentLoader.getContentType()) && (object = this.createPngImageProducer(contentLoader)) != null) {
                this.append = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            }
            if (this.append == null) {
                object = contentLoader.getInputStream();
                try {
                    if (!this.createPngImageProducer.canAllocate(16384)) {
                        throw new ICEException(1, 3, 2);
                    }
                    byte[] byArray = new byte[8192];
                    byte[] byArray2 = new byte[8192];
                    boolean bl = false;
                    int n = 0;
                    int n2 = 0;
                    while (!bl) {
                        n = ((InputStream)object).read(byArray);
                        if (n == -1) {
                            bl = true;
                            break;
                        }
                        if (byArray2.length - n2 > n) {
                            System.arraycopy(byArray, 0, byArray2, n2, n);
                            n2 += n;
                            continue;
                        }
                        int n3 = Math.max(byArray2.length * 2, byArray2.length + n);
                        if (!this.createPngImageProducer.canAllocate(n3)) {
                            byArray2 = null;
                            throw new ICEException(1, 3, 2);
                        }
                        byte[] byArray3 = new byte[n3];
                        System.arraycopy(byArray2, 0, byArray3, 0, n2);
                        byArray2 = byArray3;
                        System.arraycopy(byArray, 0, byArray2, n2, n);
                        n2 += n;
                    }
                    if (!this.createPngImageProducer.canAllocate(n2)) {
                        throw new ICEException(1, 3, 2);
                    }
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray2, 0, byArray4, 0, n2);
                    this.append = Toolkit.getDefaultToolkit().createImage(byArray4);
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    ((InputStream)object).close();
                    throw throwable;
                }
                ((InputStream)object).close();
                {
                }
            }
            if (this.append == null) {
                Object var13_16 = null;
                this.OEAB(Z);
                return;
            }
            Toolkit.getDefaultToolkit().prepareImage(this.append, -1, -1, this);
            int n = this.append.getWidth(this);
            int n4 = this.append.getHeight(this);
            if (n > 0) {
                this.class$ = n;
            }
            if (n4 > 0) {
                this.close = n4;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.OEAB(Z);
            throw throwable;
        }
        Object var13_17 = null;
        this.OEAB(Z);
    }

    public Image getImage() {
        return this.append;
    }

    public void dispose() {
        this.flushImage();
    }

    public int getWidth() {
        int n = this.getPilotViewport().getZoom();
        return this.class$ * n >> 8;
    }

    public int getHeight() {
        int n = this.getPilotViewport().getZoom();
        return this.close * n >> 8;
    }

    public void setSize(int n, int n2) {
        this.arraycopy = n;
        this.canAllocate = n2;
    }

    protected void setZoom(int n) {
        this.refreshViewport();
        if (this.createImage != null) {
            this.createImage.updateYourself();
        }
    }

    public void paint(Graphics graphics) {
        if (this.append != null) {
            int n = this.getPilotViewport().getZoom();
            if (this.arraycopy >= 0 && this.canAllocate >= 0) {
                graphics.drawImage(this.append, 0, 0, this.arraycopy, this.canAllocate, 0, 0, this.class$, this.close, this);
            } else if (n != 256) {
                int n2 = this.class$ * n >> 8;
                int n3 = this.close * n >> 8;
                graphics.drawImage(this.append, 0, 0, n2, n3, 0, 0, this.class$, this.close, this);
            } else {
                graphics.drawImage(this.append, 0, 0, this.class$, this.close, this);
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) != 0) {
            this.class$ = n4;
        }
        if ((n & 2) != 0) {
            this.close = n5;
        }
        if ((n & 0x33) != 0) {
            this.refreshViewport();
            if (this.createImage != null) {
                this.createImage.updateYourself();
            }
        }
        return (n & 0xE0) == 0;
    }

    ImageProducer createPngImageProducer(ContentLoader contentLoader) {
        ImageProducer imageProducer = null;
        try {
            Class<?> clazz = Class.forName("com.sixlegs.image.png.PngImage");
            Class[] classArray = new Class[]{class$java$io$InputStream == null ? (class$java$io$InputStream = ThePilot.class$("java.io.InputStream")) : class$java$io$InputStream};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{contentLoader.getInputStream()};
            imageProducer = (ImageProducer)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageProducer;
    }

    private void OEAB(Cursor cursor) {
        if (this.createImage != null) {
            this.createImage.setCursor(cursor);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

