/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dom.css.CSSStyleDeclarationImpl;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ParameterConstants;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.views.DocumentView;

public class TheView
implements ViewCSS,
ParameterConstants {
    private DDocument I;
    CSSLayout cssLayout;
    private final Vector OEAB = new Vector(5);

    TheView(DDocument dDocument, CSSLayout cSSLayout) {
        this.I = dDocument;
        this.cssLayout = cSSLayout;
    }

    public void reqReflow() {
        this.cssLayout.refresh();
    }

    public DocumentView getDocument() {
        return this.I;
    }

    public DocPane getDocPane() {
        return this.cssLayout.docPane;
    }

    public FocusManager getFocusManager() {
        return this.cssLayout.getFocusManager();
    }

    public int getWidth() {
        return this.cssLayout.getWidth();
    }

    public int getHeight() {
        return this.cssLayout.getHeight();
    }

    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        if (element == null) {
            throw new IllegalArgumentException("Computed Style element argument cannot be null");
        }
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl(this.I.getDom(), new DCSSRule(1, null, null), null);
        if ("left".equalsIgnoreCase(string)) {
            this.OEAB((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
        } else if ("top".equalsIgnoreCase(string)) {
            this.addElement((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
        } else if ("width".equalsIgnoreCase(string)) {
            this.append((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
        } else if ("height".equalsIgnoreCase(string)) {
            this.background_color((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
        } else if ("background-color".equalsIgnoreCase(string)) {
            this.contains((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
        } else if ("".equalsIgnoreCase(string)) {
            this.OEAB((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
            this.addElement((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
            this.append((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
            this.background_color((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
            this.contains((CSSStyleDeclaration)cSSStyleDeclarationImpl, (DNode)((Object)element));
        }
        return cSSStyleDeclarationImpl;
    }

    public void setZoom(int n) {
        this.cssLayout.setLayoutZoom(n);
    }

    public int getZoom() {
        return this.cssLayout.getLayoutZoom();
    }

    int getViewWidth() {
        return this.getDocPane().getPaneWidth();
    }

    int getViewHeight() {
        return this.getDocPane().getPaneHeight();
    }

    public void findBoundingBox(DNode dNode, Rectangle rectangle) {
        if (dNode.getNameId() == 6) {
            ((DAreaElement)dNode).findBoundingBox(rectangle);
            return;
        }
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox.findBoundingBox(rectangle);
        }
    }

    public ObjectPainter getNodePainter(DNode dNode) {
        ObjectBox objectBox;
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null && (objectBox = this.cssLayout.getWrappedObjectBoxOrNull(cSSBox)) != null) {
            return objectBox.getObjectPainter();
        }
        return null;
    }

    public static Object getToolkitComponent(DNode dNode) {
        ObjectPainter objectPainter;
        ThePilot thePilot = dNode.doc.getPilot();
        if (thePilot != null && (objectPainter = thePilot.getView().getNodePainter(dNode)) instanceof Component) {
            return objectPainter;
        }
        return null;
    }

    public ObjectPainter getNodeScroller(DNode dNode) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        while (cSSBox != null) {
            if (cSSBox instanceof ScrollBox) {
                ScrollBox scrollBox = (ScrollBox)cSSBox;
                ObjectBox objectBox = scrollBox.getObjectBox();
                return objectBox.getObjectPainter();
            }
            cSSBox = cSSBox.parentBox;
        }
        return null;
    }

    DElement getOffsetParent(DNode dNode) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox = cSSBox.parentBox;
            while (cSSBox != null) {
                DElement dElement = cSSBox.element;
                if (dElement == null) break;
                if (dElement != (DElement)dNode) {
                    if (cSSBox instanceof PositionedBox || dElement.tagId == 13) {
                        return dElement;
                    }
                    if (dElement.tagId == 79 || dElement.tagId == 81) {
                        return dElement;
                    }
                }
                cSSBox = cSSBox.parentBox;
            }
        }
        return null;
    }

    int getOffsetLeft(DNode dNode) {
        return this.I(dNode, true);
    }

    int getOffsetTop(DNode dNode) {
        return this.I(dNode, false);
    }

    private int I(DNode dNode, boolean bl) {
        int n = 0;
        Rectangle rectangle = new Rectangle();
        this.findBoundingBox2(dNode, rectangle);
        n = bl ? rectangle.x : rectangle.y;
        DElement dElement = this.getOffsetParent(dNode);
        if (dElement != null && dElement.tagId != 13) {
            this.findBoundingBox2(dElement, rectangle);
            n = bl ? (n -= rectangle.x) : (n -= rectangle.y);
        }
        return n;
    }

    void findBoundingBox2(DNode dNode, Rectangle rectangle) {
        if (dNode.getNameId() == 6) {
            ((DAreaElement)dNode).findBoundingBox(rectangle);
            return;
        }
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox.findBoundingBox(rectangle);
        } else {
            DocPaneXml docPaneXml;
            if (this.I.pilot.getStorm().isEventThread() && (docPaneXml = this.cssLayout.docPane) != null) {
                int n = docPaneXml.getPaneWidth();
                int n2 = docPaneXml.getPaneHeight();
                if (n > 0 && n2 > 0) {
                    this.cssLayout.layout(n, n2);
                    cSSBox = this.cssLayout.findCSSBox(dNode);
                    if (cSSBox != null) {
                        cSSBox.findBoundingBox(rectangle);
                        return;
                    }
                }
            }
            if (dNode.tagId == 13) {
                rectangle.width = this.getViewWidth();
                rectangle.height = this.getViewHeight();
            } else {
                rectangle.width = 108;
                rectangle.height = 24;
            }
        }
    }

    void updateFrameList() {
        DocPaneXml docPaneXml;
        if (this.I.pilot.getStorm().isEventThread() && !this.cssLayout.isLayoutValid() && (docPaneXml = this.cssLayout.docPane) != null) {
            int n = docPaneXml.getPaneWidth();
            int n2 = docPaneXml.getPaneHeight();
            if (n > 0 && n2 > 0) {
                this.cssLayout.layout(n, n2);
            }
        }
    }

    public void findPosition(DNode dNode, Point point) {
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null) {
            cSSBox.findAbsolutePosition(point);
        }
    }

    void processFocusCall(DElement dElement) {
        FocusManager focusManager;
        if (dElement.isFocusable() && (focusManager = this.getFocusManager()) != null) {
            focusManager.setFocusedBox(dElement);
        }
    }

    void processBlurCall(DNode dNode) {
        FocusManager focusManager = this.getFocusManager();
        if (focusManager != null) {
            focusManager.setFocusedBox(null);
        }
    }

    void processSelectCall(DNode dNode) {
        this.cssLayout.docPane.onNodeSelectCall(dNode);
    }

    void processClickCall(DNode dNode) {
        DOMEvent dOMEvent = this.I.createDOMEvent(1, dNode);
        if (!this.I.pilot.getStorm().isEventThread()) {
            this.I.processEventLater(dOMEvent, 0L);
        } else if (!this.OEAB.contains(dNode)) {
            this.OEAB.addElement(dNode);
            try {
                this.I.processEvent(dOMEvent);
                Object var4_3 = null;
                this.OEAB.removeElementAt(this.OEAB.size() - 1);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.OEAB.removeElementAt(this.OEAB.size() - 1);
                throw throwable;
            }
        }
    }

    private void OEAB(CSSStyleDeclaration cSSStyleDeclaration, DNode dNode) {
        int n = this.getOffsetLeft(dNode);
        cSSStyleDeclaration.setProperty("left", Integer.toString(n), "normal");
    }

    private void addElement(CSSStyleDeclaration cSSStyleDeclaration, DNode dNode) {
        int n = this.getOffsetTop(dNode);
        cSSStyleDeclaration.setProperty("top", Integer.toString(n), "normal");
    }

    private void append(CSSStyleDeclaration cSSStyleDeclaration, DNode dNode) {
        Rectangle rectangle = new Rectangle();
        this.findBoundingBox(dNode, rectangle);
        cSSStyleDeclaration.setProperty("width", Integer.toString(rectangle.width), "normal");
    }

    private void background_color(CSSStyleDeclaration cSSStyleDeclaration, DNode dNode) {
        Rectangle rectangle = new Rectangle();
        this.findBoundingBox(dNode, rectangle);
        cSSStyleDeclaration.setProperty("height", Integer.toString(rectangle.height), "normal");
    }

    private void contains(CSSStyleDeclaration cSSStyleDeclaration, DNode dNode) {
        Color color;
        CSSBox cSSBox = this.cssLayout.findCSSBox(dNode);
        if (cSSBox != null && (color = cSSBox.css.background_color) != null) {
            cSSStyleDeclaration.setProperty("background-color", "0x" + Integer.toHexString(color.getRGB()), "normal");
        }
    }
}

