/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import java.awt.Rectangle;

class FloatManager {
    private CSSBox B;
    private CSSBox OEAB;
    private CSSBox arraycopy;
    private Rectangle[] css;
    private Rectangle[] do_floats;
    private int height;
    private int next;
    private int ox;
    private int oy;
    private int y;
    private int pushLeftFloaters;
    private int pushRightFloaters;

    FloatManager(int n, int n2) {
        this.pushLeftFloaters = this.ox = n;
        this.pushRightFloaters = this.oy = n2;
    }

    void pushLeftFloaters(Rectangle rectangle) {
        if (this.css == null) {
            this.css = new Rectangle[10];
        } else if (this.css.length == this.height) {
            Rectangle[] rectangleArray = new Rectangle[this.css.length * 2];
            System.arraycopy(this.css, 0, rectangleArray, 0, this.height);
            this.css = rectangleArray;
        }
        this.css[this.height++] = rectangle;
    }

    void pushRightFloaters(Rectangle rectangle) {
        if (this.do_floats == null) {
            this.do_floats = new Rectangle[10];
        } else if (this.do_floats.length == this.next) {
            Rectangle[] rectangleArray = new Rectangle[this.do_floats.length * 2];
            System.arraycopy(this.do_floats, 0, rectangleArray, 0, this.next);
            this.do_floats = rectangleArray;
        }
        this.do_floats[this.next++] = rectangle;
    }

    int getAvailableX() {
        return this.pushLeftFloaters - this.ox;
    }

    int getAvailableWidth() {
        return this.pushRightFloaters - this.pushLeftFloaters;
    }

    void addFloater(CSSBox cSSBox) {
        if (this.arraycopy == null) {
            this.arraycopy = cSSBox;
        }
        if (this.B != null) {
            this.OEAB.next = cSSBox;
            cSSBox.next = null;
            this.OEAB = cSSBox;
        } else {
            this.B = this.OEAB = cSSBox;
            cSSBox.next = null;
        }
    }

    boolean containsNewFloaters() {
        return this.arraycopy != null;
    }

    boolean contains(CSSBox cSSBox) {
        CSSBox cSSBox2 = this.B;
        while (cSSBox2 != null) {
            if (cSSBox2 == cSSBox) {
                return true;
            }
            cSSBox2 = cSSBox2.next;
        }
        return false;
    }

    int clearLeft() {
        int n = this.y;
        while (this.height > 0) {
            Rectangle rectangle = this.css[this.height - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n) {
                n = rectangle.y + rectangle.height;
            }
            this.css[this.height - 1] = null;
            --this.height;
        }
        this.y += (n -= this.y);
        this.pushLeftFloaters = this.ox;
        return n;
    }

    int clearRight() {
        int n = this.y;
        while (this.next > 0) {
            Rectangle rectangle = this.do_floats[this.next - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n) {
                n = rectangle.y + rectangle.height;
            }
            this.do_floats[this.next - 1] = null;
            --this.next;
        }
        this.y += (n -= this.y);
        this.pushRightFloaters = this.oy;
        return n;
    }

    int skipTill(int n) {
        Rectangle rectangle;
        int n2 = this.y;
        while (this.height > 0) {
            rectangle = this.css[this.height - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n2) {
                n2 = rectangle.y + rectangle.height;
            }
            this.css[this.height - 1] = null;
            --this.height;
        }
        while (this.next > 0) {
            rectangle = this.do_floats[this.next - 1];
            if (rectangle != null && rectangle.y + rectangle.height > n2) {
                n2 = rectangle.y + rectangle.height;
            }
            this.do_floats[this.next - 1] = null;
            --this.next;
        }
        this.y += (n2 -= this.y);
        this.pushLeftFloaters = this.ox;
        this.pushRightFloaters = this.oy;
        return n2;
    }

    void advance(int n) {
        Rectangle rectangle;
        this.y += n;
        this.pushLeftFloaters = this.ox;
        this.pushRightFloaters = this.oy;
        while (this.height > 0) {
            rectangle = this.css[this.height - 1];
            if (rectangle != null && rectangle.y + rectangle.height > this.y) {
                this.pushLeftFloaters = rectangle.x + rectangle.width;
                break;
            }
            this.css[this.height - 1] = null;
            --this.height;
        }
        while (this.next > 0) {
            rectangle = this.do_floats[this.next - 1];
            if (rectangle != null && rectangle.y + rectangle.height > this.y) {
                this.pushRightFloaters = rectangle.x;
                break;
            }
            this.do_floats[this.next - 1] = null;
            --this.next;
        }
        if (this.arraycopy != null) {
            CSSBox cSSBox = this.arraycopy;
            while (cSSBox != null) {
                rectangle = new Rectangle(0, 0, cSSBox.width + cSSBox.ox * 2, cSSBox.height + cSSBox.oy * 2);
                if ((cSSBox.css.do_floats & 1) != 0) {
                    rectangle.x = this.pushLeftFloaters;
                    cSSBox.ox += rectangle.x;
                    this.pushLeftFloaters = rectangle.x + rectangle.width;
                    rectangle.y = this.y;
                    cSSBox.oy += this.y;
                    this.pushLeftFloaters(rectangle);
                } else if ((cSSBox.css.do_floats & 2) != 0) {
                    rectangle.x = this.pushRightFloaters - rectangle.width;
                    if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                    cSSBox.ox += rectangle.x;
                    this.pushRightFloaters = rectangle.x;
                    rectangle.y = this.y;
                    cSSBox.oy = this.y;
                    this.pushRightFloaters(rectangle);
                }
                cSSBox = cSSBox.next;
            }
            this.arraycopy = null;
        }
    }

    void translate(int n, int n2) {
        this.ox += n;
        this.oy += n2;
    }

    boolean hasActiveFloaters() {
        return this.height > 0 || this.next > 0;
    }

    CSSBox getFirstFloater() {
        return this.B;
    }
}

