/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.AbstractPositionSelector;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class ColorbarPositionControl
extends PropertyControl {
    protected ColorbarPositionSelector fSelector = new ColorbarPositionSelector();
    protected MJRadioButton fManualBtn = new MJRadioButton(PropertyEditorResources.getBundle().getString("ColorbarPositionControl.value.manual"));
    protected MJRadioButton fSelectorBtn = new MJRadioButton("Selector");
    protected ButtonGroup fButtonGroup = new ButtonGroup();
    private boolean forwardEventsToSelector = true;

    public ColorbarPositionControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.fSelector.setName(string2 + "." + string);
    }

    @Override
    public String getName() {
        if (this.fSelector != null) {
            return this.fSelector.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    private void constructorHelper() {
        this.fButtonGroup.add((AbstractButton)this.fManualBtn);
        this.fButtonGroup.add((AbstractButton)this.fSelectorBtn);
        this.fManualBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && ColorbarPositionControl.this.forwardEventsToSelector) {
                    ColorbarPositionControl.this.fSelector.setSelectedItem(ColorbarPositionControl.this.fSelector.valueFor("manual"));
                }
            }
        });
        Box box = Box.createHorizontalBox();
        box.add((Component)this.fManualBtn);
        box.add(Box.createVerticalGlue());
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.fSelector), (Object)"Center");
        mJPanel.add((Component)box, (Object)"South");
        this.setCustomEditor((JComponent)mJPanel);
        this.fSelector.setName(this.getPropertyName());
    }

    @Override
    public void addEditStoppedSupport() {
        this.fSelector.addActionListener(this.action);
    }

    @Override
    public void setDisplayedValue(Object object) {
        if (object == null) {
            return;
        }
        if (object == PropertyControl.MIXED_VALUES) {
            this.fSelector.setSelectedItemWithoutEvents(null);
        } else if (object.equals(this.fSelector.valueFor("manual"))) {
            this.fManualBtn.setSelected(true);
        } else {
            this.fSelectorBtn.setSelected(true);
            this.fSelector.setSelectedItemWithoutEvents(object);
        }
    }

    @Override
    public Object getDisplayedValue() {
        Object object = this.fSelector.getSelectedItem();
        return object;
    }

    class ColorbarPositionSelector
    extends AbstractPositionSelector {
        protected String[] valueMap = new String[]{"North", "South", "East", "West", "NorthOutside", "SouthOutside", "EastOutside", "WestOutside", "manual"};

        public ColorbarPositionSelector() {
            Dimension dimension = new Dimension(87, 10);
            Dimension dimension2 = new Dimension(47, 10);
            Dimension dimension3 = new Dimension(11, 54);
            Dimension dimension4 = new Dimension(11, 45);
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("northoutside"), this.valueFor("NorthOutside"), dimension, 28, 5));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("southoutside"), this.valueFor("SouthOutside"), dimension, 28, 77));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("westoutside"), this.valueFor("WestOutside"), dimension3, 13, 19));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("eastoutside"), this.valueFor("EastOutside"), dimension3, 120, 19));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("north"), this.valueFor("North"), dimension2, 48, 24));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("south"), this.valueFor("South"), dimension2, 48, 59));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("west"), this.valueFor("West"), dimension4, 33, 24));
            this.addRegion(new AbstractPositionSelector.SelectableRegion(this.getStr("east"), this.valueFor("East"), dimension4, 100, 24));
        }

        private String getStr(String string) {
            return PropertyEditorResources.getBundle().getString("ColorbarPositionControl.value." + string);
        }

        @Override
        public Dimension getOverallSize() {
            return new Dimension(145, 95);
        }

        @Override
        public Rectangle getOuterRect() {
            return new Rectangle(0, 0, 143, 92);
        }

        @Override
        public Rectangle getInnerRect() {
            return new Rectangle(28, 19, 87, 54);
        }

        protected Integer valueFor(String string) {
            if (string == null) {
                return new Integer(0);
            }
            for (int i = 0; i < this.valueMap.length; ++i) {
                if (!string.equals(this.valueMap[i])) continue;
                return new Integer(i);
            }
            return new Integer(0);
        }

        @Override
        protected void onValueChanged(Object object) {
            if (object == null) {
                return;
            }
            ColorbarPositionControl.this.forwardEventsToSelector = false;
            if (object.equals(this.valueFor("manual"))) {
                ColorbarPositionControl.this.fManualBtn.setSelected(true);
            } else {
                ColorbarPositionControl.this.fSelectorBtn.setSelected(true);
            }
            ColorbarPositionControl.this.forwardEventsToSelector = true;
        }
    }
}

