/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.plotbrowser;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.hg.types.HGPoint;
import com.mathworks.hg.types.HGPoint3;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.util.Log;
import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.util.HashMap;

public class MLPropertyTypeConverter {
    private static HashMap<PropertyClassPair, Property> sDataTypeLookupTable;

    private static void createDataTypeLookupTable() {
        if (sDataTypeLookupTable != null) {
            return;
        }
        sDataTypeLookupTable = new HashMap();
        sDataTypeLookupTable.put(new PropertyClassPair("xlim"), new Property("com.mathworks.hg.types.HGPoint", new HGPointConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("ylim"), new Property("com.mathworks.hg.types.HGPoint", new HGPointConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("zlim"), new Property("com.mathworks.hg.types.HGPoint", new HGPointConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("marker"), new Property("int", new MarkerConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("levelstepmode"), new Property("int", new AutoManualConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("linestyle"), new Property("int", new LineStyleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("color"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("xcolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("textcolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("textedgecolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("shadowcolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("highlightcolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("foregroundcolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("textbackgroundcolor"), new Property("com.mathworks.hg.types.HGColor", new HGColorConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("markerfacecolor"), new Property("com.mathworks.hg.types.HGMeshColor", new HGMeshColorConverter(1)));
        sDataTypeLookupTable.put(new PropertyClassPair("backgroundcolor"), new Property("com.mathworks.hg.types.HGMeshColor", new HGMeshColorConverter(1)));
        sDataTypeLookupTable.put(new PropertyClassPair("markeredgecolor"), new Property("com.mathworks.hg.types.HGMeshColor", new HGMeshColorConverter(1)));
        sDataTypeLookupTable.put(new PropertyClassPair("facecolor"), new Property("com.mathworks.hg.types.HGMeshColor", new HGMeshColorConverter(0)));
        sDataTypeLookupTable.put(new PropertyClassPair("edgecolor"), new Property("com.mathworks.hg.types.HGMeshColor", new HGMeshColorConverter(1)));
        sDataTypeLookupTable.put(new PropertyClassPair("linewidth"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("markersize"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("basevalue"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("markerfacecolor"), new Property("com.mathworks.hg.types.HGMeshColor", new HGMeshColorConverter(1)));
        sDataTypeLookupTable.put(new PropertyClassPair("barlayout"), new Property("int", new BarLayoutConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("barwidth"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("levelstep"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("string"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("xdatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("ydatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("zdatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("cdatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("udatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("vdatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("wdatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("colordatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("sizedatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("ldatasource"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("xdatamode"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("ydatamode"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("zdatamode"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("showbaseline"), new Property("boolean", new OnOffBooleanConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("showtext"), new Property("boolean", new OnOffBooleanConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("fill"), new Property("boolean", new OnOffBooleanConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("showarrowhead"), new Property("boolean", new OnOffBooleanConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("headstyle"), new Property("int", new ArrowHeadStyleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("headwidth"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("headlength"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("head1width"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("head1length"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("head2width"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("head2length"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("fontname"), new Property("String", new StringConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("fontsize"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("fontangle"), new Property("int", new IntEnumerationConverter(new String[]{"normal", "italic", "oblique"}, "normal")));
        sDataTypeLookupTable.put(new PropertyClassPair("fontweight"), new Property("int", new IntEnumerationConverter(new String[]{"light", "normal", "demi", "bold"}, "normal")));
        sDataTypeLookupTable.put(new PropertyClassPair("fontunits"), new Property("int", new IntEnumerationConverter(new String[]{"inches", "centimeters", "normalized", "points", "pixels"}, "normalized")));
        sDataTypeLookupTable.put(new PropertyClassPair("orientation"), new Property("int", new IntEnumerationConverter(new String[]{"horizontal", "vertical"}, "vertical")));
        sDataTypeLookupTable.put(new PropertyClassPair("location", "matlab_graphics_illustration_LegendBeanAdapter"), new Property("int", new IntEnumerationConverter(new String[]{"North", "South", "East", "West", "NorthEast", "SouthEast", "NorthWest", "SouthWest", "NorthOutside", "SouthOutside", "EastOutside", "WestOutside", "NorthEastOutside", "SouthEastOutside", "NorthWestOutside", "SouthWestOutside", "Best", "BestOutside", "none"}, "NorthEastOutside")));
        sDataTypeLookupTable.put(new PropertyClassPair("location", "matlab_graphics_illustration_ColorBarBeanAdapter"), new Property("int", new IntEnumerationConverter(new String[]{"North", "South", "East", "West", "NorthOutside", "SouthOutside", "EastOutside", "WestOutside", "manual"}, "EastOutside")));
        sDataTypeLookupTable.put(new PropertyClassPair("autoscalefactor"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("interpreter"), new Property("int", new IntEnumerationConverter(new String[]{"tex", "latex", "none"}, "tex")));
        sDataTypeLookupTable.put(new PropertyClassPair("horizontalalignment"), new Property("int", new IntEnumerationConverter(new String[]{"left", "center", "right"}, "left")));
        sDataTypeLookupTable.put(new PropertyClassPair("curvature"), new Property("double[]", new DoubleArrayConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("position"), new Property("com.mathworks.hg.types.HGPoint", new HGPoint3Converter()));
        sDataTypeLookupTable.put(new PropertyClassPair("style"), new Property("int", new IntEnumerationConverter(new String[]{"infinate", "local"}, "infinate")));
        sDataTypeLookupTable.put(new PropertyClassPair("colormap"), new Property("double[]", new DoubleArrayConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("numbertitle"), new Property("int", new OnOffIntConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("bordertype"), new Property("int", new IntEnumerationConverter(new String[]{"none", "etchedin", "etchedout", "beveledin", "beveledout", "line"}, "none")));
        sDataTypeLookupTable.put(new PropertyClassPair("borderwidth"), new Property("double", new DoubleConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("title"), new Property("double", new StringArrayConverter()));
        sDataTypeLookupTable.put(new PropertyClassPair("titleposition"), new Property("int", new IntEnumerationConverter(new String[]{"lefttop", "centertop", "righttop", "leftbottom", "centerbottom", "rightbottom"}, "lefttop")));
        sDataTypeLookupTable.put(new PropertyClassPair("style"), new Property("int", new IntEnumerationConverter(new String[]{"pushbutton", "togglebutton", "radiobutton", "checkbox", "edit", "text", "slider", "frame", "listbox", "popupmenu"}, "pushbutton")));
        sDataTypeLookupTable.put(new PropertyClassPair("xgrid"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
        sDataTypeLookupTable.put(new PropertyClassPair("ygrid"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
        sDataTypeLookupTable.put(new PropertyClassPair("zgrid"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
        sDataTypeLookupTable.put(new PropertyClassPair("box"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
        sDataTypeLookupTable.put(new PropertyClassPair("xscale"), new Property("int", new IntEnumerationConverter(new String[]{"linear", "log"}, "linear")));
        sDataTypeLookupTable.put(new PropertyClassPair("yscale"), new Property("int", new IntEnumerationConverter(new String[]{"linear", "log"}, "linear")));
        sDataTypeLookupTable.put(new PropertyClassPair("zscale"), new Property("int", new IntEnumerationConverter(new String[]{"linear", "log"}, "linear")));
        sDataTypeLookupTable.put(new PropertyClassPair("xdir"), new Property("int", new IntEnumerationConverter(new String[]{"normal", "reverse"}, "normal")));
        sDataTypeLookupTable.put(new PropertyClassPair("ydir"), new Property("int", new IntEnumerationConverter(new String[]{"normal", "reverse"}, "normal")));
        sDataTypeLookupTable.put(new PropertyClassPair("zdir"), new Property("int", new IntEnumerationConverter(new String[]{"normal", "reverse"}, "normal")));
        sDataTypeLookupTable.put(new PropertyClassPair("xlimmode"), new Property("int", new IntEnumerationConverter(new String[]{"manual", "auto"}, "auto")));
        sDataTypeLookupTable.put(new PropertyClassPair("ylimmode"), new Property("int", new IntEnumerationConverter(new String[]{"manual", "auto"}, "auto")));
        sDataTypeLookupTable.put(new PropertyClassPair("zlimmode"), new Property("int", new IntEnumerationConverter(new String[]{"manual", "auto"}, "auto")));
        sDataTypeLookupTable.put(new PropertyClassPair("xminortick"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
        sDataTypeLookupTable.put(new PropertyClassPair("yminortick"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
        sDataTypeLookupTable.put(new PropertyClassPair("zminortick"), new Property("int", new IntEnumerationConverter(new String[]{"off", "on"}, "off")));
    }

    public static boolean isSupportedProperty(String string, String string2) {
        MLPropertyTypeConverter.createDataTypeLookupTable();
        string2 = string2.replaceAll("[0-9]", "");
        return sDataTypeLookupTable.containsKey(new PropertyClassPair(string)) || sDataTypeLookupTable.containsKey(new PropertyClassPair(string, string2));
    }

    private static Property getSupportedProperty(String string, String string2) {
        if (sDataTypeLookupTable.containsKey(new PropertyClassPair(string))) {
            return sDataTypeLookupTable.get(new PropertyClassPair(string.toLowerCase()));
        }
        string2 = string2.replaceAll("[0-9]", "");
        return sDataTypeLookupTable.get(new PropertyClassPair(string.toLowerCase(), string2));
    }

    public static String lookupDataType(String string, String string2) {
        MLPropertyTypeConverter.createDataTypeLookupTable();
        Property property = MLPropertyTypeConverter.getSupportedProperty(string, string2);
        if (property != null) {
            return property.iDataType;
        }
        return null;
    }

    private static Property lookupProperty(String string, String string2) {
        MLPropertyTypeConverter.createDataTypeLookupTable();
        return MLPropertyTypeConverter.getSupportedProperty(string, string2);
    }

    public static void setProperty(Object object, Object object2, Object object3, PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getWriteMethod().getName().replaceAll("^set", "");
        MLPropertyTypeConverter.setProperty(object, object2, object3, string);
    }

    public static void setProperty(final Object object, final Object object2, final Object object3, final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (object3 == null) {
                    return;
                }
                String string2 = object.getClass().getName().replaceAll("[0-9]", "");
                Property property = MLPropertyTypeConverter.lookupProperty(string, string2);
                if (property == null) {
                    return;
                }
                if (object2 instanceof MLArrayRef && object3.equals(property.iPropertyConverter.matlabToJava(object2))) {
                    return;
                }
                if (object3.equals(object2)) {
                    return;
                }
                Object object4 = property.iPropertyConverter.javaToMATLAB(object3);
                if (object4 != null) {
                    try {
                        Matlab.mtFeval((String)"set", (Object[])new Object[]{object, string, object4}, (int)0);
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            }
        };
        if (MatlabEventQueue.isMatlabThread()) {
            runnable.run();
        } else {
            Matlab.whenMatlabIdle((Runnable)runnable);
        }
    }

    public static Object getProperty(Object object, PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getReadMethod().getName().replaceAll("^get", "");
        return MLPropertyTypeConverter.getProperty(object, string);
    }

    public static Object getProperty(Object object, String string) {
        try {
            Object object2 = Matlab.mtFeval((String)"get", (Object[])new Object[]{object, string}, (int)1);
            if (object2 instanceof MLArrayRef || object2 instanceof double[] || object2 instanceof String) {
                String string2 = object.getClass().getName().replaceAll("[0-9]", "");
                Property property = MLPropertyTypeConverter.lookupProperty(string, string2);
                if (property != null) {
                    return property.iPropertyConverter.matlabToJava(object2);
                }
                return object2;
            }
            return object2;
        }
        catch (Exception exception) {
            Log.log((String)exception.toString());
            return null;
        }
    }

    public static Object parseMLArrayRef(MLArrayRef mLArrayRef, PropertyDescriptor propertyDescriptor, String string) {
        String string2 = propertyDescriptor.getReadMethod().getName().replaceAll("^get", "");
        return MLPropertyTypeConverter.parseMLArrayRef(mLArrayRef, string2, string);
    }

    public static Object parseMLArrayRef(MLArrayRef mLArrayRef, String string, String string2) {
        Property property = MLPropertyTypeConverter.lookupProperty(string, string2);
        if (property != null) {
            return property.iPropertyConverter.matlabToJava(mLArrayRef);
        }
        return null;
    }

    private static int stringToLineStyle(String string) {
        if ("-".equals(string)) {
            return 0;
        }
        if ("--".equals(string)) {
            return 1;
        }
        if (":".equals(string)) {
            return 2;
        }
        if ("-.".equals(string)) {
            return 3;
        }
        return 4;
    }

    private static String lineStyleToString(int n) {
        switch (n) {
            case 4: {
                return "none";
            }
            case 0: {
                return "-";
            }
            case 1: {
                return "--";
            }
            case 2: {
                return ":";
            }
            case 3: {
                return "-.";
            }
        }
        return "";
    }

    private static String intToArrowHeadStyle(int n) {
        String[] stringArray = new String[]{"none", "plain", "ellipse", "vback1", "vback2", "vback3", "cback1", "cback2", "cback3", "fourstar", "rectangle", "diamond", "rose", "hypocycloid", "astroid", "deltoid"};
        if (n < stringArray.length) {
            return stringArray[n];
        }
        return null;
    }

    private static int stringToArrowHeadEnum(String string) {
        String[] stringArray = new String[]{"none", "plain", "ellipse", "vback1", "vback2", "vback3", "cback1", "cback2", "cback3", "fourstar", "rectangle", "diamond", "rose", "hypocycloid", "astroid", "deltoid"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static int stringToMarkerStyle(String string) {
        if ("+".equals(string)) {
            return 0;
        }
        if ("o".equals(string)) {
            return 1;
        }
        if ("*".equals(string)) {
            return 2;
        }
        if (".".equals(string)) {
            return 3;
        }
        if ("x".equals(string)) {
            return 4;
        }
        if ("square".equals(string)) {
            return 5;
        }
        if ("diamond".equals(string)) {
            return 6;
        }
        if ("v".equals(string)) {
            return 7;
        }
        if ("^".equals(string)) {
            return 8;
        }
        if (">".equals(string)) {
            return 9;
        }
        if ("<".equals(string)) {
            return 10;
        }
        if ("pentagram".equals(string)) {
            return 11;
        }
        if ("hexagram".equals(string)) {
            return 12;
        }
        return 13;
    }

    private static String markerStyleToString(int n) {
        switch (n) {
            case 0: {
                return "+";
            }
            case 1: {
                return "o";
            }
            case 2: {
                return "*";
            }
            case 3: {
                return ".";
            }
            case 4: {
                return "x";
            }
            case 5: {
                return "square";
            }
            case 6: {
                return "diamond";
            }
            case 7: {
                return "v";
            }
            case 8: {
                return "^";
            }
            case 9: {
                return ">";
            }
            case 10: {
                return "<";
            }
            case 11: {
                return "pentagram";
            }
            case 12: {
                return "hexagram";
            }
        }
        return "none";
    }

    private static String barLayoutToString(int n) {
        if (n == 0) {
            return "stacked";
        }
        return "grouped";
    }

    private static int stringToBarLayout(String string) {
        if ("stacked".equalsIgnoreCase(string)) {
            return 0;
        }
        return 1;
    }

    static int parseLineStyle(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        return (Integer)new LineStyleConverter().matlabToJava(mLArrayRef);
    }

    public static int parseMarker(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        return (Integer)new MarkerConverter().matlabToJava(mLArrayRef);
    }

    static boolean parseOnOff(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        return (Boolean)new OnOffBooleanConverter().matlabToJava(mLArrayRef);
    }

    static String parseString(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        return (String)new StringConverter().matlabToJava(mLArrayRef);
    }

    static Color parseColor(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        HGColor hGColor = (HGColor)new HGColorConverter().matlabToJava(mLArrayRef);
        return HGColor.getColor((HGColor)hGColor);
    }

    static Color parseAutoManColor(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        Object object = mLArrayRef.getData();
        if (object instanceof double[] && ((double[])object).length == 3) {
            double[] dArray = (double[])object;
            return new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        }
        return null;
    }

    static HGMeshColor parseHGMeshColor(MLArrayRef mLArrayRef, int n) {
        assert (NativeMatlab.nativeIsMatlabThread());
        return (HGMeshColor)new HGMeshColorConverter(n).matlabToJava(mLArrayRef);
    }

    static Double parseDouble(MLArrayRef mLArrayRef) {
        assert (NativeMatlab.nativeIsMatlabThread());
        return (Double)new DoubleConverter().matlabToJava(mLArrayRef);
    }

    private static class PropertyClassPair {
        private String iProperty = "";
        private String iClass;

        PropertyClassPair(String string, String string2) {
            assert (string != null);
            this.iProperty = string.toLowerCase();
            this.iClass = string2;
        }

        PropertyClassPair(String string) {
            assert (string != null);
            this.iProperty = string.toLowerCase();
        }

        void setPropertyName(String string) {
            assert (string != null);
            this.iProperty = string.toLowerCase();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PropertyClassPair)) {
                return false;
            }
            PropertyClassPair propertyClassPair = (PropertyClassPair)object;
            if (propertyClassPair.iClass == null && this.iClass == null) {
                return this.iProperty.equals(propertyClassPair.iProperty);
            }
            return this.iProperty.equals(propertyClassPair.iProperty) && this.iClass.equals(propertyClassPair.iClass);
        }

        public int hashCode() {
            if (this.iClass != null) {
                return this.iClass.hashCode() + 100 * this.iProperty.hashCode();
            }
            return 100 * this.iProperty.hashCode();
        }
    }

    private static class IntEnumerationConverter
    implements PropertyConverter {
        private String[] iStringVals;
        private String idefaultString;

        IntEnumerationConverter(String[] stringArray, String string) {
            this.iStringVals = stringArray;
            this.idefaultString = string;
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String)) {
                return 0;
            }
            for (int i = 0; i < this.iStringVals.length; ++i) {
                if (!this.iStringVals[i].equalsIgnoreCase((String)object2)) continue;
                return i;
            }
            return 0;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            int n;
            if (object instanceof Integer && (n = ((Integer)object).intValue()) < this.iStringVals.length) {
                return this.iStringVals[n];
            }
            return this.idefaultString;
        }
    }

    private static class ArrowHeadStyleConverter
    implements PropertyConverter {
        private ArrowHeadStyleConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String)) {
                return 0;
            }
            return MLPropertyTypeConverter.stringToArrowHeadEnum((String)object2);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof Integer) {
                return MLPropertyTypeConverter.intToArrowHeadStyle((Integer)object);
            }
            return "none";
        }
    }

    private static class HGPoint3Converter
    implements PropertyConverter {
        private HGPoint3Converter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof double[])) {
                return new HGPoint3(1.0, 0.0, 0.0);
            }
            double[] dArray = (double[])object2;
            return new HGPoint3(dArray[0], dArray[1], dArray[2]);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof HGPoint3) {
                return new double[]{((HGPoint3)object).getX(), ((HGPoint3)object).getY(), ((HGPoint3)object).getZ()};
            }
            return new double[]{1.0, 0.0, 0.0};
        }
    }

    private static class HGPointConverter
    implements PropertyConverter {
        private HGPointConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof double[])) {
                return new HGPoint(0.0, 1.0);
            }
            double[] dArray = (double[])object2;
            return new HGPoint(dArray[0], dArray[1]);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof HGPoint) {
                return new double[]{((HGPoint)object).getX(), ((HGPoint)object).getY()};
            }
            return new double[]{0.0, 1.0};
        }
    }

    private static class BarLayoutConverter
    implements PropertyConverter {
        private BarLayoutConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String)) {
                return 0;
            }
            return MLPropertyTypeConverter.stringToBarLayout((String)object2);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof Integer) {
                return MLPropertyTypeConverter.barLayoutToString((Integer)object);
            }
            return "stacked";
        }
    }

    private static class DoubleArrayConverter
    implements PropertyConverter {
        private DoubleArrayConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof double[])) {
                return null;
            }
            return object2;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            return object;
        }
    }

    private static class StringArrayConverter
    implements PropertyConverter {
        private StringArrayConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String[])) {
                return null;
            }
            return object2;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            return object;
        }
    }

    private static class StringConverter
    implements PropertyConverter {
        private StringConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String)) {
                return "";
            }
            return object2;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            return object;
        }
    }

    private static class AutoManualConverter
    implements PropertyConverter {
        private AutoManualConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            return "auto".equals(object2) ? 1 : 0;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (!(object instanceof Integer)) {
                return "manual";
            }
            Integer n = (Integer)object;
            if (n == 0) {
                return "manual";
            }
            return "auto";
        }
    }

    private static class OnOffIntConverter
    implements PropertyConverter {
        private OnOffIntConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            return "on".equals(object2) ? 1 : 0;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (!(object instanceof Integer)) {
                return "off";
            }
            Integer n = (Integer)object;
            if (n == 0) {
                return "off";
            }
            return "on";
        }
    }

    private static class OnOffBooleanConverter
    implements PropertyConverter {
        private OnOffBooleanConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            return "on".equals(object2) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (!(object instanceof Boolean)) {
                return "off";
            }
            Boolean bl = (Boolean)object;
            if (!bl.booleanValue()) {
                return "off";
            }
            return "on";
        }
    }

    private static class HGMeshColorConverter
    implements PropertyConverter {
        private int iStyles;

        public HGMeshColorConverter(int n) {
            this.iStyles = n;
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (object2 instanceof double[] && ((double[])object2).length == 3) {
                double[] dArray = (double[])object2;
                return new HGMeshColor(dArray[0], dArray[1], dArray[2], this.iStyles);
            }
            if (object2 instanceof String) {
                if ("auto".equals(object2)) {
                    return new HGMeshColor(4, this.iStyles);
                }
                if ("flat".equals(object2)) {
                    return new HGMeshColor(1, this.iStyles);
                }
                if ("interp".equals(object2)) {
                    return new HGMeshColor(2, this.iStyles);
                }
                if ("texturemap".equals(object2)) {
                    return new HGMeshColor(3, this.iStyles);
                }
                return new HGMeshColor(0, this.iStyles);
            }
            return new HGMeshColor(0, this.iStyles);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object == null || !(object instanceof HGMeshColor)) {
                return "none";
            }
            HGMeshColor hGMeshColor = (HGMeshColor)object;
            if (hGMeshColor.getStyle() == -1) {
                return new double[]{hGMeshColor.getRed(), hGMeshColor.getGreen(), hGMeshColor.getBlue()};
            }
            if (hGMeshColor.getStyle() == 4) {
                return "auto";
            }
            if (hGMeshColor.getStyle() == 1) {
                return "flat";
            }
            if (hGMeshColor.getStyle() == 2) {
                return "interp";
            }
            if (hGMeshColor.getStyle() == 0) {
                return "none";
            }
            return "none";
        }
    }

    private static class HGColorConverter
    implements PropertyConverter {
        private HGColorConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (object2 instanceof String) {
                String string = (String)object2;
                if (string.startsWith("y")) {
                    return new HGColor(1.0, 0.0, 1.0);
                }
                if (string.startsWith("m")) {
                    return new HGColor(1.0, 1.0, 0.0);
                }
                if (string.startsWith("c")) {
                    return new HGColor(1.0, 0.0, 1.0);
                }
                if (string.startsWith("r")) {
                    return new HGColor(1.0, 0.0, 0.0);
                }
                if (string.startsWith("g")) {
                    new HGColor(0.0, 1.0, 0.0);
                }
                if (string.startsWith("b")) {
                    return new HGColor(0.0, 0.0, 1.0);
                }
                if (string.startsWith("w")) {
                    return new HGColor(1.0, 1.0, 1.0);
                }
                return new HGColor(1.0, 1.0, 1.0);
            }
            if (!(object2 instanceof double[])) {
                return new HGColor(1.0, 1.0, 1.0);
            }
            double[] dArray = (double[])object2;
            if (dArray.length != 3) {
                return new HGColor(1.0, 1.0, 1.0);
            }
            return new HGColor(dArray[0], dArray[1], dArray[2]);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (!(object instanceof HGColor)) {
                return new double[]{0.0, 0.0, 0.0};
            }
            return new double[]{((HGColor)object).getRed(), ((HGColor)object).getGreen(), ((HGColor)object).getBlue()};
        }
    }

    private static class DoubleConverter
    implements PropertyConverter {
        private DoubleConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (object2 instanceof Double || object2 instanceof Float) {
                return object2;
            }
            if (object2 instanceof double[] && ((double[])object2).length == 1) {
                return ((double[])object2)[0];
            }
            return 0.0;
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof String) {
                try {
                    return Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (object instanceof Double || object instanceof Float) {
                return object;
            }
            return 0;
        }
    }

    private static class MarkerConverter
    implements PropertyConverter {
        private MarkerConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String)) {
                return 13;
            }
            return MLPropertyTypeConverter.stringToMarkerStyle((String)object2);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof Integer) {
                return MLPropertyTypeConverter.markerStyleToString((Integer)object);
            }
            return "none";
        }
    }

    private static class LineStyleConverter
    implements PropertyConverter {
        private LineStyleConverter() {
        }

        @Override
        public Object matlabToJava(Object object) {
            Object object2 = object instanceof MLArrayRef ? ((MLArrayRef)object).getData() : object;
            if (!(object2 instanceof String)) {
                return 4;
            }
            return MLPropertyTypeConverter.stringToLineStyle((String)object2);
        }

        @Override
        public Object javaToMATLAB(Object object) {
            if (object instanceof Integer) {
                return MLPropertyTypeConverter.lineStyleToString((Integer)object);
            }
            return "none";
        }
    }

    private static interface PropertyConverter {
        public Object matlabToJava(Object var1);

        public Object javaToMATLAB(Object var1);
    }

    private static class Property {
        private String iDataType;
        private PropertyConverter iPropertyConverter;

        Property(String string, PropertyConverter propertyConverter) {
            this.iDataType = string;
            this.iPropertyConverter = propertyConverter;
        }
    }
}

