/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlwidgets.graphics.PlotArgDescriptor;
import com.mathworks.mlwidgets.graphics.PlotCommandDescriptor;
import com.mathworks.mlwidgets.graphics.PlotMetadata;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceModel;
import com.mathworks.mlwidgets.workspace.WorkspaceFilter;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.MatlabSelectionEvent;
import com.mathworks.page.plottool.MatlabSelectionListener;
import com.mathworks.util.CategoricalVariable;
import com.mathworks.util.DebugUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SelectionManager {
    private final boolean DEBUG_SELECTION_FLAG = false;
    private volatile Object figure;
    private volatile Object figureHandle;
    private volatile Object figureHandleProxy = null;
    private volatile Component fCanvas;
    private volatile Object fPlotMgr;
    private static volatile Matlab matlab;
    private volatile Object[] selectedObjs = new Object[0];
    private final Hashtable customPanelObjsLookUp = new Hashtable();
    private volatile Vector allSelectedObjs = new Vector();
    private volatile boolean ignoreMatlabEvents = false;
    private volatile boolean deleted = false;
    private volatile int outstandingMatlabSelectionCount = 0;
    private volatile UDDListener fCloseListener;
    private final Runnable doInitialization = new Runnable(){

        @Override
        public void run() {
            SelectionManager.this.findFigureHandle();
            SelectionManager.this.findFigureCanvas();
            SelectionManager.this.findPlotManager();
            SelectionManager.this.addLsnrsToFigure();
            SelectionManager.this.addTempLsnrsToAxes();
            SelectionManager.this.setupMatlabFigureDnD();
        }
    };
    private volatile boolean fIsShowingTools = false;
    private final Vector listeners = new Vector();
    private final Runnable doFireEvents = new Runnable(){

        @Override
        public void run() {
            if (SelectionManager.this.deleted) {
                return;
            }
            SelectionManager.this.allSelectedObjs.clear();
            if (SelectionManager.this.selectedObjs != null) {
                for (int i = 0; i < SelectionManager.this.selectedObjs.length; ++i) {
                    SelectionManager.this.allSelectedObjs.add(SelectionManager.this.selectedObjs[i]);
                }
            }
            if (SelectionManager.this.figureHandleProxy != null && (SelectionManager.this.allSelectedObjs.size() == 0 || SelectionManager.this.allSelectedObjs.contains(SelectionManager.this.figureHandle))) {
                SelectionManager.this.allSelectedObjs.remove(SelectionManager.this.figureHandle);
                if (!SelectionManager.this.allSelectedObjs.contains(SelectionManager.this.figureHandleProxy)) {
                    SelectionManager.this.allSelectedObjs.add(SelectionManager.this.figureHandleProxy);
                }
            }
            SelectionManager.this.fireSelectionChanged((Vector)SelectionManager.this.allSelectedObjs.clone());
        }
    };
    private final MatlabListener plotCmdListener = new MatlabListener(){

        public void matlabEvent(MatlabEvent matlabEvent) {
            Object object = matlabEvent.getResult();
            if (object != null && object instanceof String && !((String)object).equals("") && ((String)object).indexOf("Warning") == -1) {
                JOptionPane.showMessageDialog(null, object, "MATLAB Plot Error", 0);
            }
        }
    };

    public static SelectionManager createSelectionManager(Object object) {
        SelectionManager selectionManager = new SelectionManager(object);
        matlab = new Matlab();
        if (Matlab.isMatlabAvailable()) {
            if (!SwingUtilities.isEventDispatchThread()) {
                selectionManager.doInitialization.run();
            } else {
                Matlab.whenMatlabReady((Runnable)selectionManager.doInitialization);
            }
        }
        return selectionManager;
    }

    private SelectionManager(Object object) {
        this.figure = object;
    }

    public Vector getSelectedObjects() {
        if (this.allSelectedObjs == null) {
            return new Vector();
        }
        return (Vector)this.allSelectedObjs.clone();
    }

    public Object getFigure() {
        return this.figure;
    }

    public Object getFigureHandle() {
        return this.figureHandle;
    }

    public Object getPlotManager() {
        return this.fPlotMgr;
    }

    public Component getFigureCanvas() {
        return this.fCanvas;
    }

    public void setFigureHandleProxy(Object object) {
        this.figureHandleProxy = object;
    }

    public boolean isShowingTools() {
        return this.fIsShowingTools;
    }

    public void setShowingTools(boolean bl) {
        this.fIsShowingTools = bl;
    }

    public void selectObjs(Vector vector) {
        Object[] objectArray;
        Object[] objectArray2;
        if (this.deleted) {
            return;
        }
        if (vector != null && vector.size() > 0) {
            objectArray2 = (Vector)vector.clone();
            objectArray = objectArray2.toArray();
        } else {
            objectArray = this.figure;
        }
        objectArray2 = objectArray;
        if (Matlab.isMatlabAvailable()) {
            ++this.outstandingMatlabSelectionCount;
            this.ignoreMatlabEvents = this.outstandingMatlabSelectionCount > 1;
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"setSelection", SelectionManager.this.figure, objectArray2}, (int)0);
                    }
                    catch (Exception exception) {
                        ErrorHandler.showMatlabError("selectObjs", matlab);
                        return;
                    }
                    SelectionManager.this.outstandingMatlabSelectionCount--;
                    SelectionManager.this.ignoreMatlabEvents = SelectionManager.this.outstandingMatlabSelectionCount > 1;
                }
            });
        }
    }

    public void addMatlabSelectionListener(final MatlabSelectionListener matlabSelectionListener) {
        if (this.listeners.contains(matlabSelectionListener)) {
            return;
        }
        this.listeners.add(matlabSelectionListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                matlabSelectionListener.selectionChanged(SelectionManager.this.createMatlabSelectionEvent(SelectionManager.this.allSelectedObjs));
            }
        });
    }

    public void removeMatlabSelectionListener(MatlabSelectionListener matlabSelectionListener) {
        if (!this.deleted && this.listeners.contains(matlabSelectionListener)) {
            this.listeners.remove(matlabSelectionListener);
        }
    }

    public void onScribeSelectionChanged(Object[] objectArray) {
        if (this.deleted) {
            return;
        }
        if (this.ignoreMatlabEvents) {
            return;
        }
        this.customPanelObjsLookUp.clear();
        this.selectedObjs = objectArray == null ? new Object[]{} : objectArray;
        SwingUtilities.invokeLater(this.doFireEvents);
    }

    public void onScribeSelectionChanged(Object[] objectArray, Object[] objectArray2) {
        if (this.deleted) {
            return;
        }
        if (this.ignoreMatlabEvents) {
            return;
        }
        this.customPanelObjsLookUp.clear();
        this.selectedObjs = objectArray == null ? new Object[]{} : objectArray;
        Object[] objectArray3 = objectArray2 == null ? new Object[]{} : objectArray2;
        int n = objectArray3.length < this.selectedObjs.length ? objectArray3.length : this.selectedObjs.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray3[i] == null || this.selectedObjs[i] == null) continue;
            this.customPanelObjsLookUp.put(this.selectedObjs[i], objectArray3[i]);
        }
        this.selectedObjs = objectArray;
        SwingUtilities.invokeLater(this.doFireEvents);
    }

    static void retargetSelectionManagerListeners(final Object object) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() {
                try {
                    if (object != null) {
                        Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"retargetSelectionManagerListeners", object}, (int)0);
                    } else {
                        Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"retargetSelectionManagerListeners"}, (int)0);
                    }
                }
                catch (Exception exception) {
                    Log.log((String)exception.toString());
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object2) {
            }
        };
        matlabWorker.start();
    }

    private void findFigureHandle() {
        try {
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"javaGetHandles", (Object[])new Object[]{this.figure}, (int)1);
            this.figureHandle = objectArray[0];
        }
        catch (Exception exception) {
            ErrorHandler.showMatlabError("findFigureHandle", matlab);
            return;
        }
        this.allSelectedObjs.add(this.figureHandle);
        this.fCloseListener = new UDDFigureBeingDestroyedListener((UDDObject)this.figureHandle);
    }

    private void findFigureCanvas() {
        try {
            Object object = Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getAxisComponent", this.figureHandle}, (int)1);
            this.fCanvas = (Component)object;
        }
        catch (Exception exception) {
            ErrorHandler.showMatlabError("findFigureCanvas", matlab);
            return;
        }
    }

    private void findPlotManager() {
        try {
            Object object;
            this.fPlotMgr = object = Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getPlotManager"}, (int)1);
        }
        catch (Exception exception) {
            ErrorHandler.showMatlabError("findPlotManager", matlab);
            return;
        }
    }

    private void addLsnrsToFigure() {
        try {
            Matlab.mtFeval((String)"javaAddLsnrsToFigure", (Object[])new Object[]{this.figure, this}, (int)0);
        }
        catch (Exception exception) {
            ErrorHandler.showMatlabError("addLsnrsToFigure", matlab);
            return;
        }
    }

    private void addTempLsnrsToAxes() {
        try {
            Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"addFigureSelectionManagerListeners", this.figureHandle, this}, (int)1);
        }
        catch (Exception exception) {
            ErrorHandler.showMatlabError("addTempLsnrsToAxes: " + exception.toString(), matlab);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSelectionChanged(Vector vector) {
        if (this.deleted) {
            return;
        }
        if (this.listeners == null) {
            return;
        }
        MatlabSelectionEvent matlabSelectionEvent = this.createMatlabSelectionEvent(vector);
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                MatlabSelectionListener matlabSelectionListener = (MatlabSelectionListener)this.listeners.get(i);
                if (matlabSelectionListener == null) continue;
                matlabSelectionListener.selectionChanged(matlabSelectionEvent);
            }
        }
    }

    public MatlabSelectionEvent createMatlabSelectionEvent(Vector vector) {
        if (this.customPanelObjsLookUp.isEmpty()) {
            return new MatlabSelectionEvent(this, vector);
        }
        Vector vector2 = (Vector)vector.clone();
        for (int i = 0; i < vector2.size(); ++i) {
            vector2.set(i, this.customPanelObjsLookUp.get(vector.elementAt(i)));
        }
        return new MatlabSelectionEvent(this, vector, vector2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.fCloseListener != null) {
                this.fCloseListener.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void setupMatlabFigureDnD() {
        new DropTarget(this.fCanvas, new DropListener());
    }

    private boolean checkForPlottability(SimpleVariableDefinition[] simpleVariableDefinitionArray) {
        boolean bl = false;
        MatlabWorkspaceModel matlabWorkspaceModel = new MatlabWorkspaceModel();
        int n = matlabWorkspaceModel.CLASS();
        int n2 = matlabWorkspaceModel.getRecordCount();
        for (int i = 0; i < n2; ++i) {
            String string = (String)matlabWorkspaceModel.getValueAt(i, 0);
            for (int j = 0; j < simpleVariableDefinitionArray.length; ++j) {
                String string2 = simpleVariableDefinitionArray[j].getVariable();
                if (!string2.equals(string)) continue;
                String string3 = (String)matlabWorkspaceModel.getValueAt(i, n);
                if (!WorkspaceFilter.getNumericFilter().accept((Object)string3) && !WorkspaceFilter.getLogicalFilter().accept((Object)string3)) continue;
                bl = true;
            }
        }
        matlabWorkspaceModel.unregisterInterests();
        matlabWorkspaceModel = null;
        return bl;
    }

    private int getDimsForVar(String string) {
        int n = 1;
        MatlabWorkspaceModel matlabWorkspaceModel = new MatlabWorkspaceModel();
        int n2 = matlabWorkspaceModel.getRecordCount();
        int n3 = matlabWorkspaceModel.SIZE();
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)matlabWorkspaceModel.getValueAt(i, 0);
            if (!string2.equals(string)) continue;
            String string3 = (String)matlabWorkspaceModel.getValueAt(i, n3);
            n = WorkspaceFilter.get2DFilter().accept((Object)string3) ? 2 : (WorkspaceFilter.getRowFilter().accept((Object)string3) || WorkspaceFilter.getColumnFilter().accept((Object)string3) ? 1 : 0);
        }
        matlabWorkspaceModel.unregisterInterests();
        matlabWorkspaceModel = null;
        return n;
    }

    public void updateSelectedObjectArray(Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        if (objectArray == null || objectArray.length == 0) {
            this.selectedObjs = new Object[0];
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block0: for (int i = 0; i < this.selectedObjs.length; ++i) {
            for (Object object : objectArray) {
                if (object == null || !object.equals(this.selectedObjs[i])) continue;
                arrayList.add(object);
                continue block0;
            }
        }
        this.selectedObjs = arrayList.toArray(new Object[0]);
    }

    public void purgeSelectedObjectArray(Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        for (Object object : objectArray) {
            this.selectedObjs = this.purgeObjectFromArray(object, this.selectedObjs);
        }
    }

    private Object[] purgeObjectFromArray(Object object, Object[] objectArray) {
        int n;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        for (n = 0; n < objectArray.length; ++n) {
            if (!objectArray[n].equals(object)) continue;
            bl = true;
            break;
        }
        if (bl) {
            objectArray2 = new Object[objectArray.length - 1];
            n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    objectArray2[n] = null;
                    continue;
                }
                if (objectArray[i].equals(object)) continue;
                objectArray2[n] = objectArray[i];
                ++n;
            }
        }
        return objectArray2;
    }

    static /* synthetic */ Object[] access$1202(SelectionManager selectionManager, Object[] objectArray) {
        selectionManager.selectedObjs = objectArray;
        return objectArray;
    }

    class DropListener
    implements DropTargetListener {
        DropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            SimpleVariableDefinition[] simpleVariableDefinitionArray;
            if (!dropTargetDropEvent.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                simpleVariableDefinitionArray = MLDataFlavor.decodeSimpleVariableListFlavor((Transferable)transferable);
            }
            catch (Exception exception) {
                ErrorHandler.showJavaException("SelectionManager.DropListener.drop", exception);
                return;
            }
            if (!SelectionManager.this.checkForPlottability(simpleVariableDefinitionArray)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            if (simpleVariableDefinitionArray.length > 0) {
                PlotCommandDescriptor[] plotCommandDescriptorArray;
                Vector<PlotArgDescriptor> vector = new Vector<PlotArgDescriptor>();
                for (int i = 0; i < simpleVariableDefinitionArray.length; ++i) {
                    plotCommandDescriptorArray = simpleVariableDefinitionArray[i].getVariable();
                    int n = SelectionManager.this.getDimsForVar((String)plotCommandDescriptorArray);
                    vector.add(new PlotArgDescriptor((String)plotCommandDescriptorArray, new int[]{n}));
                }
                if (vector.size() == 0) {
                    return;
                }
                Object[] objectArray = new PlotArgDescriptor[vector.size()];
                vector.copyInto(objectArray);
                plotCommandDescriptorArray = PlotMetadata.possibleCommandsForData((PlotArgDescriptor[])objectArray);
                if (plotCommandDescriptorArray.length == 0) {
                    return;
                }
                Point point = dropTargetDropEvent.getLocation();
                double[] dArray = new double[]{point.x, point.y};
                dropTargetDropEvent.dropComplete(true);
                matlab.feval("plottoolfunc", new Object[]{"prepareAxesForDnD", SelectionManager.this.figureHandle, dArray}, 2, new MatlabListener(){

                    public void matlabEvent(MatlabEvent matlabEvent) {
                        Object[] objectArray = (Object[])matlabEvent.getResult();
                        boolean bl = ((boolean[])objectArray[1])[0];
                        String string = null;
                        if (bl) {
                            for (int i = 0; i < plotCommandDescriptorArray.length; ++i) {
                                if (!plotCommandDescriptorArray[i].getType().equals(PlotCommandDescriptor.SURF)) continue;
                                string = plotCommandDescriptorArray[i].getMatlabCmd();
                                break;
                            }
                        }
                        if (string == null) {
                            string = plotCommandDescriptorArray[0].getMatlabCmd();
                        }
                        final String string2 = string;
                        MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Void>(){

                            public Void call() throws Exception {
                                block7: {
                                    try {
                                        assert (SelectionManager.this.figureHandle instanceof UDDObject) : SelectionManager.access$1400(SelectionManager.this) != null ? SelectionManager.access$1400(SelectionManager.this).getClass().getName() : "null";
                                        UDDObject uDDObject = (UDDObject)SelectionManager.this.figureHandle;
                                        assert (uDDObject.isValid());
                                        Object object = uDDObject.getPropertyValue("HandleVisibility");
                                        assert (object != null);
                                        if (object instanceof CategoricalVariable) {
                                            CategoricalVariable categoricalVariable = (CategoricalVariable)object;
                                            Object object2 = categoricalVariable.findValueByLabel("on");
                                            categoricalVariable.setValue(object2);
                                            uDDObject.setPropertyValue("HandleVisibility", object);
                                        } else {
                                            uDDObject.setPropertyValue("HandleVisibility", (Object)0);
                                        }
                                        MatlabMCR.mtEval((String)string2);
                                        uDDObject.setPropertyValue("HandleVisibility", object);
                                    }
                                    catch (Exception exception) {
                                        if ($assertionsDisabled || DebugUtils.warning((String)exception.getMessage())) break block7;
                                        throw new AssertionError();
                                    }
                                }
                                return null;
                            }

                            public void callOnEdt(Void void_, boolean bl) {
                            }
                        });
                    }
                });
            }
        }
    }

    class UDDFigureBeingDestroyedListener
    extends UDDListener {
        UDDFigureBeingDestroyedListener(UDDObject uDDObject) {
            super(uDDObject, uDDObject, "ObjectBeingDestroyed", true);
        }

        public synchronized void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            SelectionManager.this.deleted = true;
            SelectionManager.this.figure = null;
            SelectionManager.this.figureHandle = null;
            SelectionManager.matlab = null;
            SelectionManager.access$1202(SelectionManager.this, new Object[0]);
            SelectionManager.this.allSelectedObjs = null;
            SelectionManager.this.listeners.clear();
            if (SelectionManager.this.fCanvas != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectionManager.this.fCanvas.setDropTarget(null);
                        SelectionManager.this.fCanvas = null;
                    }
                });
            }
        }
    }
}

