/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.page.plottool.AbstractPlotTool;
import com.mathworks.page.plottool.figurepalette.AbstractPalettePage;
import com.mathworks.page.plottool.figurepalette.AxesPalettePage;
import com.mathworks.page.plottool.figurepalette.FigurePaletteResources;
import com.mathworks.page.plottool.figurepalette.ScribePalettePage;
import com.mathworks.page.plottool.figurepalette.VarsPalettePage;
import com.mathworks.widgets.ClosablePanelContainer;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FigurePalette
extends AbstractPlotTool {
    protected static String NAME = "Figure Palette";
    private final ClosablePanelContainer fCPContainer = new ClosablePanelContainer();
    private final Vector fAbstractPalettePages = new Vector();

    public FigurePalette() {
        this.constructorHelper();
    }

    public FigurePalette(SimpleElement simpleElement) {
        super(simpleElement);
        this.constructorHelper();
    }

    public FigurePalette(String string, Desktop desktop) {
        super(string, desktop);
        this.constructorHelper();
    }

    public static Component addAsDesktopClient(final Desktop desktop, final String string) {
        final AtomicReference atomicReference = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread()) {
            return FigurePalette.utAddAsDesktopClient(desktop, string);
        }
        Runnable runnable = new Runnable(){
            public Object iReturnObj;

            @Override
            public void run() {
                atomicReference.set(FigurePalette.utAddAsDesktopClient(desktop, string));
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
            return (Component)atomicReference.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Component utAddAsDesktopClient(Desktop desktop, String string) {
        assert (SwingUtilities.isEventDispatchThread());
        Object object = desktop.getClient("Figure Palette", string);
        if (object == null) {
            object = new FigurePalette(string, desktop);
            desktop.addClient(object, "Figure Palette", false, DTLocation.create((String)"NW"), false);
        }
        return object;
    }

    private void constructorHelper() {
        this.setName(NAME);
        this.setClientName(NAME);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fCPContainer, "Center");
        AxesPalettePage axesPalettePage = new AxesPalettePage();
        VarsPalettePage varsPalettePage = new VarsPalettePage();
        ScribePalettePage scribePalettePage = new ScribePalettePage();
        this.fAbstractPalettePages.add(axesPalettePage);
        this.fAbstractPalettePages.add(varsPalettePage);
        this.fAbstractPalettePages.add(scribePalettePage);
        this.addPanel("Axes", FigurePaletteResources.getBundle().getString("axes.title"), (JComponent)((Object)axesPalettePage));
        this.addPanel("Variables", FigurePaletteResources.getBundle().getString("variables.title"), (JComponent)((Object)varsPalettePage));
        this.addPanel("Annotations", FigurePaletteResources.getBundle().getString("annotations.title"), (JComponent)((Object)scribePalettePage));
        this.setEnabled(false);
    }

    @Override
    protected void respondToNullFigure() {
        this.setEnabled(false);
        this.fCPContainer.setPanelVisible("Axes", true);
        this.fCPContainer.setPanelVisible("Variables", true);
    }

    @Override
    protected void respondToDifferentFigure() {
        int n;
        this.setEnabled(true);
        for (n = 0; n < this.fAbstractPalettePages.size(); ++n) {
            AbstractPalettePage abstractPalettePage = (AbstractPalettePage)((Object)this.fAbstractPalettePages.get(n));
            abstractPalettePage.setFigureObjects(this.fFigure, this.fSelectionMgr);
        }
        n = this.getFigureHandleVisibility() ? 1 : 0;
        SwingUtilities.invokeLater(new Runnable(n != 0){
            final /* synthetic */ boolean val$isFigureHandleVisible;
            {
                this.val$isFigureHandleVisible = bl;
            }

            @Override
            public void run() {
                FigurePalette.this.fCPContainer.setPanelVisible("Axes", this.val$isFigureHandleVisible);
                FigurePalette.this.fCPContainer.setPanelVisible("Variables", this.val$isFigureHandleVisible);
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.fCPContainer.setEnabled(bl);
    }

    public void setVisible(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setVisible(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FigurePalette.super.setVisible(bl);
                }
            });
        }
    }

    public void addPanel(String string, String string2, JComponent jComponent) {
        this.fCPContainer.addPanel(string, string2, jComponent);
        if (jComponent instanceof AbstractPalettePage) {
            this.fAbstractPalettePages.add(jComponent);
        }
    }

    public static ImageIcon makeImage(String string) {
        return new ImageIcon(FigurePalette.class.getResource("resources/" + string));
    }
}

