/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.export;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.export.PrintExportPanel;
import com.mathworks.page.export.PrintExportSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PreviewTabLines
extends MJPanel
implements ActionListener,
PropertyChangeListener {
    private PrintExportSettings fPrintSettings;
    private String[] fFontNames;
    private String fDefaultFontName;
    private String[] fLocalFontWeights;
    private String[] fLocalFontAngles;
    private static final String NONE_HG = "none";
    private static final String NONE_I18N = PrintExportPanel.sResHandle.getString("none");
    private MJRadioButton fRadLineWidthScreen;
    private MJRadioButton fRadLineWidthScale;
    private MJRadioButton fRadLineWidthFixed;
    private MJTextField fTextLineWidthScale;
    private MJTextField fTextLineWidthFixed;
    private PPDefaultCustom fWidgetMinLineWidth;
    private MJRadioButton fRadFontSizeScreen;
    private MJRadioButton fRadFontSizeScale;
    private MJRadioButton fRadFontSizeFixed;
    private MJTextField fTextFontSizeScale;
    private MJComboBox fTextFontSizeFixed;
    private MJComboBox fComboFontAngle;
    private MJComboBox fComboFontWeight;
    private PPDefaultCustomFontName fWidgetFontName;
    private MJTextField fTxtHeader;
    private MJComboBox fComboDateStyle;
    private MJButton fBtnFont;

    public PreviewTabLines(PrintExportSettings printExportSettings, String[] stringArray, String string) {
        this.fPrintSettings = printExportSettings;
        this.fPrintSettings.addPropertyChangeListener(this);
        this.fFontNames = stringArray;
        this.fDefaultFontName = string;
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PreviewTabLines.this.createUI();
                }
            };
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
        } else {
            this.createUI();
        }
    }

    private void createUI() {
        int n;
        this.setLayout(new GridBagLayout());
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.gbLines")));
        int n2 = 0;
        this.add((Component)mJPanel, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 6, 3, 6), 0, 0));
        MJLabel mJLabel = new MJLabel(PrintExportPanel.sResHandle.getString("line.customwidth"));
        MJLabel mJLabel2 = new MJLabel(PrintExportPanel.sResHandle.getString("line.minwidth"));
        this.fRadLineWidthScreen = new MJRadioButton(PrintExportPanel.sResHandle.getString("style.default"));
        this.fRadLineWidthScreen.setName("RadBtn_LineWidthDefault");
        this.fRadLineWidthScale = new MJRadioButton(PrintExportPanel.sResHandle.getString("line.scale"));
        this.fRadLineWidthScale.setName("RadBtn_LineWidthScale");
        this.fRadLineWidthFixed = new MJRadioButton(PrintExportPanel.sResHandle.getString("line.fixedwidth"));
        this.fRadLineWidthFixed.setName("RadBtn_LineWidthFixed");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRadLineWidthScreen);
        buttonGroup.add((AbstractButton)this.fRadLineWidthScale);
        buttonGroup.add((AbstractButton)this.fRadLineWidthFixed);
        this.fTextLineWidthScale = new MJTextField("100");
        this.fTextLineWidthScale.setName("Text_LineWidthScale");
        this.fTextLineWidthScale.setColumns(4);
        this.fTextLineWidthFixed = new MJTextField("0.5");
        this.fTextLineWidthFixed.setName("Text_LineWidthFixed");
        this.fTextLineWidthFixed.setColumns(4);
        this.fRadLineWidthScreen.addActionListener((ActionListener)this);
        this.fRadLineWidthScale.addActionListener((ActionListener)this);
        this.fRadLineWidthFixed.addActionListener((ActionListener)this);
        this.fTextLineWidthScale.addActionListener((ActionListener)this);
        this.fTextLineWidthScale.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PreviewTabLines.this.onLineWidthChanged();
            }
        });
        this.fTextLineWidthFixed.addActionListener((ActionListener)this);
        this.fTextLineWidthFixed.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PreviewTabLines.this.onLineWidthChanged();
            }
        });
        this.fWidgetMinLineWidth = new PPDefaultCustom();
        this.fWidgetMinLineWidth.addSubcomponentFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PreviewTabLines.this.onLineMinWidthChanged();
            }
        });
        this.fWidgetMinLineWidth.setName("Widget_MinLineWidth");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel2.add((Component)this.fRadLineWidthScreen, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)this.fRadLineWidthScale, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)this.fTextLineWidthScale, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)new MJLabel(PrintExportPanel.sResHandle.getString("label.percent")), (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)this.fRadLineWidthFixed, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)this.fTextLineWidthFixed, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel2.add((Component)new MJLabel(PrintExportPanel.sResHandle.getString("label.points")), (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel.add((Component)mJLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 3), 0, 0));
        mJPanel.add((Component)mJPanel2, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 6, 0), 0, 0));
        mJPanel.add((Component)mJLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 0), 0, 0));
        mJPanel.add((Component)((Object)this.fWidgetMinLineWidth), (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel3.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.gbText")));
        this.add((Component)mJPanel3, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 6, 3, 6), 0, 0));
        MJLabel mJLabel3 = new MJLabel(PrintExportPanel.sResHandle.getString("text.fontname"));
        MJLabel mJLabel4 = new MJLabel(PrintExportPanel.sResHandle.getString("text.fontsize"));
        MJLabel mJLabel5 = new MJLabel(PrintExportPanel.sResHandle.getString("text.fontweight"));
        MJLabel mJLabel6 = new MJLabel(PrintExportPanel.sResHandle.getString("text.fontangle"));
        this.fWidgetFontName = new PPDefaultCustomFontName(this.fFontNames, this.fDefaultFontName);
        this.fWidgetFontName.setName("Widget_FontName");
        this.fRadFontSizeScreen = new MJRadioButton(PrintExportPanel.sResHandle.getString("style.default"));
        this.fRadFontSizeScreen.setName("RadBtn_FontSizeDefault");
        this.fRadFontSizeScale = new MJRadioButton(PrintExportPanel.sResHandle.getString("line.scale"));
        this.fRadFontSizeScale.setName("RadBtn_FontSizeScale");
        this.fRadFontSizeFixed = new MJRadioButton(PrintExportPanel.sResHandle.getString("line.fixedwidth"));
        this.fRadFontSizeFixed.setName("RadBtn_FontSizeFixed");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add((AbstractButton)this.fRadFontSizeScreen);
        buttonGroup2.add((AbstractButton)this.fRadFontSizeScale);
        buttonGroup2.add((AbstractButton)this.fRadFontSizeFixed);
        this.fTextFontSizeScale = new MJTextField("100");
        this.fTextFontSizeScale.setName("Text_FontSizeScale");
        this.fTextFontSizeScale.setColumns(4);
        Object[] objectArray = new String[]{"8", "9", "10", "12", "14", "18", "24", "26", "48"};
        this.fTextFontSizeFixed = new MJComboBox(objectArray);
        this.fTextFontSizeFixed.setName("Text_FontSizeFixed");
        this.fTextFontSizeFixed.setSelectedIndex(2);
        this.fTextFontSizeFixed.setEditorColumnCount(4);
        this.fTextFontSizeFixed.setEditable(true);
        this.fComboFontAngle = new MJComboBox();
        this.fComboFontAngle.setName("Combo_FontAngle");
        this.fComboFontAngle.addItem((Object)PrintExportPanel.sResHandle.getString("style.default"));
        int n3 = PrintExportSettings.MATLAB_FONTANGLES.length;
        this.fLocalFontAngles = new String[n3];
        for (n = 0; n < n3; ++n) {
            this.fLocalFontAngles[n] = PrintExportPanel.sResHandle.getString(PrintExportSettings.MATLAB_FONTANGLES[n]);
            this.fComboFontAngle.addItem((Object)this.fLocalFontAngles[n]);
        }
        this.fComboFontWeight = new MJComboBox();
        this.fComboFontWeight.setName("Combo_FontWeight");
        this.fComboFontWeight.addItem((Object)PrintExportPanel.sResHandle.getString("style.default"));
        n = PrintExportSettings.MATLAB_FONTWEIGHTS.length;
        this.fLocalFontWeights = new String[n];
        for (int i = 0; i < n; ++i) {
            this.fLocalFontWeights[i] = PrintExportPanel.sResHandle.getString(PrintExportSettings.MATLAB_FONTWEIGHTS[i]);
            this.fComboFontWeight.addItem((Object)this.fLocalFontWeights[i]);
        }
        this.fComboFontWeight.setEditorColumnCount(10);
        this.fWidgetFontName.addActionListener(this);
        this.fRadFontSizeScreen.addActionListener((ActionListener)this);
        this.fRadFontSizeScale.addActionListener((ActionListener)this);
        this.fRadFontSizeFixed.addActionListener((ActionListener)this);
        this.fTextFontSizeScale.addActionListener((ActionListener)this);
        this.fTextFontSizeFixed.addActionListener((ActionListener)this);
        this.fTextFontSizeScale.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PreviewTabLines.this.onFontSizeChanged();
            }
        });
        this.fComboFontAngle.addActionListener((ActionListener)this);
        this.fComboFontWeight.addActionListener((ActionListener)this);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel4.add((Component)this.fRadFontSizeScreen, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel4.add((Component)this.fRadFontSizeScale, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel4.add((Component)this.fTextFontSizeScale, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel4.add((Component)new MJLabel(PrintExportPanel.sResHandle.getString("label.percent")), (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel4.add((Component)this.fRadFontSizeFixed, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel4.add((Component)this.fTextFontSizeFixed, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel4.add((Component)new MJLabel(PrintExportPanel.sResHandle.getString("label.points")), (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel3.add((Component)mJLabel3, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 0), 0, 0));
        mJPanel3.add((Component)((Object)this.fWidgetFontName), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 0), 0, 0));
        mJPanel3.add((Component)mJLabel4, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 0), 0, 0));
        mJPanel3.add((Component)mJPanel4, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 6, 0), 0, 0));
        mJPanel3.add((Component)mJLabel5, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 0), 0, 0));
        mJPanel3.add((Component)this.fComboFontWeight, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel3.add((Component)mJLabel6, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 3, 0, 0), 0, 0));
        mJPanel3.add((Component)this.fComboFontAngle, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel5.setBorder((Border)new TitledBorder(PrintExportPanel.sResHandle.getString("groupbox.header")));
        this.add((Component)mJPanel5, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 3, 6), 0, 0));
        MJLabel mJLabel7 = new MJLabel(PrintExportPanel.sResHandle.getString("label.headertext"));
        this.fTxtHeader = new MJTextField();
        this.fTxtHeader.setName("Text_Header");
        this.fTxtHeader.setColumns(20);
        mJPanel5.add((Component)mJLabel7, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 0, 3), 0, 0));
        mJPanel5.add((Component)this.fTxtHeader, (Object)new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0));
        this.fTxtHeader.addActionListener((ActionListener)this);
        this.fTxtHeader.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PreviewTabLines.this.onHeaderTextChanged();
            }
        });
        this.fBtnFont = new MJButton(PrintExportPanel.sResHandle.getString("button.font"));
        this.fBtnFont.setName("Button_HeaderFont");
        mJPanel5.add((Component)this.fBtnFont, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 0, 3), 0, 0));
        this.fBtnFont.addActionListener((ActionListener)this);
        MJLabel mJLabel8 = new MJLabel(PrintExportPanel.sResHandle.getString("label.datestyle"));
        this.fComboDateStyle = new MJComboBox();
        this.fComboDateStyle.setName("Combo_DateStyle");
        this.fComboDateStyle.setEditorColumnCount(10);
        String[] stringArray = new String[]{NONE_I18N, "dd-mmm-yyyy HH:MM:SS", "dd-mmm-yyyy", "mm/dd/yy", "mm/dd", "ddd", "yyyy", "HH:MM:SS", "HH:MM:SS PM", "HH:MM PM", "dd/mm/yy", "mm/dd/yyyy", "yyyy-mm-dd", "yyyy-mm-dd HH:MM:SS"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.fComboDateStyle.addItem((Object)stringArray[i]);
        }
        mJPanel5.add((Component)mJLabel8, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(16, 3, 6, 3), 0, 0));
        mJPanel5.add((Component)this.fComboDateStyle, (Object)new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(13, 3, 6, 3), 0, 0));
        this.fComboDateStyle.addActionListener((ActionListener)this);
        MJPanel mJPanel6 = new MJPanel();
        this.add((Component)mJPanel6, new GridBagConstraints(0, n2++, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.fWidgetFontName)) {
            this.onFontNameChanged();
        } else if (object.equals(this.fRadFontSizeScreen) || object.equals(this.fRadFontSizeScale) || object.equals(this.fRadFontSizeFixed) || object.equals(this.fTextFontSizeScale) || object.equals(this.fTextFontSizeFixed)) {
            this.onFontSizeChanged();
        } else if (object.equals(this.fComboFontAngle)) {
            this.onFontAngleChanged();
        } else if (object.equals(this.fComboFontWeight)) {
            this.onFontWeightChanged();
        } else if (object.equals(this.fRadLineWidthScreen) || object.equals(this.fRadLineWidthScale) || object.equals(this.fRadLineWidthFixed) || object.equals(this.fTextLineWidthScale) || object.equals(this.fTextLineWidthFixed)) {
            this.onLineWidthChanged();
        } else if (object.equals(this.fWidgetMinLineWidth)) {
            this.onLineMinWidthChanged();
        } else if (object.equals(this.fTxtHeader)) {
            this.onHeaderTextChanged();
        } else if (object.equals(this.fBtnFont)) {
            this.onFont();
        } else if (object.equals(this.fComboDateStyle)) {
            this.onDateStyleChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (string.equals("FontName")) {
            this.setFontName((String)object);
        } else if (string.equals("FontSizeType") || string.equals("FontSize")) {
            this.setFontSize(this.fPrintSettings.getFontSizeType(), this.fPrintSettings.getFontSize());
        } else if (string.equals("FontAngle")) {
            this.setFontAngle((String)object);
        } else if (string.equals("FontWeight")) {
            this.setFontWeight((String)object);
        } else if (string.equals("LineWidthType") || string.equals("LineWidth")) {
            this.setLineWidth(this.fPrintSettings.getLineWidthType(), this.fPrintSettings.getLineWidth());
        } else if (string.equals("LineMinWidth")) {
            this.setLineMinWidth((Double)object);
        } else if (string.equals("HeaderText")) {
            this.setHeaderText((String)object);
        } else if (string.equals("HeaderDateFormat")) {
            this.setDateStyle((String)object);
        }
    }

    protected void onLineWidthChanged() {
        if (this.fRadLineWidthScreen.isSelected()) {
            this.fTextLineWidthScale.setEnabled(false);
            this.fTextLineWidthFixed.setEnabled(false);
            this.fPrintSettings.setLineWidthType(this, "screen");
        } else if (this.fRadLineWidthScale.isSelected()) {
            this.fTextLineWidthScale.setEnabled(true);
            this.fTextLineWidthFixed.setEnabled(false);
            String string = this.fTextLineWidthScale.getText().trim();
            if (string.length() == 0) {
                this.fPrintSettings.setLineWidthType(this, "screen");
            } else {
                Double d = PrintExportSettings.convertToDoubleOrZero(string);
                if (d > 0.0) {
                    boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
                    this.fPrintSettings.setLineWidthType(this, "scale");
                    this.fPrintSettings.setFireMATLABCallback(bl);
                    this.fPrintSettings.setLineWidth(this, d);
                }
            }
        } else if (this.fRadLineWidthFixed.isSelected()) {
            this.fTextLineWidthScale.setEnabled(false);
            this.fTextLineWidthFixed.setEnabled(true);
            String string = this.fTextLineWidthFixed.getText().trim();
            if (string.length() == 0) {
                this.fPrintSettings.setLineWidthType(this, "screen");
            } else {
                Double d = PrintExportSettings.convertToDoubleOrZero(string);
                if (d > 0.0) {
                    boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
                    this.fPrintSettings.setLineWidthType(this, "fixed");
                    this.fPrintSettings.setFireMATLABCallback(bl);
                    this.fPrintSettings.setLineWidth(this, d);
                }
            }
        }
    }

    protected void setLineWidth(String string, Double d) {
        this.fRadLineWidthScreen.removeActionListener((ActionListener)this);
        this.fRadLineWidthScale.removeActionListener((ActionListener)this);
        this.fRadLineWidthFixed.removeActionListener((ActionListener)this);
        this.fTextLineWidthScale.removeActionListener((ActionListener)this);
        this.fTextLineWidthFixed.removeActionListener((ActionListener)this);
        if (string.equals("screen")) {
            this.fRadLineWidthScreen.setSelected(true);
            this.fTextLineWidthScale.setEnabled(false);
            this.fTextLineWidthFixed.setEnabled(false);
        } else if (string.equals("scale")) {
            this.fRadLineWidthScale.setSelected(true);
            this.fTextLineWidthScale.setEnabled(true);
            this.fTextLineWidthFixed.setEnabled(false);
            this.fTextLineWidthScale.setText(d.toString());
        } else if (string.equals("fixed")) {
            this.fRadLineWidthFixed.setSelected(true);
            this.fTextLineWidthScale.setEnabled(false);
            this.fTextLineWidthFixed.setEnabled(true);
            this.fTextLineWidthFixed.setText(d.toString());
        }
        this.fRadLineWidthScreen.addActionListener((ActionListener)this);
        this.fRadLineWidthScale.addActionListener((ActionListener)this);
        this.fRadLineWidthFixed.addActionListener((ActionListener)this);
        this.fTextLineWidthScale.addActionListener((ActionListener)this);
        this.fTextLineWidthFixed.addActionListener((ActionListener)this);
    }

    protected void onLineMinWidthChanged() {
        Double d;
        String string = this.fWidgetMinLineWidth.getValue();
        if (string.length() == 0) {
            d = new Double(-1.0);
        } else {
            try {
                d = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fPrintSettings.setLineMinWidth(this, d);
    }

    protected void setLineMinWidth(Double d) {
        this.fWidgetMinLineWidth.removeActionListener(this);
        if (d <= 0.0) {
            this.fWidgetMinLineWidth.setValue("");
        } else {
            this.fWidgetMinLineWidth.setValue(d.toString());
        }
        this.fWidgetMinLineWidth.addActionListener(this);
    }

    protected void onFontNameChanged() {
        String string = this.fWidgetFontName.getValue();
        this.fPrintSettings.setFontName(this, string);
    }

    protected void setFontName(String string) {
        this.fWidgetFontName.removeActionListener(this);
        this.fWidgetFontName.setValue(string);
        this.fWidgetFontName.addActionListener(this);
    }

    protected void onFontSizeChanged() {
        if (this.fRadFontSizeScreen.isSelected()) {
            this.fTextFontSizeScale.setEnabled(false);
            this.fTextFontSizeFixed.setEnabled(false);
            this.fPrintSettings.setFontSizeType(this, "screen");
        } else if (this.fRadFontSizeScale.isSelected()) {
            this.fTextFontSizeScale.setEnabled(true);
            this.fTextFontSizeFixed.setEnabled(false);
            String string = this.fTextFontSizeScale.getText().trim();
            if (string.length() == 0) {
                this.fPrintSettings.setFontSizeType(this, "screen");
            } else {
                Double d = PrintExportSettings.convertToDoubleOrZero(string);
                if (d > 0.0) {
                    boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
                    this.fPrintSettings.setFontSizeType(this, "scale");
                    this.fPrintSettings.setFireMATLABCallback(bl);
                    this.fPrintSettings.setFontSize(this, d);
                }
            }
        } else if (this.fRadFontSizeFixed.isSelected()) {
            this.fTextFontSizeScale.setEnabled(false);
            this.fTextFontSizeFixed.setEnabled(true);
            String string = (String)this.fTextFontSizeFixed.getSelectedItem();
            if (string.length() == 0) {
                this.fPrintSettings.setFontSizeType(this, "screen");
            } else {
                Double d = PrintExportSettings.convertToDoubleOrZero(string);
                if (d > 0.0) {
                    boolean bl = this.fPrintSettings.setFireMATLABCallback(false);
                    this.fPrintSettings.setFontSizeType(this, "fixed");
                    this.fPrintSettings.setFireMATLABCallback(bl);
                    this.fPrintSettings.setFontSize(this, d);
                }
            }
        }
    }

    protected void setFontSize(String string, Double d) {
        this.fRadFontSizeScreen.removeActionListener((ActionListener)this);
        this.fRadFontSizeScale.removeActionListener((ActionListener)this);
        this.fRadFontSizeFixed.removeActionListener((ActionListener)this);
        this.fTextFontSizeScale.removeActionListener((ActionListener)this);
        this.fTextFontSizeFixed.removeActionListener((ActionListener)this);
        if (string.equals("screen")) {
            this.fRadFontSizeScreen.setSelected(true);
            this.fTextFontSizeScale.setEnabled(false);
            this.fTextFontSizeFixed.setEnabled(false);
        } else if (string.equals("scale")) {
            this.fRadFontSizeScale.setSelected(true);
            this.fTextFontSizeScale.setEnabled(true);
            this.fTextFontSizeFixed.setEnabled(false);
            this.fTextFontSizeScale.setText(d.toString());
        } else if (string.equals("fixed")) {
            this.fRadFontSizeFixed.setSelected(true);
            this.fTextFontSizeScale.setEnabled(false);
            this.fTextFontSizeFixed.setEnabled(true);
            this.fTextFontSizeFixed.setSelectedItem((Object)d.toString());
        }
        this.fRadFontSizeScreen.addActionListener((ActionListener)this);
        this.fRadFontSizeScale.addActionListener((ActionListener)this);
        this.fRadFontSizeFixed.addActionListener((ActionListener)this);
        this.fTextFontSizeScale.addActionListener((ActionListener)this);
        this.fTextFontSizeFixed.addActionListener((ActionListener)this);
    }

    protected void onFontAngleChanged() {
        int n = this.fComboFontAngle.getSelectedIndex();
        if (n == 0) {
            this.fPrintSettings.setFontAngle(this, "");
        } else {
            String string = (String)this.fComboFontAngle.getSelectedItem();
            string = PrintExportPanel.convertL10n(string, this.fLocalFontAngles, PrintExportSettings.MATLAB_FONTANGLES);
            this.fPrintSettings.setFontAngle(this, string);
        }
    }

    protected void setFontAngle(String string) {
        this.fComboFontAngle.removeActionListener((ActionListener)this);
        if (string.length() == 0) {
            this.fComboFontAngle.setSelectedIndex(0);
        } else {
            string = PrintExportPanel.convertL10n(string, PrintExportSettings.MATLAB_FONTANGLES, this.fLocalFontAngles);
            this.fComboFontAngle.setSelectedItem((Object)string);
        }
        this.fComboFontAngle.addActionListener((ActionListener)this);
    }

    protected void onFontWeightChanged() {
        int n = this.fComboFontWeight.getSelectedIndex();
        if (n == 0) {
            this.fPrintSettings.setFontWeight(this, "");
        } else {
            String string = (String)this.fComboFontWeight.getSelectedItem();
            string = PrintExportPanel.convertL10n(string, this.fLocalFontWeights, PrintExportSettings.MATLAB_FONTWEIGHTS);
            this.fPrintSettings.setFontWeight(this, string);
        }
    }

    protected void setFontWeight(String string) {
        this.fComboFontWeight.removeActionListener((ActionListener)this);
        if (string.length() == 0) {
            this.fComboFontWeight.setSelectedIndex(0);
        } else {
            string = PrintExportPanel.convertL10n(string, PrintExportSettings.MATLAB_FONTWEIGHTS, this.fLocalFontWeights);
            this.fComboFontWeight.setSelectedItem((Object)string);
        }
        this.fComboFontWeight.addActionListener((ActionListener)this);
    }

    protected void onHeaderTextChanged() {
        String string = this.fTxtHeader.getText();
        this.fPrintSettings.setHeaderText(this, string);
    }

    protected void setHeaderText(String string) {
        this.fTxtHeader.removeActionListener((ActionListener)this);
        this.fTxtHeader.setText(string);
        this.fTxtHeader.addActionListener((ActionListener)this);
    }

    protected void onDateStyleChanged() {
        String string = (String)this.fComboDateStyle.getSelectedItem();
        if (string.equals(NONE_I18N)) {
            string = NONE_HG;
        }
        this.fPrintSettings.setHeaderDateFormat(this, string);
    }

    protected void setDateStyle(String string) {
        this.fComboDateStyle.removeActionListener((ActionListener)this);
        if (string.equals(NONE_HG)) {
            string = NONE_I18N;
        }
        this.fComboDateStyle.setSelectedItem((Object)string);
        this.fComboDateStyle.addActionListener((ActionListener)this);
    }

    protected void onFont() {
        this.fPrintSettings.getCallback().postCallback((Object)new Object[]{"ChangeHeaderFont", this.fPrintSettings});
    }

    private static class PPDefaultCustomFontName
    extends MJPanel
    implements ActionListener {
        private MJRadioButton fRadDefault;
        private MJRadioButton fRadCustom;
        private MJComboBox fTextCustom;
        private List fVectListeners = new Vector();

        PPDefaultCustomFontName(String[] stringArray, String string) {
            this.setLayout(new GridBagLayout());
            this.fRadDefault = new MJRadioButton(PrintExportPanel.sResHandle.getString("style.default"));
            this.fRadDefault.setName("RadBtn_DefaultFont");
            this.fRadCustom = new MJRadioButton(PrintExportPanel.sResHandle.getString("style.custom"));
            this.fRadCustom.setName("RadBtn_CustomFont");
            this.fTextCustom = new MJComboBox((Object[])stringArray);
            this.fTextCustom.setName("Text_CustomFont");
            this.fTextCustom.setPreferredSize(new Dimension(70, 20));
            this.fTextCustom.setConstrainPopupWidth(false);
            this.fTextCustom.setSelectedItem((Object)string);
            this.fRadDefault.addActionListener((ActionListener)this);
            this.fRadCustom.addActionListener((ActionListener)this);
            this.fTextCustom.addActionListener((ActionListener)this);
            this.add((Component)this.fRadDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.fRadCustom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.fTextCustom, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 6), 0, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.fRadDefault);
            buttonGroup.add((AbstractButton)this.fRadCustom);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.fRadDefault)) {
                this.fTextCustom.setEnabled(false);
            } else {
                this.fTextCustom.setEnabled(true);
            }
            actionEvent.setSource(this);
            for (int i = 0; i < this.fVectListeners.size(); ++i) {
                ((ActionListener)this.fVectListeners.get(i)).actionPerformed(actionEvent);
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.fVectListeners.add(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.fVectListeners.remove(actionListener);
        }

        public void setValue(String string) {
            if (string.length() == 0) {
                this.fRadDefault.setSelected(true);
                this.fTextCustom.setEnabled(false);
            } else {
                this.fRadCustom.setSelected(true);
                this.fTextCustom.setEnabled(true);
                this.fTextCustom.setSelectedItem((Object)string);
            }
        }

        public String getValue() {
            if (this.fRadDefault.isSelected()) {
                return "";
            }
            return (String)this.fTextCustom.getSelectedItem();
        }
    }

    private static class PPDefaultCustom
    extends MJPanel
    implements ActionListener,
    FocusListener {
        private MJRadioButton fRadDefault;
        private MJRadioButton fRadCustom;
        private MJTextField fTextCustom;
        private List fVectActionListeners = new Vector();
        private List fVectFocusListeners = new Vector();

        PPDefaultCustom() {
            this.setLayout(new GridBagLayout());
            this.fRadDefault = new MJRadioButton(PrintExportPanel.sResHandle.getString("style.default"));
            this.fRadDefault.setName("RadBtn_Default");
            this.fRadCustom = new MJRadioButton(PrintExportPanel.sResHandle.getString("style.custom"));
            this.fRadCustom.setName("RadBtn_Custom");
            this.fTextCustom = new MJTextField();
            this.fTextCustom.setName("Text_Custom");
            this.fTextCustom.setColumns(4);
            this.fRadDefault.addActionListener((ActionListener)this);
            this.fRadCustom.addActionListener((ActionListener)this);
            this.fTextCustom.addActionListener((ActionListener)this);
            this.fRadDefault.addFocusListener((FocusListener)this);
            this.fRadCustom.addFocusListener((FocusListener)this);
            this.fTextCustom.addFocusListener((FocusListener)this);
            this.add((Component)this.fRadDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.fRadCustom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.fTextCustom, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 6), 0, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.fRadDefault);
            buttonGroup.add((AbstractButton)this.fRadCustom);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.fRadDefault)) {
                this.fTextCustom.setEnabled(false);
            } else {
                this.fTextCustom.setEnabled(true);
            }
            actionEvent.setSource(this);
            for (int i = 0; i < this.fVectActionListeners.size(); ++i) {
                ((ActionListener)this.fVectActionListeners.get(i)).actionPerformed(actionEvent);
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.fVectActionListeners.add(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.fVectActionListeners.remove(actionListener);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            focusEvent.setSource(this);
            for (int i = 0; i < this.fVectFocusListeners.size(); ++i) {
                ((FocusListener)this.fVectFocusListeners.get(i)).focusLost(focusEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            focusEvent.setSource(this);
            for (int i = 0; i < this.fVectFocusListeners.size(); ++i) {
                ((FocusListener)this.fVectFocusListeners.get(i)).focusGained(focusEvent);
            }
        }

        public void addSubcomponentFocusListener(FocusListener focusListener) {
            this.fVectFocusListeners.add(focusListener);
        }

        public void removeSubcomponentFocusListener(FocusListener focusListener) {
            this.fVectFocusListeners.remove(focusListener);
        }

        public void setValue(String string) {
            if (string.length() == 0) {
                this.fRadDefault.setSelected(true);
                this.fTextCustom.setEnabled(false);
            } else {
                this.fRadCustom.setSelected(true);
                this.fTextCustom.setEnabled(true);
                this.fTextCustom.setText(string);
            }
        }

        public String getValue() {
            if (this.fRadDefault.isSelected()) {
                return "";
            }
            return this.fTextCustom.getText();
        }
    }
}

