/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.datamgr.utils;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.datamgr.utils.FigureBanner;
import com.mathworks.page.datamgr.utils.IFigureBanner;
import com.mathworks.page.datamgr.utils.JFigureBanner;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnimatedFigureBanner {
    public int fIncrement = 1;
    public Timer fAnimationTimer;
    public IFigureBanner fHostPanel;

    public AnimatedFigureBanner(MJPanel mJPanel) {
        this.fHostPanel = PlatformInfo.isIntelMac() ? new JFigureBanner((Component)mJPanel) : new FigureBanner((JComponent)mJPanel);
        this.fAnimationTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnimatedFigureBanner.this.animate();
            }
        });
    }

    public IFigureBanner getHostPanel() {
        return this.fHostPanel;
    }

    private void animate() {
        Point point = this.fHostPanel.getVertex();
        point.y += this.fIncrement;
        if (point.y >= -this.fHostPanel.getH() && point.y <= 0) {
            this.fHostPanel.setVertex(point);
            this.fHostPanel.autoLocate();
        } else {
            this.fAnimationTimer.stop();
        }
    }

    public void open() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.utOpen();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnimatedFigureBanner.this.utOpen();
                }
            });
        }
    }

    private void utOpen() {
        Point point = this.fHostPanel.getVertex();
        if (point.y >= 0) {
            return;
        }
        point.y = -this.fHostPanel.getH();
        this.fHostPanel.setVertex(point);
        this.fIncrement = 2;
        this.fHostPanel.autoLocate();
        if (!this.fAnimationTimer.isRunning()) {
            this.fAnimationTimer.start();
        }
    }

    public void close() {
        if (this.fHostPanel.getVertex().y < -this.fHostPanel.getH()) {
            return;
        }
        this.fIncrement = -2;
        if (!this.fAnimationTimer.isRunning()) {
            this.fAnimationTimer.start();
        }
    }

    public void addPaneltoFigure() {
        Point point = this.fHostPanel.getVertex();
        point.y = -this.fHostPanel.getH();
        this.fHostPanel.setVertex(point);
    }
}

