/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.browser;

import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.testmeas.browser.Browser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserDecoration;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.DetailView;
import com.mathworks.toolbox.testmeas.browser.TreeView;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BrowserTreeDetail {
    public static final int TREE = 0;
    public static final int BOTH = 1;
    private BrowserClient[] clients = null;
    private TreeView treeView = null;
    private DetailView detailView = null;
    private TMHelpViewer helpPanel = null;
    private BrowserTreeNode rootNode = null;
    private int layout = 1;
    private String title = "";
    private ImageIcon icon = null;
    private boolean showRootNode = true;
    private boolean addScrollPaneDP = true;
    private boolean okToHilite = true;
    private BrowserDecoration browserDecorationDP = null;
    private BrowserDecoration browserDecorationTV = null;
    private boolean okToUpdateDecorationDP = true;
    private Browser browser;

    public BrowserTreeDetail(Browser browser, int n, BrowserClient[] browserClientArray, BrowserTreeNode browserTreeNode) {
        this.browser = browser;
        this.clients = browserClientArray;
        this.rootNode = browserTreeNode;
        this.layout = n;
        if (this.rootNode == null) {
            this.showRootNode = false;
            this.rootNode = new BrowserTreeNode("temp", null);
        }
        this.treeView = new TreeView(browser, this.rootNode);
        this.treeView.setRootVisible(this.showRootNode);
        if (this.layout == 1) {
            this.detailView = new DetailView();
        }
    }

    protected void init(Browser browser, BrowserConfigFileReader browserConfigFileReader) {
        int n;
        for (n = 0; n < this.clients.length; ++n) {
            this.clients[n].addTreeViewListener(this.treeView);
            this.clients[n].addBrowserListener(browser);
        }
        for (n = 0; n < this.clients.length; ++n) {
            this.treeView.addParentandChildNodes(this.clients[n].getRootNode(), this.clients[n].getLevelOneNodes());
        }
        for (n = 0; n < this.clients.length; ++n) {
            this.clients[n].init();
            if (browserConfigFileReader == null) continue;
            this.clients[n].load(browserConfigFileReader, browserConfigFileReader.getToolboxNode(TMStringUtil.strrep(this.clients[n].getToolboxName(), " ", "")));
        }
        if (this.layout == 1) {
            if (this.rootNode.getPanel() == null) {
                this.detailView.clearView();
            } else {
                this.detailView.updateView(this.rootNode.getPanel(), this.rootNode);
            }
        }
    }

    protected void cleanup(Browser browser, BrowserConfigFileWriter browserConfigFileWriter) {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].removeTreeViewListener(this.treeView);
            this.clients[i].removeBrowserListener(browser);
            if (browserConfigFileWriter != null) {
                this.clients[i].save(browserConfigFileWriter, browserConfigFileWriter.addToolboxNode(TMStringUtil.strrep(this.clients[i].getToolboxName(), " ", "")));
            }
            this.clients[i].cleanup();
            this.clients[i].setBrowser(null);
            this.clients[i] = null;
        }
        this.clients = null;
        this.treeView.cleanup();
        if (this.helpPanel != null) {
            this.helpPanel.getHelpPanel().dispose();
        }
    }

    protected void update(BrowserClient browserClient, BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        if (browserClient == null) {
            return;
        }
        if (this.browserDecorationDP != null && this.okToUpdateDecorationDP) {
            this.browserDecorationDP.setText(browserTreeNode.getName().replace("&&", "&"), browserTreeNode.getIcon());
        }
        if (browserTreeNode2 != null && browserTreeNode2.getClient() != null) {
            browserTreeNode2.getClient().cleanupNode(browserTreeNode, browserTreeNode2, browserTreeNodeArray);
        }
        JPanel jPanel = browserClient.getPanel(browserTreeNode, browserTreeNode2, browserTreeNodeArray);
        if (browserTreeNode.getShowHelpOnly() && this.browser.getBrowserLayout() != 1) {
            if (this.helpPanel == null) {
                this.helpPanel = TMHelpViewer.getNewInstance();
            }
            this.helpPanel.update(browserTreeNode.getHelpDirectory(), browserTreeNode.getHelpPage(), "");
            jPanel = this.helpPanel;
        }
        if (browserTreeNode.isPanelUpdated() && this.detailView != null) {
            if (jPanel != null) {
                this.detailView.updateView(jPanel, browserTreeNode);
            } else {
                this.detailView.clearView();
            }
        }
    }

    protected void selectTreeView(boolean bl) {
        if (this.okToHilite) {
            this.browserDecorationTV.selectDecoration(bl);
        }
    }

    public boolean contains(BrowserClient browserClient) {
        for (int i = 0; i < this.clients.length; ++i) {
            if (this.clients[i] != browserClient) continue;
            return true;
        }
        return false;
    }

    protected void setBrowser(Browser browser) {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].setBrowser(browser);
        }
    }

    protected void addToolbarButtons(MJToolBar mJToolBar) {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].addToolbarButtons(mJToolBar);
        }
    }

    protected int addHelpMenu(JMenu jMenu, int n) {
        for (int i = 0; i < this.clients.length; ++i) {
            JMenuItem jMenuItem = this.clients[i].getHelpMenuItem();
            if (jMenuItem == null) continue;
            jMenu.insert(jMenuItem, n);
            ++n;
        }
        return n;
    }

    protected void addAboutMenu(JMenu jMenu) {
        for (int i = 0; i < this.clients.length; ++i) {
            JMenuItem jMenuItem = this.clients[i].getAboutMenuItem();
            if (jMenuItem == null) continue;
            jMenu.add(jMenuItem);
        }
    }

    protected void refresh() {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].refresh();
        }
    }

    public void addDVToScrollPane(boolean bl) {
        this.addScrollPaneDP = bl;
    }

    protected void showRootNode(boolean bl) {
        this.showRootNode = bl;
        if (this.treeView != null) {
            this.treeView.setRootVisible(this.showRootNode);
        }
    }

    public BrowserClient[] getBrowserClients() {
        return this.clients;
    }

    public DetailView getDetailView() {
        return this.detailView;
    }

    protected JComponent getDetailViewComponent() {
        if (this.layout == 0) {
            return null;
        }
        if (!this.addScrollPaneDP) {
            return this.detailView;
        }
        return new JScrollPane(this.detailView);
    }

    protected void setDecorationOnDetailPanel(BrowserDecoration browserDecoration) {
        this.browserDecorationDP = browserDecoration;
    }

    public BrowserDecoration getDecorationOnDetailPanel() {
        return this.browserDecorationDP;
    }

    public void okToUpdateDecorationDP(boolean bl) {
        this.okToUpdateDecorationDP = bl;
    }

    public int getLayout() {
        return this.layout;
    }

    protected void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public BrowserTreeNode getRootNode() {
        return this.rootNode;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    protected JComponent getTreeViewComponent() {
        if (this.title.equals("")) {
            return new JScrollPane(this.treeView);
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.browserDecorationTV = new BrowserDecoration(this.title, this.icon, false);
        this.browserDecorationTV.setName(this.title + " Tree View Decoration");
        jPanel.add((Component)this.browserDecorationTV, "North");
        jPanel.add((Component)new JScrollPane(this.treeView), "Center");
        return jPanel;
    }

    public BrowserDecoration getTreeViewBrowserDecoration() {
        return this.browserDecorationTV;
    }

    public void okToHiliteTreeView(boolean bl) {
        this.okToHilite = bl;
    }
}

